/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xmlet.xsdparser.core.utils.ConfigEntryData;
import org.xmlet.xsdparser.core.utils.DefaultParserConfig;
import org.xmlet.xsdparser.core.utils.NamespaceInfo;
import org.xmlet.xsdparser.core.utils.ParserConfig;
import org.xmlet.xsdparser.core.utils.UnsolvedReferenceItem;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdImport;
import org.xmlet.xsdparser.xsdelements.XsdInclude;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.exceptions.ParentAvailableException;

public abstract class XsdParserCore {
    static Map<String, ConfigEntryData> parseMappers;
    private static Map<String, String> xsdTypesToJava;
    public Map<String, List<ReferenceBase>> parseElements = new HashMap<String, List<ReferenceBase>>();
    private Map<String, List<UnsolvedReference>> unsolvedElements = new HashMap<String, List<UnsolvedReference>>();
    private List<UnsolvedReferenceItem> parserUnsolvedElementsMap = new ArrayList<UnsolvedReferenceItem>();
    List<String> schemaLocations = new ArrayList<String>();
    Map<String, String> schemaLocationsMap = new HashMap<String, String>();
    protected String currentFile;

    boolean isXsdSchema(Node node) {
        String schemaNodeName = node.getNodeName();
        return schemaNodeName.equals("xsd:schema") || schemaNodeName.equals("xs:schema") || schemaNodeName.equals("schema");
    }

    void resolveRefs() {
        this.resolveInnerRefs();
        this.resolveOtherNamespaceRefs();
    }

    private void resolveOtherNamespaceRefs() {
        List schemas = this.getResultXsdSchemas().collect(Collectors.toList());
        for (XsdSchema schema : schemas) {
            List imports = schema.getChildrenImports().collect(Collectors.toList());
            for (XsdImport xsdImport : imports) {
                schema.resolveNameSpace(xsdImport.getNamespace(), xsdImport.getSchemaLocation());
            }
            Map<String, NamespaceInfo> ns = schema.getNamespaces();
            for (Map.Entry<String, NamespaceInfo> e : ns.entrySet()) {
                schema.resolveNameSpace(e.getKey(), schema.getFilePath().substring(schema.getFilePath().lastIndexOf("/") + 1));
            }
        }
        this.parseElements.keySet().forEach(fileName -> {
            XsdSchema xsdSchema = this.parseElements.get(fileName).stream().filter(referenceBase -> referenceBase instanceof ConcreteElement && referenceBase.getElement() instanceof XsdSchema).map(referenceBase -> (XsdSchema)referenceBase.getElement()).findFirst().get();
            Map<String, NamespaceInfo> ns = xsdSchema.getNamespaces();
            List unsolvedReferenceList = ((List)this.unsolvedElements.getOrDefault(fileName, new ArrayList())).stream().filter(unsolvedElement -> unsolvedElement.getRef().contains(":")).collect(Collectors.toList());
            long startingUnsolvedReferenceListSize = unsolvedReferenceList.size();
            boolean solveMore = true;
            do {
                for (UnsolvedReference unsolvedReference : unsolvedReferenceList) {
                    List<ReferenceBase> importedElements;
                    String unsolvedElementNamespace = unsolvedReference.getRef().substring(0, unsolvedReference.getRef().indexOf(":"));
                    Optional<String> foundNamespaceId = ns.keySet().stream().filter(namespaceId -> namespaceId.equals(unsolvedElementNamespace)).findFirst();
                    if (!foundNamespaceId.isPresent()) continue;
                    NamespaceInfo namespaceInfo = ns.get(foundNamespaceId.get());
                    XsdSchema unsolvedElementSchema = unsolvedReference.getElement().getXsdSchema();
                    if (unsolvedElementSchema != null && unsolvedElementSchema.getTargetNamespace() != null && unsolvedElementSchema.getTargetNamespace().equals(namespaceInfo.getName())) {
                        importedElements = unsolvedElementSchema.getElements();
                    } else {
                        String importedFileLocation = ns.get(foundNamespaceId.get()).getFile();
                        String importedFileName = importedFileLocation;
                        if (this.isRelativePath(importedFileName)) {
                            String parentFile = this.schemaLocationsMap.get(importedFileName);
                            if (parentFile == null) {
                                parentFile = fileName;
                            }
                            importedFileName = parentFile.substring(0, parentFile.lastIndexOf(47) + 1).concat(importedFileName);
                        }
                        String finalImportedFileName = importedFileName;
                        importedElements = this.parseElements.getOrDefault(importedFileLocation, this.parseElements.get(this.parseElements.keySet().stream().filter(k -> this.cleanPath((String)k).endsWith(this.cleanPath(finalImportedFileName))).findFirst().orElse(null)));
                    }
                    Map<String, List<NamedConcreteElement>> concreteElementsMap = importedElements.stream().filter(concreteElement -> concreteElement instanceof NamedConcreteElement).map(concreteElement -> (NamedConcreteElement)concreteElement).collect(Collectors.groupingBy(NamedConcreteElement::getName));
                    this.replaceUnsolvedImportedReference(concreteElementsMap, unsolvedReference, (String)fileName);
                }
                unsolvedReferenceList = ((List)this.unsolvedElements.getOrDefault(fileName, new ArrayList())).stream().filter(unsolvedElement -> unsolvedElement.getRef().contains(":")).collect(Collectors.toList());
                long currentUnsolvedReferenceListSize = unsolvedReferenceList.size();
                if (currentUnsolvedReferenceListSize == startingUnsolvedReferenceListSize) {
                    solveMore = false;
                }
                startingUnsolvedReferenceListSize = currentUnsolvedReferenceListSize;
            } while (solveMore);
        });
    }

    private void replaceUnsolvedImportedReference(Map<String, List<NamedConcreteElement>> concreteElementsMap, UnsolvedReference unsolvedReference, String fileName) {
        List<NamedConcreteElement> concreteElements = concreteElementsMap.get(unsolvedReference.getRef().substring(unsolvedReference.getRef().indexOf(":") + 1));
        if (concreteElements != null) {
            Map<String, String> oldElementAttributes = unsolvedReference.getElement().getAttributesMap();
            for (NamedConcreteElement concreteElement : concreteElements) {
                NamedConcreteElement substitutionElementWrapper;
                if (!unsolvedReference.isTypeRef()) {
                    XsdNamedElements substitutionElement = (XsdNamedElements)concreteElement.getElement().clone(oldElementAttributes, concreteElement.getElement().getParent());
                    substitutionElementWrapper = (NamedConcreteElement)ReferenceBase.createFromXsd(substitutionElement);
                } else {
                    substitutionElementWrapper = concreteElement;
                }
                unsolvedReference.getParent().replaceUnsolvedElements(substitutionElementWrapper);
            }
            this.unsolvedElements.get(fileName).remove(unsolvedReference);
        } else {
            this.storeUnsolvedItem(unsolvedReference);
        }
    }

    private String cleanPath(String pathValue) {
        List<String> source = Arrays.asList(pathValue.split("/"));
        ArrayList<String> results = new ArrayList<String>(source);
        int index = 0;
        for (String value : source) {
            if (value.equals("..")) {
                results.remove(index);
                if (index <= 0) continue;
                results.remove(index - 1);
                --index;
                continue;
            }
            ++index;
        }
        return results.stream().map(Object::toString).collect(Collectors.joining("/"));
    }

    private void resolveInnerRefs() {
        int i;
        ArrayList<Boolean> doneList = new ArrayList<Boolean>();
        ArrayList<String> fileNameList = new ArrayList<String>(this.parseElements.keySet());
        for (i = 0; i < fileNameList.size(); ++i) {
            doneList.add(false);
        }
        while (doneList.contains(Boolean.FALSE)) {
            for (i = 0; i < fileNameList.size(); ++i) {
                String fileName = fileNameList.get(i);
                if (((Boolean)doneList.get(i)).booleanValue()) continue;
                List includedFiles = this.parseElements.get(fileName).stream().filter(referenceBase -> referenceBase instanceof ConcreteElement && referenceBase.getElement() instanceof XsdInclude).map(referenceBase -> ((XsdInclude)referenceBase.getElement()).getSchemaLocation()).collect(Collectors.toList());
                HashSet transitiveIncludes = new HashSet();
                for (String includedFile2 : includedFiles) {
                    this.parseElements.keySet().stream().filter(fileNameAux -> fileNameAux.endsWith(includedFile2)).findFirst().ifPresent(fullIncludedFileName -> transitiveIncludes.addAll(this.parseElements.get(fullIncludedFileName).stream().filter(referenceBase -> referenceBase instanceof ConcreteElement && referenceBase.getElement() instanceof XsdInclude).map(referenceBase -> ((XsdInclude)referenceBase.getElement()).getSchemaLocation()).collect(Collectors.toList())));
                }
                includedFiles.addAll(transitiveIncludes);
                includedFiles.addAll(this.getResultXsdSchemas().filter(schema -> schema.getChildrenIncludes().anyMatch(xsdInclude -> xsdInclude.getSchemaLocation().equals(fileName))).map(XsdSchema::getFilePath).distinct().collect(Collectors.toList()));
                includedFiles = includedFiles.stream().distinct().collect(Collectors.toList());
                ArrayList includedElements = new ArrayList(this.parseElements.get(fileName));
                includedFiles.stream().filter(Objects::nonNull).forEach(includedFile -> {
                    String includedFilename = includedFile.substring(includedFile.lastIndexOf("/") + 1);
                    includedElements.addAll(this.parseElements.getOrDefault(includedFile, this.parseElements.get(this.parseElements.keySet().stream().filter(k -> k.endsWith(includedFilename)).findFirst().get())));
                });
                Map<String, List<NamedConcreteElement>> concreteElementsMap = includedElements.stream().filter(concreteElement -> concreteElement instanceof NamedConcreteElement).map(concreteElement -> (NamedConcreteElement)concreteElement).collect(Collectors.groupingBy(NamedConcreteElement::getName));
                List unsolvedReferenceList = ((List)this.unsolvedElements.getOrDefault(fileName, new ArrayList())).stream().filter(unsolvedElement -> !unsolvedElement.getRef().contains(":")).collect(Collectors.toList());
                long startingUnsolvedReferenceListSize = unsolvedReferenceList.size();
                long currentUnsolvedReferenceListSize = 0L;
                boolean solveMore = true;
                boolean doneSomething = false;
                do {
                    unsolvedReferenceList = unsolvedReferenceList.stream().filter(u -> this.parserUnsolvedElementsMap.stream().noneMatch(u1 -> u == u1.getUnsolvedReference())).collect(Collectors.toList());
                    for (UnsolvedReference unsolvedReference : unsolvedReferenceList) {
                        doneSomething = true;
                        this.replaceUnsolvedReference(concreteElementsMap, unsolvedReference, fileName);
                    }
                    unsolvedReferenceList = ((List)this.unsolvedElements.getOrDefault(fileName, new ArrayList())).stream().filter(unsolvedElement -> !unsolvedElement.getRef().contains(":")).collect(Collectors.toList());
                    currentUnsolvedReferenceListSize = unsolvedReferenceList.size();
                    if (currentUnsolvedReferenceListSize == startingUnsolvedReferenceListSize) {
                        solveMore = false;
                    }
                    startingUnsolvedReferenceListSize = currentUnsolvedReferenceListSize;
                } while (solveMore);
                doneList.set(i, true);
                if (!doneSomething) continue;
                for (String includedFile3 : includedFiles) {
                    int idx = fileNameList.indexOf(includedFile3);
                    if (idx == -1) continue;
                    doneList.set(idx, false);
                }
            }
        }
    }

    private void replaceUnsolvedReference(Map<String, List<NamedConcreteElement>> concreteElementsMap, UnsolvedReference unsolvedReference, String fileName) {
        List<NamedConcreteElement> concreteElements = concreteElementsMap.get(unsolvedReference.getRef());
        if (concreteElements != null) {
            HashMap<String, String> oldElementAttributes = new HashMap<String, String>(unsolvedReference.getElement().getAttributesMap());
            for (NamedConcreteElement concreteElement : concreteElements) {
                NamedConcreteElement substitutionElementWrapper;
                if (!unsolvedReference.isTypeRef()) {
                    XsdNamedElements substitutionElement = (XsdNamedElements)concreteElement.getElement().clone(oldElementAttributes, concreteElement.getElement().getParent());
                    substitutionElementWrapper = (NamedConcreteElement)ReferenceBase.createFromXsd(substitutionElement);
                } else {
                    substitutionElementWrapper = concreteElement;
                }
                unsolvedReference.getParent().replaceUnsolvedElements(substitutionElementWrapper);
            }
            this.unsolvedElements.get(fileName).remove(unsolvedReference);
        } else {
            this.storeUnsolvedItem(unsolvedReference);
        }
    }

    private void storeUnsolvedItem(UnsolvedReference unsolvedReference) {
        if (this.parserUnsolvedElementsMap.isEmpty()) {
            this.parserUnsolvedElementsMap.add(new UnsolvedReferenceItem(unsolvedReference));
        } else {
            Optional<UnsolvedReferenceItem> innerEntry = this.parserUnsolvedElementsMap.stream().filter(unsolvedReferenceObj -> unsolvedReferenceObj.getUnsolvedReference().getRef().equals(unsolvedReference.getRef())).findFirst();
            if (innerEntry.isPresent()) {
                innerEntry.ifPresent(entry -> entry.getParents().add(unsolvedReference.getParent()));
            } else {
                this.parserUnsolvedElementsMap.add(new UnsolvedReferenceItem(unsolvedReference));
            }
        }
    }

    public List<UnsolvedReferenceItem> getUnsolvedReferences() {
        return this.parserUnsolvedElementsMap;
    }

    public Stream<XsdElement> getResultXsdElements() {
        ArrayList elements = new ArrayList();
        this.getResultXsdSchemas().forEach(schema -> schema.getChildrenElements().forEach(elements::add));
        return elements.stream();
    }

    public Stream<XsdSchema> getResultXsdSchemas() {
        return this.parseElements.values().stream().flatMap(Collection::stream).filter(element -> element.getElement() instanceof XsdSchema).map(element -> (XsdSchema)element.getElement());
    }

    public void addUnsolvedReference(UnsolvedReference unsolvedReference) {
        String schemaFilePath;
        XsdSchema schema;
        try {
            schema = XsdAbstractElement.getXsdSchema(unsolvedReference.getElement(), new ArrayList<XsdAbstractElement>());
        }
        catch (ParentAvailableException e) {
            schema = null;
        }
        String localCurrentFile = this.currentFile;
        if (schema != null && !localCurrentFile.equals(schemaFilePath = schema.getFilePath())) {
            localCurrentFile = schemaFilePath;
        }
        List unsolved = this.unsolvedElements.computeIfAbsent(localCurrentFile, k -> new ArrayList());
        unsolved.add(unsolvedReference);
    }

    public void addFileToParse(String schemaLocation) {
        String fullSchemaLocation = this.currentFile.substring(0, this.currentFile.lastIndexOf(47) + 1) + schemaLocation;
        boolean urlSchemaLoction = false;
        urlSchemaLoction = schemaLocation.startsWith("http");
        if (!this.schemaLocations.contains(urlSchemaLoction ? schemaLocation : (fullSchemaLocation = this.cleanPath(fullSchemaLocation))) && schemaLocation.endsWith(".xsd")) {
            if (urlSchemaLoction) {
                this.schemaLocations.add(schemaLocation);
                this.schemaLocationsMap.put(schemaLocation, this.currentFile);
            } else {
                this.schemaLocations.add(fullSchemaLocation);
                this.schemaLocationsMap.put(fullSchemaLocation, this.currentFile);
            }
        }
    }

    public static Map<String, String> getXsdTypesToJava() {
        return xsdTypesToJava;
    }

    public static Map<String, ConfigEntryData> getParseMappers() {
        return parseMappers;
    }

    public void addParsedElement(ReferenceBase wrappedElement) {
        List elements = this.parseElements.computeIfAbsent(this.currentFile, k -> new ArrayList());
        elements.add(wrappedElement);
    }

    static void updateConfig(ParserConfig config) {
        xsdTypesToJava = config.getXsdTypesToJava();
        parseMappers = config.getParseMappers();
    }

    protected boolean isRelativePath(String filePath) {
        return !filePath.matches(".*:.*");
    }

    protected DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder();
    }

    static {
        DefaultParserConfig config = new DefaultParserConfig();
        parseMappers = config.getParseMappers();
        xsdTypesToJava = config.getXsdTypesToJava();
    }
}

