/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ConfigEntryData;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.XsdSchema;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.exceptions.ParentAvailableException;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public abstract class XsdAbstractElement {
    protected Map<String, String> attributesMap;
    public static final String ATTRIBUTE_FORM_DEFAULT = "attribtueFormDefault";
    public static final String ELEMENT_FORM_DEFAULT = "elementFormDefault";
    public static final String BLOCK_DEFAULT = "blockDefault";
    public static final String FINAL_DEFAULT = "finalDefault";
    public static final String TARGET_NAMESPACE = "targetNamespace";
    public static final String VERSION = "version";
    public static final String XMLNS = "xmlns";
    public static final String ID_TAG = "id";
    public static final String NAME_TAG = "name";
    public static final String ABSTRACT_TAG = "abstract";
    public static final String DEFAULT_ELEMENT_TAG = "defaultElement";
    public static final String FIXED_TAG = "fixed";
    public static final String TYPE_TAG = "type";
    public static final String MIXED_TAG = "mixed";
    public static final String BLOCK_TAG = "block";
    public static final String FINAL_TAG = "final";
    public static final String USE_TAG = "use";
    public static final String SUBSTITUTION_GROUP_TAG = "substitutionGroup";
    public static final String DEFAULT_TAG = "default";
    public static final String FORM_TAG = "form";
    public static final String NILLABLE_TAG = "nillable";
    public static final String MIN_OCCURS_TAG = "minOccurs";
    public static final String MAX_OCCURS_TAG = "maxOccurs";
    public static final String ITEM_TYPE_TAG = "itemType";
    public static final String BASE_TAG = "base";
    public static final String SOURCE_TAG = "source";
    public static final String XML_LANG_TAG = "xml:lang";
    public static final String MEMBER_TYPES_TAG = "memberTypes";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    public static final String NAMESPACE = "namespace";
    public static final String REF_TAG = "ref";
    protected static final String VALUE_TAG = "value";
    XsdAbstractElement parent;
    XsdParserCore parser;
    XsdAbstractElementVisitor visitor;
    XsdAbstractElement cloneOf;
    public boolean parentAvailable;
    protected final Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction;

    protected XsdAbstractElement(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        this.parser = parser;
        this.attributesMap = attributesMap;
        this.visitorFunction = visitorFunction;
        if (visitorFunction != null) {
            this.visitor = visitorFunction.apply(this);
        }
    }

    public Map<String, String> getAttributesMap() {
        return this.attributesMap;
    }

    public XsdAbstractElementVisitor getVisitor() {
        return this.visitor;
    }

    public void validateSchemaRules() {
    }

    public void accept(XsdAbstractElementVisitor xsdAbstractElementVisitor) {
        this.setParent(xsdAbstractElementVisitor.getOwner());
    }

    public List<ReferenceBase> getElements() {
        return Collections.emptyList();
    }

    public XsdAbstractElement clone(@NotNull Map<String, String> placeHolderAttributes) {
        return this;
    }

    public XsdAbstractElement clone(@NotNull Map<String, String> placeHolderAttributes, XsdAbstractElement parent) {
        XsdAbstractElement clone = this.clone(placeHolderAttributes);
        clone.setParent(parent);
        return clone;
    }

    public Stream<XsdAbstractElement> getXsdElements() {
        List<ReferenceBase> elements = this.getElements();
        if (elements == null) {
            return new ArrayList().stream();
        }
        return elements.stream().filter(element -> element instanceof ConcreteElement).map(ReferenceBase::getElement);
    }

    public XsdSchema getXsdSchema() {
        XsdSchema schema = null;
        try {
            schema = XsdAbstractElement.getXsdSchema(this, new ArrayList<XsdAbstractElement>());
        }
        catch (ParentAvailableException e) {
            return null;
        }
        if (schema == null) {
            throw new ParsingException("The parent is null while searching for the XsdSchema. Please submit an issue with the xsd file being parsed to the project page.");
        }
        return schema;
    }

    public static XsdSchema getXsdSchema(XsdAbstractElement element, List<XsdAbstractElement> hierarchy) {
        if (element == null) {
            return null;
        }
        if (hierarchy.contains(element)) {
            throw new ParsingException("There is a circular reference in the Xsd Element tree. Please submit an issue with the xsd file being parsed to the project page.");
        }
        if (element instanceof XsdSchema) {
            return (XsdSchema)element;
        }
        hierarchy.add(element);
        return XsdAbstractElement.getXsdSchema(element.getParent(true), hierarchy);
    }

    public static ReferenceBase xsdParseSkeleton(Node node, XsdAbstractElement element) {
        XsdParserCore parser = element.getParser();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            ConfigEntryData configEntryData = XsdParserCore.getParseMappers().get(nodeName);
            if (configEntryData == null || configEntryData.parserFunction == null) continue;
            XsdAbstractElement childElement = configEntryData.parserFunction.apply(new ParseData(parser, child, configEntryData.visitorFunction)).getElement();
            childElement.accept(element.getVisitor());
            childElement.validateSchemaRules();
        }
        ReferenceBase wrappedElement = ReferenceBase.createFromXsd(element);
        parser.addParsedElement(wrappedElement);
        return wrappedElement;
    }

    public XsdParserCore getParser() {
        return this.parser;
    }

    protected static Map<String, String> convertNodeMap(NamedNodeMap nodeMap) {
        HashMap<String, String> attributesMapped = new HashMap<String, String>();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node node = nodeMap.item(i);
            attributesMapped.put(node.getNodeName(), node.getNodeValue());
        }
        return attributesMapped;
    }

    public void replaceUnsolvedElements(NamedConcreteElement element) {
        List<ReferenceBase> elements = this.getElements();
        if (elements != null) {
            elements.stream().filter(referenceBase -> referenceBase instanceof UnsolvedReference).map(referenceBase -> (UnsolvedReference)referenceBase).filter(unsolvedReference -> XsdAbstractElement.compareReference(element, unsolvedReference)).findFirst().ifPresent(oldElement -> elements.set(elements.indexOf(oldElement), ReferenceBase.clone(this.parser, element, oldElement.getParent())));
        }
    }

    public static boolean compareReference(NamedConcreteElement element, UnsolvedReference reference) {
        return XsdAbstractElement.compareReference(element, reference.getRef());
    }

    static boolean compareReference(NamedConcreteElement element, String unsolvedRef) {
        if (unsolvedRef.contains(":")) {
            unsolvedRef = unsolvedRef.substring(unsolvedRef.indexOf(":") + 1);
        }
        return element.getName().equals(unsolvedRef);
    }

    public XsdAbstractElement getParent() {
        return this.getParent(false);
    }

    public XsdAbstractElement getParent(boolean enforceParentAvailability) {
        if (!this.parentAvailable) {
            if (enforceParentAvailability) {
                throw new ParentAvailableException("The parent of this element isn't available to avoid circular memory dependencies.");
            }
            return null;
        }
        return this.parent;
    }

    public XsdAbstractElement getCloneOf() {
        return this.cloneOf;
    }

    public void setCloneOf(XsdAbstractElement cloneOf) {
        this.cloneOf = cloneOf;
    }

    public void setParent(XsdAbstractElement parent) {
        this.parent = parent;
        this.parentAvailable = true;
    }

    public void setParentAvailable(boolean parentAvailable) {
        this.parentAvailable = parentAvailable;
    }

    static String xsdRawContentParse(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList children = node.getChildNodes();
        try {
            for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                Node child = children.item(childIndex);
                StringWriter writer = new StringWriter();
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer = factory.newTransformer();
                transformer.transform(new DOMSource(child), new StreamResult(writer));
                String output = writer.toString().trim();
                output = output.substring(output.indexOf(62) + 1).trim();
                stringBuilder.append(output);
            }
        }
        catch (Exception e) {
            throw new ParsingException(e.getMessage());
        }
        return stringBuilder.toString();
    }
}

