/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public class XsdAttributeGroup
extends XsdNamedElements {
    public static final String XSD_TAG = "xsd:attributeGroup";
    public static final String XS_TAG = "xs:attributeGroup";
    public static final String TAG = "attributeGroup";
    private List<ReferenceBase> attributeGroups = new ArrayList<ReferenceBase>();
    private List<ReferenceBase> attributes = new ArrayList<ReferenceBase>();

    private XsdAttributeGroup(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
    }

    private XsdAttributeGroup(XsdAbstractElement parent, @NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        this.setParent(parent);
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public List<ReferenceBase> getElements() {
        ArrayList<ReferenceBase> allAttributes = new ArrayList<ReferenceBase>();
        this.getXsdAttributeGroups().forEach(attributeGroup -> allAttributes.addAll(attributeGroup.getElements()));
        allAttributes.addAll(this.attributes);
        return allAttributes;
    }

    @Override
    public XsdNamedElements clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        placeHolderAttributes.remove("ref");
        XsdAttributeGroup elementCopy = new XsdAttributeGroup(this.parent, this.parser, placeHolderAttributes, this.visitorFunction);
        elementCopy.attributes = this.attributes.stream().map(attributeReference -> ReferenceBase.clone(this.parser, attributeReference, elementCopy)).collect(Collectors.toList());
        elementCopy.attributeGroups = this.attributeGroups.stream().map(attributeGroupReference -> ReferenceBase.clone(this.parser, attributeGroupReference, elementCopy)).collect(Collectors.toList());
        elementCopy.cloneOf = this;
        elementCopy.parent = null;
        return elementCopy;
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement element) {
        Optional<ReferenceBase> attributeGroupUnsolvedReference;
        if (element.getElement() instanceof XsdAttributeGroup && (attributeGroupUnsolvedReference = this.attributeGroups.stream().filter(attributeGroup -> attributeGroup instanceof UnsolvedReference && ((UnsolvedReference)attributeGroup).getRef().equals(element.getName())).findFirst()).isPresent()) {
            this.attributeGroups.remove(attributeGroupUnsolvedReference.get());
            this.attributeGroups.add(element);
        }
    }

    public Stream<XsdAttributeGroup> getXsdAttributeGroups() {
        return this.attributeGroups.stream().filter(element -> element.getElement() instanceof XsdAttributeGroup).map(element -> (XsdAttributeGroup)element.getElement());
    }

    public Stream<XsdAttributeGroup> getAllXsdAttributeGroups() {
        ArrayList<XsdAttributeGroup> a = new ArrayList<XsdAttributeGroup>();
        for (XsdAttributeGroup attributeGroup : this.attributeGroups.stream().filter(element -> element.getElement() instanceof XsdAttributeGroup).map(element -> (XsdAttributeGroup)element.getElement()).collect(Collectors.toList())) {
            a.add(attributeGroup);
            a.addAll(attributeGroup.getAllXsdAttributeGroups().collect(Collectors.toList()));
        }
        return a.stream();
    }

    public Stream<XsdAttribute> getXsdAttributes() {
        return this.attributes.stream().filter(element -> element.getElement() instanceof XsdAttribute).map(element -> (XsdAttribute)element.getElement());
    }

    public Stream<XsdAttribute> getDirectAttributes() {
        return this.attributes.stream().filter(element -> element.getElement() instanceof XsdAttribute).map(element -> (XsdAttribute)element.getElement());
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        return XsdAttributeGroup.xsdParseSkeleton(parseData.node, new XsdAttributeGroup(parseData.parserInstance, XsdAttributeGroup.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
    }

    public void addAttribute(ReferenceBase attribute) {
        this.attributes.add(attribute);
    }

    public void addAttributeGroup(ReferenceBase attributeGroup) {
        this.attributeGroups.add(attributeGroup);
    }
}

