/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Map;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdExtension;
import org.xmlet.xsdparser.xsdelements.XsdRestriction;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public class XsdComplexContent
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:complexContent";
    public static final String XS_TAG = "xs:complexContent";
    public static final String TAG = "complexContent";
    private ReferenceBase restriction;
    private ReferenceBase extension;
    private boolean mixed;

    private XsdComplexContent(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        this.mixed = AttributeValidations.validateBoolean(attributesMap.getOrDefault("mixed", "false"));
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdComplexContent clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        XsdComplexContent elementCopy = new XsdComplexContent(this.parser, placeHolderAttributes, this.visitorFunction);
        elementCopy.restriction = ReferenceBase.clone(this.parser, this.restriction, elementCopy);
        elementCopy.extension = ReferenceBase.clone(this.parser, this.extension, elementCopy);
        elementCopy.cloneOf = this;
        elementCopy.parent = null;
        return elementCopy;
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public XsdExtension getXsdExtension() {
        return this.extension instanceof ConcreteElement ? (XsdExtension)this.extension.getElement() : null;
    }

    public XsdRestriction getXsdRestriction() {
        return this.restriction instanceof ConcreteElement ? (XsdRestriction)this.restriction.getElement() : null;
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        return XsdComplexContent.xsdParseSkeleton(parseData.node, new XsdComplexContent(parseData.parserInstance, XsdComplexContent.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
    }

    public void setExtension(ReferenceBase extension) {
        this.extension = extension;
    }

    public void setRestriction(ReferenceBase restriction) {
        this.restriction = restriction;
    }
}

