/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ConfigEntryData;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAll;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.XsdBuiltInDataType;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdMultipleElements;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.exceptions.ParsingException;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;
import org.xmlet.xsdparser.xsdelements.visitors.XsdExtensionVisitor;

public class XsdExtension
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:extension";
    public static final String XS_TAG = "xs:extension";
    public static final String TAG = "extension";
    private ReferenceBase childElement;
    private ReferenceBase base;

    private XsdExtension(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        String baseValue = attributesMap.getOrDefault("base", null);
        if (baseValue != null) {
            if (XsdParserCore.getXsdTypesToJava().containsKey(baseValue)) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", baseValue);
                this.base = ReferenceBase.createFromXsd(new XsdBuiltInDataType(parser, attributes, this));
            } else {
                Map<String, ConfigEntryData> parseMappers = XsdParserCore.getParseMappers();
                ConfigEntryData config = parseMappers.getOrDefault("xsd:element", parseMappers.getOrDefault("xs:element", null));
                if (config == null) {
                    throw new ParsingException("Invalid Parsing Configuration for XsdElement.");
                }
                this.base = new UnsolvedReference(baseValue, new XsdElement(this, this.parser, new HashMap<String, String>(), config.visitorFunction));
                parser.addUnsolvedReference((UnsolvedReference)this.base);
            }
        }
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement element) {
        boolean isComplexOrSimpleType;
        super.replaceUnsolvedElements(element);
        XsdNamedElements elem = element.getElement();
        boolean bl = isComplexOrSimpleType = elem instanceof XsdComplexType || elem instanceof XsdSimpleType;
        if (this.base instanceof UnsolvedReference && isComplexOrSimpleType && XsdExtension.compareReference(element, (UnsolvedReference)this.base)) {
            this.base = element;
        }
        if (this.childElement instanceof UnsolvedReference && elem instanceof XsdGroup && XsdExtension.compareReference(element, (UnsolvedReference)this.childElement)) {
            this.childElement = element;
        }
        ((XsdExtensionVisitor)this.visitor).replaceUnsolvedAttributes(this.parser, element, this);
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdExtension clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        XsdExtension elementCopy = new XsdExtension(this.parser, placeHolderAttributes, this.visitorFunction);
        for (XsdAttribute attribute : this.getXsdAttributes().collect(Collectors.toList())) {
            elementCopy.visitor.visit((XsdAttribute)attribute.clone(attribute.attributesMap, elementCopy));
        }
        for (XsdAttributeGroup attributeGroup : this.getXsdAttributeGroup().collect(Collectors.toList())) {
            elementCopy.visitor.visit((XsdAttributeGroup)attributeGroup.clone(attributeGroup.attributesMap, elementCopy));
        }
        elementCopy.childElement = ReferenceBase.clone(this.parser, this.childElement, elementCopy);
        elementCopy.base = this.base;
        elementCopy.cloneOf = this;
        elementCopy.parent = null;
        return elementCopy;
    }

    @Override
    public List<ReferenceBase> getElements() {
        return this.childElement == null ? Collections.emptyList() : this.childElement.getElement().getElements();
    }

    public XsdNamedElements getBase() {
        if (this.base instanceof NamedConcreteElement) {
            return ((NamedConcreteElement)this.base).getElement();
        }
        return null;
    }

    public XsdComplexType getBaseAsComplexType() {
        XsdAbstractElement baseType;
        if (this.base instanceof NamedConcreteElement && (baseType = this.base.getElement()) instanceof XsdComplexType) {
            return (XsdComplexType)baseType;
        }
        return null;
    }

    public XsdSimpleType getBaseAsSimpleType() {
        XsdAbstractElement baseType;
        if (this.base instanceof NamedConcreteElement && (baseType = this.base.getElement()) instanceof XsdSimpleType) {
            return (XsdSimpleType)baseType;
        }
        return null;
    }

    public XsdBuiltInDataType getBaseAsBuiltInDataType() {
        XsdAbstractElement baseType;
        if (this.base instanceof NamedConcreteElement && (baseType = this.base.getElement()) instanceof XsdBuiltInDataType) {
            return (XsdBuiltInDataType)baseType;
        }
        return null;
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        return XsdExtension.xsdParseSkeleton(parseData.node, new XsdExtension(parseData.parserInstance, XsdExtension.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
    }

    public Stream<XsdAttribute> getXsdAttributes() {
        return ((XsdExtensionVisitor)this.visitor).getXsdAttributes();
    }

    public Stream<XsdAttributeGroup> getXsdAttributeGroup() {
        return ((XsdExtensionVisitor)this.visitor).getXsdAttributeGroups();
    }

    public XsdAbstractElement getXsdChildElement() {
        if (this.childElement == null) {
            return null;
        }
        return this.childElement instanceof UnsolvedReference ? null : this.childElement.getElement();
    }

    public void setChildElement(ReferenceBase childElement) {
        this.childElement = childElement;
    }

    public XsdGroup getChildAsGroup() {
        return this.childElement.getElement() instanceof XsdGroup ? (XsdGroup)this.childElement.getElement() : null;
    }

    public XsdAll getChildAsAll() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsdAll((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    public XsdChoice getChildAsChoice() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsChoice((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    public XsdSequence getChildAsSequence() {
        return this.childrenIsMultipleElement() ? XsdMultipleElements.getChildAsSequence((XsdMultipleElements)this.childElement.getElement()) : null;
    }

    private boolean childrenIsMultipleElement() {
        return this.childElement.getElement() instanceof XsdMultipleElements;
    }
}

