/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAll;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdChoice;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdSequence;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public abstract class XsdMultipleElements
extends XsdAnnotatedElements {
    protected List<ReferenceBase> elements = new ArrayList<ReferenceBase>();

    XsdMultipleElements(@NotNull XsdParserCore parser, @NotNull Map<String, String> elementFieldsMapParam, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, elementFieldsMapParam, visitorFunction);
    }

    @Override
    public void replaceUnsolvedElements(NamedConcreteElement elementWrapper) {
        if (elementWrapper.getElement() instanceof XsdElement) {
            super.replaceUnsolvedElements(elementWrapper);
        }
        if (elementWrapper.getElement() instanceof XsdGroup) {
            this.elements.add(elementWrapper);
            this.elements.removeIf(element -> element instanceof UnsolvedReference && XsdMultipleElements.compareReference(elementWrapper, (UnsolvedReference)element));
        }
    }

    @Override
    public List<ReferenceBase> getElements() {
        return this.elements;
    }

    @Override
    public Stream<XsdAbstractElement> getXsdElements() {
        return this.elements.stream().filter(element -> element instanceof ConcreteElement).map(ReferenceBase::getElement);
    }

    public Stream<XsdElement> getChildrenElements() {
        return this.getXsdElements().filter(element -> element instanceof XsdElement).map(element -> (XsdElement)element);
    }

    public void addElement(XsdAbstractElement element) {
        this.elements.add(ReferenceBase.createFromXsd(element));
    }

    public static XsdAll getChildAsdAll(XsdMultipleElements element) {
        return element instanceof XsdAll ? (XsdAll)element : null;
    }

    public static XsdChoice getChildAsChoice(XsdMultipleElements element) {
        return element instanceof XsdChoice ? (XsdChoice)element : null;
    }

    public static XsdSequence getChildAsSequence(XsdMultipleElements element) {
        return element instanceof XsdSequence ? (XsdSequence)element : null;
    }
}

