/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.NamespaceInfo;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.AttributeValidations;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdAnnotation;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdGroup;
import org.xmlet.xsdparser.xsdelements.XsdImport;
import org.xmlet.xsdparser.xsdelements.XsdInclude;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.enums.BlockDefaultEnum;
import org.xmlet.xsdparser.xsdelements.enums.FinalDefaultEnum;
import org.xmlet.xsdparser.xsdelements.enums.FormEnum;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public class XsdSchema
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:schema";
    public static final String XS_TAG = "xs:schema";
    public static final String TAG = "schema";
    private FormEnum attributeFormDefault;
    private FormEnum elementFormDefault;
    private BlockDefaultEnum blockDefault;
    private FinalDefaultEnum finalDefault;
    private String targetNamespace;
    private String version;
    private String xmlns;
    private String filePath;
    private Map<String, NamespaceInfo> namespaces = new HashMap<String, NamespaceInfo>();
    private List<XsdAbstractElement> elements = new ArrayList<XsdAbstractElement>();

    private XsdSchema(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        this.attributeFormDefault = AttributeValidations.belongsToEnum(FormEnum.UNQUALIFIED, attributesMap.getOrDefault("attribtueFormDefault", FormEnum.UNQUALIFIED.getValue()));
        this.elementFormDefault = AttributeValidations.belongsToEnum(FormEnum.UNQUALIFIED, attributesMap.getOrDefault("elementFormDefault", FormEnum.UNQUALIFIED.getValue()));
        this.blockDefault = AttributeValidations.belongsToEnum(BlockDefaultEnum.DEFAULT, attributesMap.getOrDefault("blockDefault", BlockDefaultEnum.DEFAULT.getValue()));
        this.finalDefault = AttributeValidations.belongsToEnum(FinalDefaultEnum.instance, attributesMap.getOrDefault("finalDefault", FinalDefaultEnum.DEFAULT.getValue()));
        this.targetNamespace = attributesMap.getOrDefault("targetNamespace", this.targetNamespace);
        this.version = attributesMap.getOrDefault("version", this.version);
        this.xmlns = attributesMap.getOrDefault("xmlns", this.xmlns);
        for (String key : attributesMap.keySet()) {
            if (!key.startsWith("xmlns") || key.equals("xmlns:xs") || key.equals("xmlns:xsd")) continue;
            String namespaceId = key.replace("xmlns:", "");
            this.namespaces.put(namespaceId, new NamespaceInfo(attributesMap.get(key)));
        }
    }

    @Override
    public XsdAbstractElementVisitor getVisitor() {
        return this.visitor;
    }

    @Override
    public Stream<XsdAbstractElement> getXsdElements() {
        return this.elements.stream();
    }

    @Override
    public List<ReferenceBase> getElements() {
        return this.elements.stream().map(ReferenceBase::createFromXsd).collect(Collectors.toList());
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        ReferenceBase xsdSchemaRef = XsdSchema.xsdParseSkeleton(parseData.node, new XsdSchema(parseData.parserInstance, XsdSchema.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
        XsdSchema xsdSchema = (XsdSchema)xsdSchemaRef.getElement();
        List importsList = xsdSchema.getChildrenImports().collect(Collectors.toList());
        HashMap<String, String> prefixLocations = new HashMap<String, String>();
        xsdSchema.getNamespaces().forEach((prefix, namespaceInfo) -> importsList.stream().filter(xsdImportObj -> xsdImportObj.getNamespace().equals(namespaceInfo.getName())).findFirst().ifPresent(anImport -> prefixLocations.put((String)prefix, anImport.getSchemaLocation())));
        xsdSchema.updatePrefixLocations(prefixLocations);
        return xsdSchemaRef;
    }

    private void updatePrefixLocations(Map<String, String> prefixLocations) {
        prefixLocations.forEach((prefix, fileLocation) -> this.namespaces.get(prefix).setFile((String)fileLocation));
    }

    public void add(XsdInclude element) {
        this.elements.add(element);
    }

    public void add(XsdImport element) {
        this.elements.add(element);
    }

    public void add(XsdAnnotation element) {
        this.elements.add(element);
    }

    public void add(XsdSimpleType element) {
        this.elements.add(element);
    }

    public void add(XsdComplexType element) {
        this.elements.add(element);
    }

    public void add(XsdGroup element) {
        this.elements.add(element);
    }

    public void add(XsdAttributeGroup element) {
        this.elements.add(element);
    }

    public void add(XsdElement element) {
        this.elements.add(element);
    }

    public void add(XsdAttribute element) {
        this.elements.add(element);
    }

    public String getAttributeFormDefault() {
        return this.attributeFormDefault.getValue();
    }

    public String getElementFormDefault() {
        return this.elementFormDefault.getValue();
    }

    public String getBlockDefault() {
        return this.blockDefault.getValue();
    }

    public String getFinalDefault() {
        return this.finalDefault.getValue();
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getVersion() {
        return this.version;
    }

    public Stream<XsdInclude> getChildrenIncludes() {
        return this.getXsdElements().filter(element -> element instanceof XsdInclude).map(element -> (XsdInclude)element);
    }

    public Stream<XsdImport> getChildrenImports() {
        return this.getXsdElements().filter(element -> element instanceof XsdImport).map(element -> (XsdImport)element);
    }

    public Stream<XsdAnnotation> getChildrenAnnotations() {
        return this.getXsdElements().filter(element -> element instanceof XsdAnnotation).map(element -> (XsdAnnotation)element);
    }

    public Stream<XsdSimpleType> getChildrenSimpleTypes() {
        return this.getXsdElements().filter(element -> element instanceof XsdSimpleType).map(element -> (XsdSimpleType)element);
    }

    public Stream<XsdComplexType> getChildrenComplexTypes() {
        return this.getXsdElements().filter(element -> element instanceof XsdComplexType).map(element -> (XsdComplexType)element);
    }

    public Stream<XsdGroup> getChildrenGroups() {
        return this.getXsdElements().filter(element -> element instanceof XsdGroup).map(element -> (XsdGroup)element);
    }

    public Stream<XsdAttributeGroup> getChildrenAttributeGroups() {
        return this.getXsdElements().filter(element -> element instanceof XsdAttributeGroup).map(element -> (XsdAttributeGroup)element);
    }

    public Stream<XsdElement> getChildrenElements() {
        return this.getXsdElements().filter(element -> element instanceof XsdElement).map(element -> (XsdElement)element);
    }

    public Stream<XsdAttribute> getChildrenAttributes() {
        return this.getXsdElements().filter(element -> element instanceof XsdAttribute).map(element -> (XsdAttribute)element);
    }

    public void resolveNameSpace(String namespace, String schemaLocation) {
        NamespaceInfo namespaceInfo;
        if (this.namespaces.containsKey(namespace) && (namespaceInfo = this.namespaces.get(namespace)).getFile() == null) {
            namespaceInfo.setFile(schemaLocation);
        }
    }

    public Map<String, NamespaceInfo> getNamespaces() {
        return this.namespaces;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

