/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.core.utils.ParseData;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAbstractElementVisitor;

public class XsdUnion
extends XsdAnnotatedElements {
    public static final String XSD_TAG = "xsd:union";
    public static final String XS_TAG = "xs:union";
    public static final String TAG = "union";
    private List<XsdSimpleType> simpleTypeList = new ArrayList<XsdSimpleType>();
    private String memberTypes;

    private XsdUnion(@NotNull XsdParserCore parser, @NotNull Map<String, String> attributesMap, @NotNull Function<XsdAbstractElement, XsdAbstractElementVisitor> visitorFunction) {
        super(parser, attributesMap, visitorFunction);
        this.memberTypes = attributesMap.getOrDefault("memberTypes", this.memberTypes);
    }

    @Override
    public void accept(XsdAbstractElementVisitor visitorParam) {
        super.accept(visitorParam);
        visitorParam.visit(this);
    }

    @Override
    public XsdUnion clone(@NotNull Map<String, String> placeHolderAttributes) {
        placeHolderAttributes.putAll(this.attributesMap);
        XsdUnion elementCopy = new XsdUnion(this.parser, placeHolderAttributes, this.visitorFunction);
        if (this.simpleTypeList != null) {
            elementCopy.simpleTypeList = this.simpleTypeList.stream().map(simpleType -> (XsdSimpleType)simpleType.clone(simpleType.getAttributesMap(), elementCopy)).collect(Collectors.toList());
        }
        elementCopy.parent = null;
        return elementCopy;
    }

    public List<XsdSimpleType> getUnionElements() {
        return this.simpleTypeList;
    }

    public List<String> getMemberTypesList() {
        return Arrays.asList(this.memberTypes.split(" "));
    }

    public static ReferenceBase parse(@NotNull ParseData parseData) {
        return XsdUnion.xsdParseSkeleton(parseData.node, new XsdUnion(parseData.parserInstance, XsdUnion.convertNodeMap(parseData.node.getAttributes()), parseData.visitorFunction));
    }

    public void add(XsdSimpleType simpleType) {
        this.simpleTypeList.add(simpleType);
    }
}

