/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements.elementswrapper;

import java.util.HashMap;
import java.util.Map;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;

public abstract class ReferenceBase {
    protected XsdAbstractElement element;

    ReferenceBase(XsdAbstractElement element) {
        this.element = element;
    }

    public XsdAbstractElement getElement() {
        return this.element;
    }

    public static ReferenceBase createFromXsd(XsdAbstractElement element) {
        String ref = ReferenceBase.getRef(element);
        String name = ReferenceBase.getName(element);
        if (!(element instanceof XsdNamedElements)) {
            return new ConcreteElement(element);
        }
        if (ref == null) {
            if (name == null) {
                return new ConcreteElement(element);
            }
            return new NamedConcreteElement((XsdNamedElements)element, name);
        }
        return new UnsolvedReference((XsdNamedElements)element);
    }

    public static ReferenceBase clone(XsdParserCore parser, ReferenceBase originalReference, XsdAbstractElement parent) {
        if (originalReference == null) {
            return null;
        }
        XsdAbstractElement originalElement = originalReference.getElement();
        if (originalReference instanceof UnsolvedReference) {
            Map<String, String> originalElementAttributesMap = originalElement.getAttributesMap();
            HashMap<String, String> clonedOriginalElementAttributesMap = new HashMap<String, String>(originalElementAttributesMap);
            clonedOriginalElementAttributesMap.put("ref", ((UnsolvedReference)originalReference).getRef());
            XsdNamedElements clonedElement = (XsdNamedElements)originalElement.clone(clonedOriginalElementAttributesMap);
            clonedElement.getAttributesMap().put("ref", ((UnsolvedReference)originalReference).getRef());
            clonedElement.setCloneOf(originalElement);
            clonedElement.setParent(parent);
            UnsolvedReference unsolvedClonedElement = new UnsolvedReference(clonedElement);
            parser.addUnsolvedReference(unsolvedClonedElement);
            return unsolvedClonedElement;
        }
        originalReference.getElement().setParentAvailable(false);
        return originalReference;
    }

    private static String getName(XsdAbstractElement element) {
        return ReferenceBase.getNodeValue(element, "name");
    }

    static String getRef(XsdAbstractElement element) {
        return ReferenceBase.getNodeValue(element, "ref");
    }

    private static String getNodeValue(XsdAbstractElement element, String nodeName) {
        return element.getAttributesMap().getOrDefault(nodeName, null);
    }
}

