/*
 * Decompiled with CFR 0.152.
 */
package org.xmlet.xsdparser.xsdelements.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.xmlet.xsdparser.core.XsdParserCore;
import org.xmlet.xsdparser.xsdelements.XsdAbstractElement;
import org.xmlet.xsdparser.xsdelements.XsdAnnotatedElements;
import org.xmlet.xsdparser.xsdelements.XsdAttribute;
import org.xmlet.xsdparser.xsdelements.XsdAttributeGroup;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.NamedConcreteElement;
import org.xmlet.xsdparser.xsdelements.elementswrapper.ReferenceBase;
import org.xmlet.xsdparser.xsdelements.elementswrapper.UnsolvedReference;
import org.xmlet.xsdparser.xsdelements.visitors.XsdAnnotatedElementsVisitor;

public abstract class AttributesVisitor
extends XsdAnnotatedElementsVisitor {
    private List<ReferenceBase> attributeGroups = new ArrayList<ReferenceBase>();
    private List<ReferenceBase> attributes = new ArrayList<ReferenceBase>();

    AttributesVisitor(XsdAnnotatedElements owner) {
        super(owner);
    }

    @Override
    public void visit(XsdAttribute attribute) {
        super.visit(attribute);
        this.attributes.add(ReferenceBase.createFromXsd(attribute));
    }

    @Override
    public void visit(XsdAttributeGroup attributeGroup) {
        super.visit(attributeGroup);
        this.attributeGroups.add(ReferenceBase.createFromXsd(attributeGroup));
    }

    public void setAttributes(List<ReferenceBase> attributes) {
        this.attributes = attributes;
    }

    public void setAttributeGroups(List<ReferenceBase> attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    public List<ReferenceBase> getAttributes() {
        return this.attributes;
    }

    public List<ReferenceBase> getAttributeGroups() {
        return this.attributeGroups;
    }

    public Stream<XsdAttribute> getXsdAttributes() {
        return this.attributes.stream().filter(attribute -> attribute instanceof ConcreteElement).filter(attribute -> attribute.getElement() instanceof XsdAttribute).map(attribute -> (XsdAttribute)attribute.getElement());
    }

    public Stream<XsdAttributeGroup> getXsdAttributeGroups() {
        return this.attributeGroups.stream().filter(attributeGroup -> attributeGroup instanceof ConcreteElement).map(attributeGroup -> (XsdAttributeGroup)attributeGroup.getElement());
    }

    public Stream<XsdAttributeGroup> getAllXsdAttributeGroups() {
        ArrayList<XsdAttributeGroup> allXsdAttributeGroups = new ArrayList<XsdAttributeGroup>();
        for (XsdAttributeGroup attributeGroup : this.attributeGroups.stream().filter(element -> element.getElement() instanceof XsdAttributeGroup).map(element -> (XsdAttributeGroup)element.getElement()).collect(Collectors.toList())) {
            allXsdAttributeGroups.add(attributeGroup);
            allXsdAttributeGroups.addAll(attributeGroup.getAllXsdAttributeGroups().collect(Collectors.toList()));
        }
        return allXsdAttributeGroups.stream();
    }

    public void replaceUnsolvedAttributes(XsdParserCore parser, NamedConcreteElement element, XsdAbstractElement parent) {
        if (element.getElement() instanceof XsdAttributeGroup) {
            this.attributeGroups.stream().filter(attributeGroup -> attributeGroup instanceof UnsolvedReference && XsdAbstractElement.compareReference(element, (UnsolvedReference)attributeGroup)).findFirst().ifPresent(referenceBase -> {
                this.attributeGroups.remove(referenceBase);
                ReferenceBase attributeGroupCloneReference = ReferenceBase.clone(parser, element, parent);
                this.attributeGroups.add(attributeGroupCloneReference);
            });
        }
        if (element.getElement() instanceof XsdAttribute) {
            this.attributes.stream().filter(attribute -> attribute instanceof UnsolvedReference && XsdAbstractElement.compareReference(element, (UnsolvedReference)attribute)).findFirst().ifPresent(referenceBase -> {
                this.attributes.remove(referenceBase);
                this.attributes.add(ReferenceBase.clone(parser, element, parent));
            });
        }
    }

    public List<XsdAttribute> getAllAttributes() {
        ArrayList<XsdAttribute> allAttributes = new ArrayList<XsdAttribute>();
        this.getXsdAttributeGroups().forEach(attributeGroup -> allAttributes.addAll(attributeGroup.getElements().stream().filter(attributeReference -> attributeReference instanceof ConcreteElement && attributeReference.getElement() instanceof XsdAttribute).map(attributeReference -> (XsdAttribute)attributeReference.getElement()).collect(Collectors.toList())));
        allAttributes.addAll(this.getXsdAttributes().collect(Collectors.toList()));
        return allAttributes;
    }
}

