/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import java.io.Serializable;
import java.math.BigInteger;
import msgpack4z.CirceMsgpack;
import msgpack4z.CirceMsgpack$Result$;
import msgpack4z.CirceUnpackOptions;
import msgpack4z.CodecCirceJson;
import msgpack4z.CodecCirceJsonObject;
import msgpack4z.MsgPacker;
import msgpack4z.MsgType;
import msgpack4z.MsgUnpacker;
import msgpack4z.MsgpackCodec;
import msgpack4z.Other;
import msgpack4z.UnpackError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scalaz.;
import scalaz.Equal;
import scalaz.Equal$;

public final class CirceMsgpack$ {
    public static CirceMsgpack$ MODULE$;
    private final Equal<Json> circeJsonEqual;
    private final Equal<JsonObject> circeJsonObjectEqual;
    private final Equal<JsonNumber> circeJsonNumberEqual;
    private final BigInteger BigIntegerLongMax;
    private final BigDecimal BigDecimalLongMax2x;
    private final BigInteger BigIntegerLongMin;

    static {
        new CirceMsgpack$();
    }

    public Equal<Json> circeJsonEqual() {
        return this.circeJsonEqual;
    }

    public Equal<JsonObject> circeJsonObjectEqual() {
        return this.circeJsonObjectEqual;
    }

    public Equal<JsonNumber> circeJsonNumberEqual() {
        return this.circeJsonNumberEqual;
    }

    public MsgpackCodec<Json> jsonCodec(CirceUnpackOptions options) {
        return new CodecCirceJson(options);
    }

    public MsgpackCodec<JsonObject> jsonObjectCodec(CirceUnpackOptions options) {
        return new CodecCirceJsonObject(options);
    }

    public Tuple2<MsgpackCodec<Json>, MsgpackCodec<JsonObject>> allCodec(CirceUnpackOptions options) {
        return new Tuple2(this.jsonCodec(options), this.jsonObjectCodec(options));
    }

    public void jsonObject2msgpack(MsgPacker packer, JsonObject obj) {
        List fields = obj.toList();
        packer.packMapHeader(fields.size());
        fields.foreach((Function1 & Serializable & scala.Serializable)field -> {
            CirceMsgpack$.$anonfun$jsonObject2msgpack$1(packer, field);
            return BoxedUnit.UNIT;
        });
        packer.mapEnd();
    }

    public void jsonArray2msgpack(MsgPacker packer, Seq<Json> array) {
        packer.packArrayHeader(array.size());
        array.foreach((Function1 & Serializable & scala.Serializable)x -> {
            CirceMsgpack$.MODULE$.json2msgpack(packer, x);
            return BoxedUnit.UNIT;
        });
        packer.arrayEnd();
    }

    public void json2msgpack(MsgPacker packer, Json json) {
        json.fold((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> packer.packNil(), (Function1 & Serializable & scala.Serializable)value -> {
            packer.packBoolean(BoxesRunTime.unboxToBoolean((Object)value));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)value -> {
            CirceMsgpack$.$anonfun$json2msgpack$3(packer, value);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)string -> {
            packer.packString(string);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)array -> {
            CirceMsgpack$.MODULE$.jsonArray2msgpack(packer, (Seq<Json>)array);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)obj -> {
            CirceMsgpack$.MODULE$.jsonObject2msgpack(packer, obj);
            return BoxedUnit.UNIT;
        });
    }

    public .bslash.div<UnpackError, Json> msgpack2json(MsgUnpacker unpacker, CirceUnpackOptions unpackOptions) {
        CirceMsgpack.Result<Json> result = CirceMsgpack$Result$.MODULE$.empty();
        return this.msgpack2json0(unpacker, result, unpackOptions) ? new .bslash.div.minus((Object)result.value()) : new .minus.bslash.div((Object)result.error());
    }

    public .bslash.div<UnpackError, JsonObject> msgpack2jsonObject(MsgUnpacker unpacker, CirceUnpackOptions unpackOptions) {
        CirceMsgpack.Result<JsonObject> result = CirceMsgpack$Result$.MODULE$.empty();
        return this.msgpack2jsObj0(unpacker, result, unpackOptions) ? new .bslash.div.minus((Object)result.value()) : new .minus.bslash.div((Object)result.error());
    }

    public .bslash.div<UnpackError, List<Json>> msgpack2jsonArray(MsgUnpacker unpacker, CirceUnpackOptions unpackOptions) {
        CirceMsgpack.Result<List<Json>> result = CirceMsgpack$Result$.MODULE$.empty();
        return this.msgpack2jsArray0(unpacker, result, unpackOptions) ? new .bslash.div.minus(result.value()) : new .minus.bslash.div((Object)result.error());
    }

    private boolean msgpack2jsObj0(MsgUnpacker unpacker, CirceMsgpack.Result<JsonObject> result, CirceUnpackOptions unpackOptions) {
        BooleanRef success;
        block4: {
            int size = unpacker.unpackMapHeader();
            ObjectRef obj = ObjectRef.create((Object)JsonObject$.MODULE$.empty());
            IntRef i = IntRef.create((int)0);
            CirceMsgpack.Result mapElem = CirceMsgpack$Result$.MODULE$.empty();
            success = BooleanRef.create((boolean)true);
            while (i.elem < size && success.elem) {
                BoxedUnit boxedUnit;
                MsgType tpe;
                MsgType msgType = tpe = unpacker.nextType();
                MsgType msgType2 = MsgType.STRING;
                if (!(msgType != null ? !msgType.equals(msgType2) : msgType2 != null)) {
                    this.process$1(unpacker.unpackString(), unpacker, mapElem, unpackOptions, obj, i, result, success);
                    continue;
                }
                Option option = (Option)unpackOptions.nonStringKey().apply((Object)tpe, (Object)unpacker);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String key = (String)some.value();
                    this.process$1(key, unpacker, mapElem, unpackOptions, obj, i, result, success);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    success.elem = false;
                    result.error_$eq((UnpackError)new Other("not string key"));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)option);
            }
            unpacker.mapEnd();
            if (!success.elem) break block4;
            result.value_$eq((JsonObject)obj.elem);
        }
        return success.elem;
    }

    private boolean msgpack2jsArray0(MsgUnpacker unpacker, CirceMsgpack.Result<List<Json>> result, CirceUnpackOptions unpackOptions) {
        boolean success;
        block2: {
            int size = unpacker.unpackArrayHeader();
            Json[] array = new Json[size];
            int i = 0;
            CirceMsgpack.Result<Object> arrayElem = new CirceMsgpack.Result<Object>(null, null);
            success = true;
            while (i < size && success) {
                if (this.msgpack2json0(unpacker, arrayElem, unpackOptions)) {
                    array[i] = arrayElem.value();
                    ++i;
                    continue;
                }
                result.error_$eq(arrayElem.error());
                success = false;
            }
            unpacker.arrayEnd();
            if (!success) break block2;
            result.value_$eq((List<Json>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])array)).toList());
        }
        return success;
    }

    private boolean isValidLong(BigInteger value) {
        return this.BigIntegerLongMin.compareTo(value) <= 0 && value.compareTo(this.BigIntegerLongMax) <= 0;
    }

    public boolean msgpack2json0(MsgUnpacker unpacker, CirceMsgpack.Result<Json> result, CirceUnpackOptions unpackOptions) {
        boolean bl;
        MsgType msgType = unpacker.nextType();
        if (MsgType.NIL.equals(msgType)) {
            unpacker.unpackNil();
            result.value_$eq(Json$.MODULE$.Null());
            bl = true;
        } else if (MsgType.BOOLEAN.equals(msgType)) {
            if (unpacker.unpackBoolean()) {
                result.value_$eq(Json$.MODULE$.True());
            } else {
                result.value_$eq(Json$.MODULE$.False());
            }
            bl = true;
        } else if (MsgType.INTEGER.equals(msgType)) {
            BigInteger value = unpacker.unpackBigInteger();
            if (this.isValidLong(value)) {
                result.value_$eq(Json$.MODULE$.fromLong(value.longValue()));
            } else {
                result.value_$eq(Json$.MODULE$.fromBigDecimal(package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(value))));
            }
            bl = true;
        } else if (MsgType.FLOAT.equals(msgType)) {
            Boolean bl2;
            double f = unpacker.unpackDouble();
            if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(f))) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)CirceMsgpack$Result$.MODULE$.fromEither(unpackOptions.positiveInf(), result));
            } else if (RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(f))) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)CirceMsgpack$Result$.MODULE$.fromEither(unpackOptions.negativeInf(), result));
            } else if (Double.isNaN(f)) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)CirceMsgpack$Result$.MODULE$.fromEither(unpackOptions.nan(), result));
            } else {
                result.value_$eq(Json$.MODULE$.fromDoubleOrNull(f));
                bl2 = BoxedUnit.UNIT;
            }
            bl = true;
        } else if (MsgType.STRING.equals(msgType)) {
            result.value_$eq(Json$.MODULE$.fromString(unpacker.unpackString()));
            bl = true;
        } else if (MsgType.ARRAY.equals(msgType)) {
            CirceMsgpack.Result<List<Json>> result0 = CirceMsgpack$Result$.MODULE$.empty();
            boolean r = this.msgpack2jsArray0(unpacker, result0, unpackOptions);
            result.error_$eq(result0.error());
            result.value_$eq(Json$.MODULE$.fromValues((Iterable)result0.value()));
            bl = r;
        } else if (MsgType.MAP.equals(msgType)) {
            CirceMsgpack.Result<JsonObject> result0 = CirceMsgpack$Result$.MODULE$.empty();
            boolean r = this.msgpack2jsObj0(unpacker, result0, unpackOptions);
            result.error_$eq(result0.error());
            result.value_$eq(Json$.MODULE$.fromJsonObject(result0.value()));
            bl = r;
        } else if (MsgType.BINARY.equals(msgType)) {
            bl = CirceMsgpack$Result$.MODULE$.fromEither((.bslash.div)unpackOptions.binary().apply((Object)unpacker), result);
        } else if (MsgType.EXTENSION.equals(msgType)) {
            bl = CirceMsgpack$Result$.MODULE$.fromEither((.bslash.div)unpackOptions.extension().apply((Object)unpacker), result);
        } else {
            throw new MatchError((Object)msgType);
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$jsonObject2msgpack$1(MsgPacker packer$1, Tuple2 field) {
        packer$1.packString((String)field._1());
        MODULE$.json2msgpack(packer$1, (Json)field._2());
    }

    public static final /* synthetic */ void $anonfun$json2msgpack$3(MsgPacker packer$3, JsonNumber value) {
        Option option = value.toLong();
        if (option instanceof Some) {
            Some some = (Some)option;
            long l = BoxesRunTime.unboxToLong((Object)some.value());
            packer$3.packLong(l);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Option option2 = value.toBigDecimal();
            if (option2 instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option2;
                BigDecimal b = (BigDecimal)some.value();
                if (b.isWhole() && BigDecimal$.MODULE$.long2bigDecimal(Long.MIN_VALUE).$less$eq((Object)b) && b.$less((Object)CirceMsgpack$.MODULE$.BigDecimalLongMax2x)) {
                    packer$3.packBigInteger(b.underlying().toBigIntegerExact());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    packer$3.packDouble(value.toDouble());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option2)) {
                packer$3.packDouble(value.toDouble());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private final void process$1(String key, MsgUnpacker unpacker$1, CirceMsgpack.Result mapElem$1, CirceUnpackOptions unpackOptions$1, ObjectRef obj$1, IntRef i$1, CirceMsgpack.Result result$1, BooleanRef success$1) {
        if (this.msgpack2json0(unpacker$1, mapElem$1, unpackOptions$1)) {
            obj$1.elem = ((JsonObject)obj$1.elem).add(key, (Json)mapElem$1.value());
            ++i$1.elem;
        } else {
            result$1.error_$eq(mapElem$1.error());
            success$1.elem = false;
        }
    }

    private CirceMsgpack$() {
        MODULE$ = this;
        this.circeJsonEqual = Equal$.MODULE$.equalA();
        this.circeJsonObjectEqual = Equal$.MODULE$.equalA();
        this.circeJsonNumberEqual = Equal$.MODULE$.equalA();
        this.BigIntegerLongMax = BigInteger.valueOf(Long.MAX_VALUE);
        this.BigDecimalLongMax2x = package$.MODULE$.BigDecimal().apply(Long.MAX_VALUE).$times(BigDecimal$.MODULE$.int2bigDecimal(2));
        this.BigIntegerLongMin = BigInteger.valueOf(Long.MIN_VALUE);
    }
}

