/*
 * Decompiled with CFR 0.152.
 */
package com.unitils.boot.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.rules.SpringMethodRule;
import org.springframework.test.context.junit4.statements.RunAfterTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunAfterTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.SpringRepeat;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.core.junit.AfterTestMethodStatement;
import org.unitils.core.junit.AfterTestTearDownStatement;
import org.unitils.core.junit.BeforeTestClassStatement;
import org.unitils.core.junit.BeforeTestMethodStatement;
import org.unitils.core.junit.BeforeTestSetUpStatement;

public class UnitilsBootBlockJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    private static final Log logger = LogFactory.getLog(UnitilsBootBlockJUnit4ClassRunner.class);
    private static final Method withRulesMethod;
    protected Object test;
    protected TestListener unitilsTestListener;
    private final TestContextManager testContextManager;

    private static void ensureSpringRulesAreNotPresent(Class<?> testClass) {
        for (Field field : testClass.getFields()) {
            if (SpringClassRule.class.isAssignableFrom(field.getType())) {
                throw new IllegalStateException(String.format("Detected SpringClassRule field in test class [%s], but SpringClassRule cannot be used with the UnitilsBootBlockJUnit4ClassRunner.", testClass.getName()));
            }
            if (!SpringMethodRule.class.isAssignableFrom(field.getType())) continue;
            throw new IllegalStateException(String.format("Detected SpringMethodRule field in test class [%s], but SpringMethodRule cannot be used with the UnitilsBootBlockJUnit4ClassRunner.", testClass.getName()));
        }
    }

    public UnitilsBootBlockJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UnitilsBootBlockJUnit4ClassRunner constructor called with [" + clazz + "]"));
        }
        UnitilsBootBlockJUnit4ClassRunner.ensureSpringRulesAreNotPresent(clazz);
        this.testContextManager = this.createTestContextManager(clazz);
        this.unitilsTestListener = this.getUnitilsTestListener();
    }

    protected TestListener getUnitilsTestListener() {
        return Unitils.getInstance().getTestListener();
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        this.test = test;
        Statement statement = super.methodInvoker(method, test);
        statement = new BeforeTestMethodStatement(this.unitilsTestListener, statement, method.getMethod(), test);
        statement = new AfterTestMethodStatement(this.unitilsTestListener, statement, method.getMethod(), test);
        return statement;
    }

    protected Statement classBlock(RunNotifier notifier) {
        Class testClass = this.getTestClass().getJavaClass();
        Statement statement = super.classBlock(notifier);
        statement = new BeforeTestClassStatement(testClass, this.unitilsTestListener, statement);
        return statement;
    }

    protected TestContextManager createTestContextManager(Class<?> clazz) {
        return new TestContextManager(clazz);
    }

    protected final TestContextManager getTestContextManager() {
        return this.testContextManager;
    }

    public Description getDescription() {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment((Class)this.getTestClass().getJavaClass())) {
            return Description.createSuiteDescription((Class)this.getTestClass().getJavaClass());
        }
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment((Class)this.getTestClass().getJavaClass())) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        super.run(notifier);
    }

    protected Statement withBeforeClasses(Statement statement) {
        Statement junitBeforeClasses = super.withBeforeClasses(statement);
        return new RunBeforeTestClassCallbacks(junitBeforeClasses, this.getTestContextManager());
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement junitAfterClasses = super.withAfterClasses(statement);
        return new RunAfterTestClassCallbacks(junitAfterClasses, this.getTestContextManager());
    }

    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        this.getTestContextManager().prepareTestInstance(testInstance);
        return testInstance;
    }

    protected void runChild(FrameworkMethod frameworkMethod, RunNotifier notifier) {
        Description description = this.describeChild(frameworkMethod);
        if (this.isTestMethodIgnored(frameworkMethod)) {
            notifier.fireTestIgnored(description);
        } else {
            Statement statement;
            try {
                statement = this.methodBlock(frameworkMethod);
            }
            catch (Throwable ex) {
                statement = new Fail(ex);
            }
            this.runLeaf(statement, description, notifier);
        }
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Object testInstance;
        try {
            testInstance = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return UnitilsBootBlockJUnit4ClassRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable ex) {
            return new Fail(ex);
        }
        Statement statement = this.methodInvoker(frameworkMethod, testInstance);
        statement = this.possiblyExpectingExceptions(frameworkMethod, testInstance, statement);
        statement = this.withBefores(frameworkMethod, testInstance, statement);
        statement = this.withAfters(frameworkMethod, testInstance, statement);
        statement = this.withRulesReflectively(frameworkMethod, testInstance, statement);
        statement = this.withPotentialRepeat(frameworkMethod, testInstance, statement);
        statement = this.withPotentialTimeout(frameworkMethod, testInstance, statement);
        Method testMethod = frameworkMethod.getMethod();
        statement = new BeforeTestSetUpStatement(this.test, testMethod, this.unitilsTestListener, statement);
        statement = new AfterTestTearDownStatement(this.unitilsTestListener, statement, this.test, testMethod);
        return statement;
    }

    private Statement withRulesReflectively(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        return (Statement)ReflectionUtils.invokeMethod((Method)withRulesMethod, (Object)((Object)this), (Object[])new Object[]{frameworkMethod, testInstance, statement});
    }

    protected boolean isTestMethodIgnored(FrameworkMethod frameworkMethod) {
        Method method = frameworkMethod.getMethod();
        return method.isAnnotationPresent(Ignore.class) || !ProfileValueUtils.isTestEnabledInThisEnvironment((Method)method, (Class)this.getTestClass().getJavaClass());
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Class<? extends Throwable> expectedException = this.getExpectedException(frameworkMethod);
        return expectedException != null ? new ExpectException(next, expectedException) : next;
    }

    protected Class<? extends Throwable> getExpectedException(FrameworkMethod frameworkMethod) {
        Test test = (Test)frameworkMethod.getAnnotation(Test.class);
        return test != null && test.expected() != Test.None.class ? test.expected() : null;
    }

    protected Statement withBefores(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Statement junitBefores = super.withBefores(frameworkMethod, testInstance, statement);
        return new RunBeforeTestMethodCallbacks(junitBefores, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withAfters(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Statement junitAfters = super.withAfters(frameworkMethod, testInstance, statement);
        return new RunAfterTestMethodCallbacks(junitAfters, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withPotentialRepeat(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        return new SpringRepeat(next, frameworkMethod.getMethod());
    }

    static {
        if (!ClassUtils.isPresent((String)"org.junit.internal.Throwables", (ClassLoader)UnitilsBootBlockJUnit4ClassRunner.class.getClassLoader())) {
            throw new IllegalStateException("UnitilsBootBlockJUnit4ClassRunner requires JUnit 4.12 or higher.");
        }
        withRulesMethod = ReflectionUtils.findMethod(UnitilsBootBlockJUnit4ClassRunner.class, (String)"withRules", (Class[])new Class[]{FrameworkMethod.class, Object.class, Statement.class});
        if (withRulesMethod == null) {
            throw new IllegalStateException("UnitilsBootBlockJUnit4ClassRunner requires JUnit 4.12 or higher.");
        }
        ReflectionUtils.makeAccessible((Method)withRulesMethod);
    }
}

