/*
 * Decompiled with CFR 0.152.
 */
package com.unitils.boot.xls;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.excel.XlsDataSet;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.util.MultiSchemaDataSet;

public class MultiSchemaXlsDataSetReader {
    private String pattern = ".";
    private String defaultSchemaName;

    public MultiSchemaXlsDataSetReader(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    public MultiSchemaDataSet readDataSetXls(File ... dataSetFiles) {
        try {
            Map<String, List<ITable>> tbMap = this.getTables(dataSetFiles);
            MultiSchemaDataSet dataSets = new MultiSchemaDataSet();
            for (Map.Entry<String, List<ITable>> entry : tbMap.entrySet()) {
                List<ITable> tables = entry.getValue();
                try {
                    DefaultDataSet ds = new DefaultDataSet(tables.toArray(new ITable[0]));
                    dataSets.setDataSetForSchema(entry.getKey(), (IDataSet)ds);
                }
                catch (AmbiguousTableNameException e) {
                    throw new UnitilsException("\u6784\u9020DataSet\u5931\u8d25\uff01", (Throwable)e);
                }
            }
            return dataSets;
        }
        catch (Exception e) {
            throw new UnitilsException("\u89e3\u6790Excel\u6587\u4ef6\u51fa\u9519\uff1a", (Throwable)e);
        }
    }

    private Map<String, List<ITable>> getTables(File ... dataSetFiles) {
        HashMap<String, List<ITable>> tableMap = new HashMap<String, List<ITable>>();
        try {
            for (File file : dataSetFiles) {
                String[] tableNames;
                XlsDataSet dataSet = new XlsDataSet((InputStream)new FileInputStream(file));
                for (String tn : tableNames = dataSet.getTableNames()) {
                    String tableName;
                    String schema;
                    String[] temp = tn.split(this.pattern);
                    if (temp.length == 2) {
                        schema = temp[0];
                        tableName = temp[1];
                    } else {
                        schema = this.defaultSchemaName;
                        tableName = tn;
                    }
                    ITable table = dataSet.getTable(tn);
                    if (!tableMap.containsKey(schema)) {
                        tableMap.put(schema, new ArrayList());
                    }
                    ((List)tableMap.get(schema)).add(new XlsTable(tableName, table));
                }
            }
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to create DbUnit dataset for data set files: " + Arrays.toString(dataSetFiles), (Throwable)e);
        }
        return tableMap;
    }

    class XlsTable
    extends AbstractTable {
        private ITable delegate;
        private String tableName;

        public XlsTable(String tableName, ITable table) {
            this.delegate = table;
            this.tableName = tableName;
        }

        public int getRowCount() {
            return this.delegate.getRowCount();
        }

        public ITableMetaData getTableMetaData() {
            ITableMetaData meta = this.delegate.getTableMetaData();
            try {
                return new DefaultTableMetaData(this.tableName, meta.getColumns(), meta.getPrimaryKeys());
            }
            catch (DataSetException e) {
                throw new UnitilsException("Don't get the meta info from  " + meta, (Throwable)e);
            }
        }

        public Object getValue(int row, String column) throws DataSetException {
            Object delta = this.delegate.getValue(row, column);
            if (delta instanceof String && StringUtils.isEmpty((String)((String)delta))) {
                return null;
            }
            return delta;
        }
    }
}

