/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.api.scripting.ScriptUtils;
import org.apache.commons.io.FileUtils;
import org.math.R.Log;
import org.math.R.R2jsUtils;
import org.math.R.RFunctionArgumentsDTO;
import org.math.R.RLog;
import org.math.R.RLogPrintStream;
import org.math.R.RserveDaemon;
import org.math.R.Rsession;

public class R2jsSession
extends Rsession
implements RLog {
    File wdir;
    private static final String[] MATH_FUN_JS = new String[]{"abs", "acos", "asin", "atan", "atan2", "ceil", "cos", "exp", "floor", "log", "max", "min", "round", "sin", "sqrt", "tan", "sign", "sum", "mean", "median", "std", "var"};
    private static final String[] MATH_CONST_JS = new String[]{"pi"};
    private static final String MATH_JS_FILE = "/org/math/R/math.js";
    private static final String R_JS_FILE = "/org/math/R/R.js";
    private static final String RAND_JS_FILE = "/org/math/R/rand.js";
    public ScriptEngine js;
    private static final String ENVIRONMENT_DEFAULT = "__r2js__";
    private static final String THIS_ENVIRONMENT = "__this__";
    public static final String[] DISABLED_FUNCTIONS = new String[]{"png", "plot", "abline", "rgb", "hist", "pairs", "lines", "points"};
    public Set<String> variablesSet;
    public Set<String> functionsSet;
    private List<String> quotesList;
    private static final Map<String, Object> jsLibraries = Collections.synchronizedMap(new HashMap());
    static final String POINT_CHAR_JS_KEY = "__";
    public static Properties R_TO_JS = new Properties();
    static final String AW = "((\\A)|(\\W)|(\\())(";
    static final String Az = ")((\\W)|(\\z)|(\\)))";
    public boolean debug_js = Boolean.parseBoolean(System.getProperty("debug.js", "false"));
    DecimalFormat formatter = new DecimalFormat("#.#############", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static String index_pattern;
    static Map<String, String> Env;
    Map<String, Set<String>> envVariables = new HashMap<String, Set<String>>();
    private static String html_tmpl;
    private static String input_tmpl;
    private static String submit_tmpl;

    public static R2jsSession newInstance(RLog console, Properties properties) {
        return new R2jsSession(console, properties);
    }

    public R2jsSession(RLog console, Properties properties) {
        this(console, properties, null);
    }

    public R2jsSession(RLog console, Properties properties, String environmentName) {
        super(console);
        this.envName = environmentName != null ? POINT_CHAR_JS_KEY + environmentName + POINT_CHAR_JS_KEY : ENVIRONMENT_DEFAULT;
        this.variablesSet = new HashSet<String>();
        this.functionsSet = new HashSet<String>();
        this.TRY_MODE_DEFAULT = false;
        ScriptEngineManager manager = new ScriptEngineManager(null);
        this.js = manager.getEngineByName("JavaScript");
        if (this.js == null) {
            this.js = manager.getEngineByName("js");
        }
        if (this.js == null) {
            this.js = manager.getEngineByExtension("js");
        }
        if (this.js == null) {
            this.js = manager.getEngineByName("nashorn");
        }
        if (this.js == null) {
            this.js = manager.getEngineByName("Nashorn");
        }
        if (this.js == null) {
            this.js = new NashornScriptEngineFactory().getScriptEngine();
        }
        if (this.js == null) {
            throw new IllegalArgumentException("Could not load JavaScript ScriptEngine: " + manager.getEngineFactories());
        }
        try {
            this.loadJSLibraries();
            for (String f : DISABLED_FUNCTIONS) {
                this.addReturnNullFunction(f);
            }
            this.js.eval("var " + this.envName + " = math.clone({});");
            this.js.eval("__this__ = " + this.envName);
        }
        catch (ScriptException ex) {
            Logger.getLogger(R2jsSession.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            int rand = Math.round((float)Math.random() * 10000.0f);
            this.wdir = new File(new File(System.getProperty("RSESSION_HOME", FileUtils.getTempDirectoryPath()), ".R2js"), "" + rand);
            if (!this.wdir.mkdirs()) {
                this.wdir = new File(new File(FileUtils.getUserDirectory(), ".R2js"), "" + rand);
                if (!this.wdir.mkdirs()) {
                    throw new IOException("Could not create directory " + new File(new File(System.getProperty("RSESSION_HOME", FileUtils.getTempDirectoryPath()), ".Renjin"), "" + rand) + "\n or " + new File(new File(FileUtils.getUserDirectory(), ".Renjin"), "" + rand));
                }
            }
            this.eval("setwd('" + this.toRpath(this.wdir.getAbsolutePath()) + "')");
            this.wdir.deleteOnExit();
        }
        catch (Exception ex) {
            this.log("Could not use directory: " + this.wdir + "\n" + ex.getMessage(), RLog.Level.ERROR);
        }
        this.setenv(properties);
    }

    @Override
    void setenv(Properties properties) {
        if (properties != null) {
            for (String p : properties.stringPropertyNames()) {
                if (p == null) continue;
                try {
                    this.log("Setting environment " + p + ": '" + properties.getProperty(p).replaceAll("\\:([^/])(.*)\\@", ":???@") + "'", RLog.Level.INFO);
                    boolean done = this.set(p, properties.getProperty(p));
                    if (done) continue;
                    this.log("Failed setting environment " + p, RLog.Level.WARNING);
                }
                catch (Exception ex) {
                    this.log(ex.getMessage(), RLog.Level.WARNING);
                    ex.printStackTrace();
                }
            }
        }
    }

    public R2jsSession(PrintStream p, Properties properties) {
        this(p, properties, null);
    }

    public R2jsSession(PrintStream p, Properties properties, String environmentName) {
        this(new RLogPrintStream(p), properties, environmentName);
    }

    public void addReturnNullFunction(String name) throws ScriptException {
        this.js.eval("function " + name + "(a,b,c,d,e,f) {return null;}");
        this.functionsSet.add(name);
    }

    public void addJSFunction(String name, String js) throws ScriptException {
        this.js.eval("function " + name + (js.startsWith("function") ? js.substring("function".length()) : js));
        this.functionsSet.add(name);
    }

    private synchronized void loadJSLibraries() throws ScriptException {
        if (!jsLibraries.containsKey("math")) {
            InputStream mathInputStream = this.getClass().getResourceAsStream(MATH_JS_FILE);
            this.js.eval(new InputStreamReader(mathInputStream, Charset.forName("UTF-8")));
            jsLibraries.put("math", this.js.get("math"));
        } else {
            this.js.put("math", jsLibraries.get("math"));
        }
        this.js.eval("var parser = math.parser();");
        this.js.eval("math.config({matrix: 'Array'})");
        this.js.eval("var str = String.prototype;");
        this.js.eval("var T = true;");
        this.js.eval("var F = false;");
        if (!jsLibraries.containsKey("rand")) {
            InputStream randInputStream = this.getClass().getResourceAsStream(RAND_JS_FILE);
            this.js.eval(new InputStreamReader(randInputStream, Charset.forName("UTF-8")));
            this.js.eval("__rand = rand()");
            jsLibraries.put("__rand", this.js.get("rand"));
        } else {
            this.js.put("__rand", jsLibraries.get("rand"));
        }
        if (!jsLibraries.containsKey("R")) {
            InputStream RInputStream = this.getClass().getResourceAsStream(R_JS_FILE);
            this.js.eval(new InputStreamReader(RInputStream, Charset.forName("UTF-8")));
            this.js.eval("__R = R()");
            jsLibraries.put("__R", this.js.get("R"));
        } else {
            this.js.put("__R", jsLibraries.get("R"));
        }
    }

    public static String nameRtoJs(String e) {
        if (e.contains(POINT_CHAR_JS_KEY)) {
            throw new IllegalArgumentException("Cannot use __ in expression (reserved substring): " + e);
        }
        return e.replace(".", POINT_CHAR_JS_KEY);
    }

    private void checkBracketsCount(String expression, char openingBracket, char closingBracket) {
        long countClosingBrackets;
        long countOpeningBrackets = expression.chars().filter(ch -> ch == openingBracket).count();
        if (countOpeningBrackets != (countClosingBrackets = expression.chars().filter(ch -> ch == closingBracket).count())) {
            throw new IllegalArgumentException("Not the same number of opening bracket '" + openingBracket + "' and closing brackets '" + closingBracket + "' ( " + countOpeningBrackets + "!=" + countClosingBrackets + ")");
        }
    }

    private void checkExpressionValidity(String expression) throws IllegalArgumentException {
        this.checkBracketsCount(expression, '(', ')');
        this.checkBracketsCount(expression, '[', ']');
        this.checkBracketsCount(expression, '{', '}');
        int commaIndex = expression.indexOf(",");
        if (commaIndex >= 0) {
            String endingStoppingCharacters = ")]";
            String startingStoppingCharacters = "([";
            int nextParenthesis = R2jsSession.getNextExpressionLastIndex(expression, commaIndex, endingStoppingCharacters);
            int prevParenthesis = R2jsSession.getPreviousExpressionFirstIndex(expression, commaIndex, startingStoppingCharacters);
            if (prevParenthesis <= 0 && !startingStoppingCharacters.contains("" + expression.charAt(0))) {
                throw new IllegalArgumentException("No opening bracket before ',' at index " + commaIndex);
            }
            if (nextParenthesis >= expression.length() - 1 && !endingStoppingCharacters.contains("" + expression.charAt(expression.length() - 1))) {
                throw new IllegalArgumentException("No closing bracket after ',' at index " + commaIndex);
            }
        }
        this.comaSyntaxCheck(expression);
    }

    private void comaSyntaxCheck(String e) throws IllegalArgumentException {
        Matcher m = Pattern.compile("(^|([=*\\+-<>()&%!^\\/\\s]\\b([^a-zA-Z_$,=*+\\-<()>&%!^\\/\\s])[a-zA-Z0-9_]*)|[=*+\\-<()>&%!^])[(](.[^,)(]*),(.[^,)(]*)[)]").matcher(e);
        if (m.find()) {
            int comaIdx = e.indexOf(",", m.start());
            throw new IllegalArgumentException("wrong syntax with ',' at index " + comaIdx + ". Use '.' instead of ','?");
        }
    }

    private String convertRtoJs(String e) throws Rsession.RException {
        if (e.contains(THIS_ENVIRONMENT)) {
            return this.convertRtoJs(e.replace(THIS_ENVIRONMENT, "THEENVIRONMENT")).replace("THEENVIRONMENT", THIS_ENVIRONMENT);
        }
        String R = null;
        if (this.debug_js) {
            R = e;
        }
        e = this.removeCommentedLines(e);
        e = e.replaceAll(";+ *\\n", "\n");
        if (R_TO_JS != null) {
            for (Object object : R_TO_JS.keySet()) {
                String var = Pattern.quote(object.toString());
                String regexp = AW + var + (object.toString().endsWith("(") ? ")" : Az);
                Matcher m = Pattern.compile(regexp).matcher(e);
                while (m.find()) {
                    String val = R_TO_JS.getProperty(object.toString());
                    e = e.replace(m.group(), m.group().replace(object.toString(), val));
                }
            }
        }
        Matcher m = Pattern.compile("(\\d|\\d\\.)+[eE]+([+-])*(\\d*)").matcher(e);
        while (m.find()) {
            try {
                e = e.replace(m.group(), this.formatter.format(Double.parseDouble(m.group())));
            }
            catch (Exception exception) {}
        }
        this.quotesList = R2jsSession.replaceQuotesByVariables(e, 1);
        e = this.quotesList.get(0);
        this.checkExpressionValidity(e);
        e = e.replaceAll("([a-zA-Z]*)\\.([a-zA-Z]+)", "$1__$2");
        e = e.replaceAll("0+\\.([^0-9]|$)", "0$1");
        e = e.replaceAll("(?<!\\.)\\b0+([1-9\\.])", "$1");
        e = e.replaceAll("(?<!\\.)(\\b)ceiling(?<!\\.)(\\b)", "ceil");
        for (String f : MATH_FUN_JS) {
            e = e.replaceAll("(?<!\\.)(\\b)" + f + "\\(", "$1 math." + f + "(");
        }
        for (String c : MATH_CONST_JS) {
            e = e.replaceAll("(?<!\\.)(\\b)" + c + "(?<!\\.)(\\b)", "$1 math." + c.toUpperCase() + "$2");
        }
        e = e.replaceAll("(^|[^a-zA-Z\\d:])t\\(", "$1math.transpose(");
        e = e.replaceAll("(^|[^a-zA-Z\\d:])determinant\\(", "$1math.det(");
        e = e.replaceAll("(^|[^a-zA-Z\\d:])solve\\(", "$1math.lusolve(");
        e = e.replaceAll("(^|[^a-zA-Z\\d\\.:])dim\\(", "$1__R.dim(");
        e = e.replaceAll("<<-", "=");
        e = e.replaceAll("<-", "=");
        e = e.replaceAll("\\+ *-", "-");
        e = e.replaceAll("^ *-", "0-");
        e = e.replaceAll("[(]([^=\\s]+)\\s*in\\s*([\\w\\-]+)\\s*:\\s*([[\\w\\-][.][)][(]]+)[)]\\s*", "($1=$2; $1<=$3; $1++) ");
        e = e.replaceAll("(?<!\\.)(\\b)if \\(", "if(");
        e = R2jsSession.addIfElseBrackets(e);
        e = e.replaceAll("function([.[^)]]*[)]) *([a-zA-Z0-9].*)$", "function$1 {$2}");
        e = e.replaceAll("function([.[^)]]*[)]) *[{]\\s*(((?!return|function).)*)\\s*[}];*$", "function$1 {return $2}");
        e = e.replaceAll("\\*\\*", "\\^");
        e = R2jsSession.replaceIndexesSet(e);
        e = R2jsSession.replaceIndexes(e);
        e = e.replaceAll("(?<!\\.)(\\b)c[(]([.[^):]]*)[)]", "$1[$2]");
        e = e.replaceAll("(?<!\\.)(\\b)c[(]([.[^)]]*)[)]", "$1$2");
        e = e.replaceAll("for *[(]([\\w\\-]+) +in +([\\w\\-]+)[)] *[{]", "var $2Length = __R.dim($2)[0]; for(var i = 0; i < $2Length; i++) {$1 = $2[i]; ");
        e = e.replaceAll("(?<!\\.)(\\b)TRUE(\\b)", "true");
        e = e.replaceAll("(?<!\\.)(\\b)FALSE(\\b)", "false");
        e = e.replaceAll("(?<!\\.)(\\b)NULL(\\b)", "null");
        e = e.replaceAll("(?<!\\.)(\\b)NA(\\b)", "null");
        e = e.replaceAll("([^ ]+)\\+\\+", "$1=$1+1");
        e = e.replaceAll("([^ ]+) *\\+\\=", "$1=$1+");
        e = e.replaceAll("\\=\\=", "\u00ea");
        e = e.replaceAll("\\<\\=", "\u015d");
        e = e.replaceAll("\\>\\=", "\u011d");
        e = e.replaceAll("\\|\\|", "\u00f4");
        e = e.replaceAll("\\&\\&", "\u00e2");
        e = R2jsSession.replaceOperators(e);
        Matcher matcher = Pattern.compile("(.*function)[(](.*=.*)[)] *[{]").matcher(e);
        if (matcher.find()) {
            matcher.reset();
            StringBuffer sb = new StringBuffer("");
            while (matcher.find()) {
                sb.append(matcher.group(1));
                String functionCorrected = R2jsSession.replaceFunctionDefaultArguments(matcher.group(2));
                matcher.appendReplacement(sb, functionCorrected);
            }
            matcher.appendTail(sb);
            e = sb.toString();
        }
        e = R2jsSession.createMatrix(e);
        e = R2jsSession.createArray(e);
        e = R2jsSession.createWriteCSV(e);
        e = this.createDataFrame(e);
        e = e.replaceAll("(?<!\\.)(\\b)list\\(\\)", "{}");
        e = this.createList(e);
        e = this.createSetEnv(e);
        e = this.createPaste(e);
        e = this.createPaste0(e);
        e = this.createLs(e);
        e = this.createSaveFunction(e);
        e = this.createLoadFunction(e);
        e = R2jsSession.createLengthFunction(e);
        e = R2jsSession.createFileExistsFunction(e);
        e = this.createExistsFunction(e);
        e = R2jsSession.createStopIfNotFunction(e);
        e = e.replaceAll(" in ([^\\{]+)\\{", " in __R._in($1){");
        e = e.replaceAll("if *\\(([^\\{\\n]+)\\)\\s*(\\{|(return))", "if (__R._if($1)) $2");
        e = e.replaceAll("return(.*)\n", "return$1 ;\n");
        e = e.replaceAll("(.[^\\n+-=/\\*]+)\n", "$1 ;\n");
        e = e.replaceAll("^ *\\+", "");
        e = e.replaceAll("\\{ *;", "\\{");
        e = e.replaceAll("\\[ *;", "\\[");
        e = e.replaceAll("\\( *;", "\\(");
        e = e.replaceAll("; *;", ";");
        e = e.replaceAll("(?<!\\.)(\\b)is__array\\(", "$1Array.isArray(");
        e = e.replaceAll("(?<!\\.)(\\b)ncol\\(", "$1__R.ncol(");
        e = e.replaceAll("(?<!\\.)(\\b)nrow\\(", "$1__R.nrow(");
        e = e.replaceAll("(?<!\\.)(\\b)names\\(((\\w|\\.)+)\\)\\s*=\\s*", "$1 $2.names = ");
        e = e.replaceAll("(?<!\\.)(\\b)names\\(", "$1__R.names(");
        e = e.replaceAll("(?<!\\.)(\\b)length\\(", "$1__R.length(");
        e = e.replaceAll("(?<!\\.)(\\b)dim\\(", "$1__R.dim(");
        e = e.replaceAll("(?<!\\.)(\\b)reLen\\(", "$1__R.repLen(");
        e = e.replaceAll("(?<!\\.)(\\b)rep\\(", "$1__R.rep(");
        e = e.replaceAll("(?<!\\.)(\\b)which\\(", "$1__R.which(");
        e = e.replaceAll("(?<!\\.)(\\b)whichMin\\(", "$1__R.whichMin(");
        e = e.replaceAll("(?<!\\.)(\\b)whichMax\\(", "$1__R.whichMax(");
        e = e.replaceAll("(?<!\\.)(\\b)_print\\(", "$1__R._print(");
        e = e.replaceAll("(?<!\\.)(\\b)getwd\\(", "$1__R.getwd(");
        e = e.replaceAll("(?<!\\.)(\\b)setwd\\(", "$1__R.setwd(");
        e = e.replaceAll("(?<!\\.)(\\b)SysSleep\\(", "$1__R.SysSleep(");
        e = e.replaceAll("(?<!\\.)(\\b)SysGetEnv\\(", "$1__R.SysGetEnv(");
        e = e.replaceAll("(?<!\\.)(\\b)isFunction\\(", "$1__R.isFunction(");
        e = e.replaceAll("(?<!\\.)(\\b)isNull\\(", "$1__R.isNull(");
        e = e.replaceAll("(?<!\\.)(\\b)isNA\\(", "$1__R.isNA(");
        e = e.replaceAll("(?<!\\.)(\\b)isTRUE\\(", "$1__R.isTRUE(");
        e = e.replaceAll("(?<!\\.)(\\b)isFALSE\\(", "$1__R.isFALSE(");
        e = e.replaceAll("(?<!\\.)(\\b)apply\\(", "$1__R.apply(");
        e = e.replaceAll("(?<!\\.)(\\b)rbind\\(", "$1__R.rbind(");
        e = e.replaceAll("(?<!\\.)(\\b)cbind\\(", "$1__R.cbind(");
        e = e.replaceAll("(?<!\\.)(\\b)Rpaste\\(", "$1__R.paste(");
        e = e.replaceAll("(?<!\\.)(\\b)all\\(", "$1__R.all(");
        e = e.replaceAll("(?<!\\.)(\\b)any\\(", "$1__R.any(");
        e = e.replaceAll("(?<!\\.)(\\b)strsplit\\(", "$1__R.strsplit(");
        e = e.replaceAll("(?<!\\.)(\\b)unlist\\(", "$1__R.unlist(");
        e = e.replaceAll("(?<!\\.)(\\b)Rpaste0\\(", "$1__R.paste0(");
        e = e.replaceAll("(?<!\\.)(\\b)asNumeric\\(", "$1__R.asNumeric(");
        e = e.replaceAll("(?<!\\.)(\\b)asInteger\\(", "$1__R.asInteger(");
        e = e.replaceAll("(?<!\\.)(\\b)asLogical\\(", "$1__R.asLogical(");
        e = e.replaceAll("(?<!\\.)(\\b)asCharacter\\(", "$1__R.asCharacter(");
        e = e.replaceAll("__R\\.__R\\.", "__R.");
        e = e.replaceAll("(?<!\\.)(\\b)runif\\(", "$1__rand.runif(");
        e = e.replaceAll("(?<!\\.)(\\b)rnorm\\(", "$1__rand.rnorm(");
        e = e.replaceAll("(?<!\\.)(\\b)rpois\\(", "$1__rand.rpois(");
        e = e.replaceAll("(?<!\\.)(\\b)rcauchy\\(", "$1__rand.rcauchy(");
        e = e.replaceAll("(?<!\\.)(\\b)rchisq\\(", "$1__rand.rchisq(");
        e = e.replaceAll("__rand\\.__rand\\.", "__rand.");
        e = R2jsSession.replaceReturnIf(e);
        try {
            e = this.convertFunction(e);
        }
        catch (ScriptException ex) {
            Logger.getLogger(R2jsSession.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.storeGlobalVariables(e);
        e = this.replaceArgsNames(e, POINT_CHAR_JS_KEY);
        e = this.replaceVariables(e, this.variablesSet, "__this__.");
        e = R2jsSession.replaceNameByQuotes(this.quotesList, e, false);
        e = e.replaceAll("\\$__this__\\.", "\\$");
        e = e.replaceAll("(\\S[^\\$]?+)\\$([^\\$]?+)", "$1.$2");
        e = e.replaceAll("(\\S[^\\$]?+)\\[\\['([\\w.]+)'\\]\\]\\[(\\d+)\\]", "$1.$2 [ $3 -1]");
        e = e.replaceAll("(\\S[^\\$]?+)\\[\\['([\\w.]+)'\\]\\]", "$1.$2");
        e = e.replaceAll("#", "//");
        if (this.debug_js) {
            String[] lines_R = R.split("\n");
            String[] lines_JS = e.split("\n");
            int w = this.maxLength(lines_R);
            System.err.println("------------------------------------------------------------------------------------");
            for (int i = 0; i < Math.max(lines_R.length, lines_JS.length); ++i) {
                System.err.println(this.rightPad(lines_R.length > i ? lines_R[i] : "", w) + " | " + this.rightPad(i + 1 + "", 3) + " | " + (lines_JS.length > i ? lines_JS[i] : ""));
            }
            System.err.println("------------------------------------------------------------------------------------");
        }
        return e;
    }

    private String convertFunction(String expr) throws ScriptException {
        expr = expr.replaceAll("[(](\\w)", "( $1");
        Pattern indexPattern = Pattern.compile("(^|[^\\.\\w])((?!function|if|for|while|switch|return)\\w+)[(]");
        Matcher indexMatcher = indexPattern.matcher(expr);
        if (indexMatcher.find()) {
            indexMatcher.reset();
            while (indexMatcher.find()) {
                String fctName = indexMatcher.group(2);
                if (this.variablesSet.contains(fctName) || this.asLogical(this.js.eval("typeof " + fctName + " !== 'undefined'"))) continue;
                this.variablesSet.add(fctName);
            }
        } else {
            return expr;
        }
        return expr;
    }

    int maxLength(String ... s) {
        int ml = 0;
        for (String l : s) {
            ml = Math.max(ml, l.length());
        }
        return ml;
    }

    String rightPad(String s, int pad) {
        if (s == null) {
            s = "";
        }
        if (s.length() > pad) {
            return s.substring(0, pad);
        }
        StringBuffer sb = new StringBuffer(pad);
        for (int i = 0; i < pad - s.length(); ++i) {
            sb.append(" ");
        }
        return s + sb.toString();
    }

    private String removeCommentedLines(String expr) {
        String[] lines;
        StringBuilder sb = new StringBuilder();
        for (String line : lines = expr.split("\\r?\\n")) {
            if (line.trim().startsWith("#")) continue;
            sb.append(line);
            sb.append("\n");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private String replaceArgsNames(String expr, String prefix) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "function");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            Collection arguments = Arrays.stream(argumentsMap.get("default").split(",")).map(String::trim).collect(Collectors.toList());
            int ifStartBracketIndex = result.substring(endIndex).indexOf("{") + endIndex;
            int fctCloseBracketIndex = R2jsSession.getNextExpressionLastIndex(result, ifStartBracketIndex + 1, "}") + 1;
            if (fctCloseBracketIndex + 1 >= result.length()) {
                --fctCloseBracketIndex;
            }
            String function = result.substring(startIndex, fctCloseBracketIndex + 1);
            String replacedFunction = this.replaceVariables(function, arguments, prefix);
            replacedFunction = replacedFunction.replaceAll("(\\b)function(\\b)", "$1_function$2");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(replacedFunction);
            sb.append(result.substring(fctCloseBracketIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "function");
        }
        result = result.replaceAll("(\\b)_function(\\b)", "$1function$2");
        for (String f : this.variablesSet) {
            Pattern fPattern = Pattern.compile("\\b(" + f + ")\\(([^\\)]*)\\)");
            Matcher fMatcher = fPattern.matcher(result);
            if (!fMatcher.find()) continue;
            fMatcher.reset();
            StringBuffer result_buf = new StringBuffer();
            while (fMatcher.find()) {
                String args = " " + fMatcher.group(2) + " ";
                String[] argsArray = R2jsSession.splitString(args, ",");
                StringBuffer args_buf = new StringBuffer();
                for (int i = 0; i < argsArray.length; ++i) {
                    if (argsArray[i].contains("=")) {
                        String[] kv_arg = argsArray[i].split("=");
                        argsArray[i] = POINT_CHAR_JS_KEY + kv_arg[0].trim() + " = " + kv_arg[1];
                    }
                    args_buf.append(argsArray[i] + (i == argsArray.length - 1 ? "" : ","));
                }
                fMatcher.appendReplacement(result_buf, (f + "(" + args_buf.toString() + ")").replace("$", "\\$"));
            }
            fMatcher.appendTail(result_buf);
            result = result_buf.toString();
        }
        return result;
    }

    private String replaceVariables(String expr, Iterable<String> variables, String prefix) {
        String result = expr;
        for (String variable : variables) {
            if (variable.length() <= 0) continue;
            result = result.replaceAll("\\b(?<![\\$\\.[__]])" + variable + "\\b", prefix + variable);
            result = result.replaceAll(prefix + prefix, prefix);
        }
        return result;
    }

    static List<String> replaceQuotesByVariables(String expr, int startIndex) throws Rsession.RException {
        ArrayList<String> quotesList = new ArrayList<String>();
        String singleQuote = "'";
        String doubleQuote = "\"";
        int cmp = startIndex;
        quotesList.add(expr);
        StringBuffer currentExpr = new StringBuffer(expr);
        while (true) {
            int doubleQuoteIdx = currentExpr.indexOf(doubleQuote);
            int singleQuoteIdx = currentExpr.indexOf(singleQuote);
            int startQuoteIdx = -1;
            String currentQuote = "";
            if (singleQuoteIdx >= 0 && (doubleQuoteIdx < 0 || singleQuoteIdx < doubleQuoteIdx)) {
                currentQuote = singleQuote;
                startQuoteIdx = singleQuoteIdx;
            } else {
                currentQuote = doubleQuote;
                startQuoteIdx = doubleQuoteIdx;
            }
            if (startQuoteIdx < 0) break;
            int endQuoteIdx = currentExpr.indexOf(currentQuote, startQuoteIdx + 1);
            if (endQuoteIdx <= startQuoteIdx) {
                throw new Rsession.RException("No ending quotes for quote " + currentQuote + " at position: " + startQuoteIdx + " in: " + expr);
            }
            String quotedExpr = currentExpr.substring(startQuoteIdx, endQuoteIdx + 1);
            quotesList.add(quotedExpr);
            currentExpr.replace(startQuoteIdx, endQuoteIdx + 1, "QUOTE_EXPRESSION_" + cmp + "_");
            ++cmp;
        }
        quotesList.set(0, currentExpr.toString());
        return quotesList;
    }

    static String replaceNameByQuotes(List<String> quotesList, String expr, boolean removeRoundingQuotes) {
        for (int i = 1; i < quotesList.size(); ++i) {
            String quote = quotesList.get(i).trim();
            if (removeRoundingQuotes) {
                quote = quote.substring(1, quote.length() - 1);
            }
            quote = quote.replace("\\", "\\\\\\\\");
            expr = expr.replaceAll("QUOTE_EXPRESSION_" + i + "_", quote);
        }
        return expr;
    }

    private String createLs(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "ls");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String pattern = argumentsMap.get("pattern");
            StringBuilder unifRandomSb = new StringBuilder();
            if (pattern != null) {
                unifRandomSb.append("__R.removeMatching(Object.keys(");
                unifRandomSb.append(THIS_ENVIRONMENT);
                unifRandomSb.append("), new RegExp(");
                unifRandomSb.append(pattern);
                unifRandomSb.append("))");
            } else {
                unifRandomSb.append("Object.keys(");
                unifRandomSb.append(THIS_ENVIRONMENT);
                unifRandomSb.append(")");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(unifRandomSb.toString());
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "ls");
        }
        return result;
    }

    @Override
    public String[] ls(boolean all) {
        LinkedList<String> variablesandfunctions = new LinkedList<String>();
        variablesandfunctions.addAll(this.variablesSet);
        variablesandfunctions.addAll(this.functionsSet);
        variablesandfunctions.removeAll(Arrays.asList(DISABLED_FUNCTIONS));
        if (all) {
            return variablesandfunctions.toArray(new String[0]);
        }
        LinkedList<String> notall = new LinkedList<String>();
        for (String v : variablesandfunctions) {
            if (v.startsWith("_")) continue;
            notall.add(v);
        }
        return notall.toArray(new String[0]);
    }

    private static String[] splitString(String expr, String sep) {
        ArrayList<String> splitList = new ArrayList<String>();
        int sepIndex = -1;
        int exprLength = expr.length();
        while (sepIndex < exprLength) {
            int nextIndex = R2jsSession.getNextExpressionLastIndex(expr, sepIndex, sep) + 1;
            String argumentName = expr.substring(sepIndex + 1, nextIndex).trim();
            splitList.add(argumentName);
            sepIndex = nextIndex;
        }
        return splitList.toArray(new String[0]);
    }

    static String arrayIfNeeded(String[] l) {
        if (l == null) {
            return null;
        }
        StringBuffer arrayif = new StringBuffer(l[0]);
        boolean truearray = false;
        if (l.length > 0) {
            for (int i = 1; i < l.length; ++i) {
                if (l[i].trim().length() <= 0) continue;
                truearray = true;
                arrayif.append(" , " + l[i]);
            }
        }
        if (truearray) {
            return " " + arrayif.toString() + " ";
        }
        return arrayif.toString();
    }

    public static String replaceIndexes(String expr) {
        Matcher intricated = Pattern.compile(".*(\\[+)(.[^\\]]+)(\\[).*").matcher(expr);
        if (intricated.find()) {
            intricated.reset();
            LinkedList<String> found = new LinkedList<String>();
            while (intricated.find()) {
                found.add(intricated.group(1) + intricated.group(2) + intricated.group(3));
            }
            throw new UnsupportedOperationException("Intricated indexes 'abc[def[i]]' not supported at:" + String.join((CharSequence)"\n", found));
        }
        Pattern indexPattern = Pattern.compile(index_pattern);
        Matcher indexMatcher = indexPattern.matcher(expr);
        if (indexMatcher.find()) {
            indexMatcher.reset();
            StringBuffer sb = new StringBuffer("");
            while (indexMatcher.find()) {
                String arrayName = indexMatcher.group(1);
                String indexes = " " + indexMatcher.group(3) + " ";
                if (indexes.trim().startsWith("QUOTE_EXPRESSION_")) {
                    return expr;
                }
                String[] indexesArray = R2jsSession.splitString(indexes, ",");
                for (int i = 0; i < indexesArray.length; ++i) {
                    if (!indexesArray[i].trim().equals("")) continue;
                    int dim = i;
                    indexesArray[i] = "math.range(1, 1+math.subset(dim(" + arrayName + "), math.index(" + dim + ")))";
                }
                StringBuilder result = new StringBuilder();
                result.append("math.squeeze(math.subset(");
                result.append(arrayName);
                result.append(", __R._index(");
                result.append(R2jsSession.arrayIfNeeded(indexesArray));
                result.append(")))");
                indexMatcher.appendReplacement(sb, result.toString().replace("$", "\\$"));
            }
            indexMatcher.appendTail(sb);
            return sb.toString();
        }
        return expr;
    }

    public static String replaceIndexesSet(String expr) {
        Matcher intricated = Pattern.compile(".*(\\[+)(.[^\\]]+)(\\[).*").matcher(expr);
        if (intricated.find()) {
            intricated.reset();
            LinkedList<String> found = new LinkedList<String>();
            while (intricated.find()) {
                found.add(intricated.group(1) + intricated.group(2) + intricated.group(3));
            }
            throw new UnsupportedOperationException("Intricated indexes 'abc[def[i]]' not supported at:" + String.join((CharSequence)"\n", found));
        }
        Pattern indexPattern = Pattern.compile(index_pattern + "\\s*[\\=]{1}(.*)");
        Matcher indexMatcher = indexPattern.matcher(expr);
        if (indexMatcher.find()) {
            indexMatcher.reset();
            StringBuffer sb = new StringBuffer("");
            while (indexMatcher.find()) {
                String arrayName = indexMatcher.group(1);
                String indexes = " " + indexMatcher.group(3) + " ";
                if (indexes.trim().startsWith("QUOTE_EXPRESSION_")) {
                    return expr;
                }
                String toset = " " + indexMatcher.group(4) + " ";
                String[] indexesArray = R2jsSession.splitString(indexes, ",");
                for (int i = 0; i < indexesArray.length; ++i) {
                    if (!indexesArray[i].trim().equals("")) continue;
                    int dim = i;
                    indexesArray[i] = "math.range(1, 1+math.subset(dim(" + arrayName + "), math.index(" + dim + ")))";
                }
                StringBuilder result = new StringBuilder();
                result.append(arrayName + " = math.subset(");
                result.append(arrayName);
                result.append(", __R._index(");
                result.append(R2jsSession.arrayIfNeeded(indexesArray));
                result.append(")," + toset + ")");
                indexMatcher.appendReplacement(sb, result.toString().replace("$", "\\$"));
            }
            indexMatcher.appendTail(sb);
            return sb.toString();
        }
        return expr;
    }

    private static String addIfElseBrackets(String expr) {
        String ifReplacementString = "__IF__";
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "if", true);
        while (rFunctionArgumentsDTO != null) {
            String ifStatement;
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String ifArg = argumentsMap.get("default");
            StringBuilder ifSb = new StringBuilder();
            ifSb.append("__IF__");
            ifSb.append("(");
            ifSb.append(ifArg);
            ifSb.append(")");
            int elseIndex = result.indexOf("else", endIndex);
            boolean dontCloseBrack = false;
            if (elseIndex >= 0) {
                ifStatement = result.substring(endIndex + 1, elseIndex).trim();
                if (!ifStatement.startsWith("{")) {
                    ifSb.append("{");
                }
                ifSb.append(ifStatement);
                if (!ifStatement.endsWith("}")) {
                    ifSb.append("}");
                }
                ifSb.append(" else ");
                String elseStatement = result.substring(elseIndex + 4).trim();
                if (!elseStatement.startsWith("{") && !elseStatement.startsWith("if")) {
                    ifSb.append("{");
                }
                ifSb.append(elseStatement);
                if (!elseStatement.startsWith("{") && !elseStatement.startsWith("if")) {
                    ifSb.append("}");
                }
            } else {
                ifStatement = result.substring(endIndex + 1, result.length()).trim();
                if (!ifStatement.startsWith("{")) {
                    ifSb.append("{");
                    int returnLineIdx = ifStatement.indexOf(10);
                    if (returnLineIdx >= 0) {
                        ifStatement = ifStatement.substring(0, returnLineIdx) + "}" + ifStatement.substring(returnLineIdx, ifStatement.length());
                        ifSb.append(ifStatement);
                        dontCloseBrack = true;
                    } else {
                        ifSb.append(ifStatement);
                        ifSb.append("}");
                    }
                } else {
                    ifSb.append(ifStatement);
                    dontCloseBrack = true;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(ifSb.toString());
            if (!dontCloseBrack && !ifSb.toString().trim().endsWith("}")) {
                sb.append("}");
            }
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "if", true);
        }
        result = result.replaceAll("__IF__", "if");
        return result;
    }

    private static String createWriteCSV(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "write__csv");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String data = argumentsMap.get("data");
            String file = argumentsMap.get("file");
            StringBuilder unifRandomSb = new StringBuilder();
            unifRandomSb.append("__R.write(");
            unifRandomSb.append(file);
            unifRandomSb.append(", ");
            unifRandomSb.append(data.trim());
            unifRandomSb.append(".toString())");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(unifRandomSb.toString());
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "write__csv");
        }
        return result;
    }

    private String createDataFrame(String expr) throws Rsession.RException {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "data__frame");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            StringBuilder dataFrameSb = new StringBuilder();
            dataFrameSb.append("__R.createMathObject({");
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            for (Map.Entry<String, String> entry : argumentsMap.entrySet()) {
                String value;
                String key = entry.getKey();
                if (key.equals(value = entry.getValue())) {
                    dataFrameSb.append("'");
                }
                dataFrameSb.append(key);
                if (key.equals(value)) {
                    dataFrameSb.append("'");
                }
                dataFrameSb.append(":");
                dataFrameSb.append(value);
                dataFrameSb.append(",");
            }
            dataFrameSb.replace(dataFrameSb.length() - 1, dataFrameSb.length(), "})");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(dataFrameSb.toString());
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            List<String> newQuoteList = R2jsSession.replaceQuotesByVariables(result, this.quotesList.size());
            result = newQuoteList.get(0);
            for (int i = 1; i < newQuoteList.size(); ++i) {
                this.quotesList.add(newQuoteList.get(i));
            }
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "data__frame");
        }
        return result;
    }

    private String createList(String expr) throws Rsession.RException {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "list");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            StringBuilder dataFrameSb = new StringBuilder();
            dataFrameSb.append("__R.createMathObject({");
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            for (Map.Entry<String, String> entry : argumentsMap.entrySet()) {
                String value;
                String key = entry.getKey();
                if (key.equals(value = entry.getValue())) {
                    dataFrameSb.append("'");
                }
                dataFrameSb.append(key);
                if (key.equals(value)) {
                    dataFrameSb.append("'");
                }
                dataFrameSb.append(":");
                dataFrameSb.append(value);
                dataFrameSb.append(",");
            }
            dataFrameSb.replace(dataFrameSb.length() - 1, dataFrameSb.length(), "})");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(dataFrameSb.toString());
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            List<String> newQuoteList = R2jsSession.replaceQuotesByVariables(result, this.quotesList.size());
            result = newQuoteList.get(0);
            for (int i = 1; i < newQuoteList.size(); ++i) {
                this.quotesList.add(newQuoteList.get(i));
            }
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "list");
        }
        if (result.startsWith("{") && result.endsWith("}")) {
            result = "(" + result + ")";
        }
        return result;
    }

    private String createSetEnv(String expr) throws Rsession.RException {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "Sys__setenv");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            StringBuilder dataFrameSb = new StringBuilder();
            dataFrameSb.append("__R.SysSetEnv({");
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            for (Map.Entry<String, String> entry : argumentsMap.entrySet()) {
                String value;
                String key = entry.getKey();
                if (key.equals(value = entry.getValue())) {
                    dataFrameSb.append("'");
                }
                dataFrameSb.append(key);
                if (key.equals(value)) {
                    dataFrameSb.append("'");
                }
                dataFrameSb.append(":");
                dataFrameSb.append(value);
                dataFrameSb.append(",");
            }
            dataFrameSb.replace(dataFrameSb.length() - 1, dataFrameSb.length(), "})");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(dataFrameSb.toString());
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            List<String> newQuoteList = R2jsSession.replaceQuotesByVariables(result, this.quotesList.size());
            result = newQuoteList.get(0);
            for (int i = 1; i < newQuoteList.size(); ++i) {
                this.quotesList.add(newQuoteList.get(i));
            }
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "Sys__setenv");
        }
        return result;
    }

    public static void setEnv(String k, String v) {
        Env.put(k, v);
    }

    public static String getEnv(String k) {
        if (Env.containsKey(k)) {
            return Env.get(k);
        }
        if (System.getenv().containsKey(k)) {
            return System.getenv().get(k);
        }
        if (System.getProperties().containsKey(k)) {
            return System.getProperties().get(k).toString();
        }
        return "";
    }

    private static String createMatrix(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "matrix");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String data = argumentsMap.get("data");
            String nrow = argumentsMap.get("nrow");
            String ncol = argumentsMap.get("ncol");
            String byrow = argumentsMap.get("byrow");
            StringBuilder arraySb = new StringBuilder();
            if (nrow == null && ncol == null) {
                nrow = "math.prod(dim(" + data + "))";
                ncol = "1";
            } else if (nrow != null) {
                if (ncol == null) {
                    ncol = "math.ceil(math.dotDivide(math.prod(dim(" + data + ")), " + nrow + "))";
                }
            } else if (ncol != null) {
                nrow = "math.ceil(math.dotDivide(math.prod(dim(" + data + ")), " + ncol + "))";
            }
            StringBuilder stringDimArraybuilder = new StringBuilder();
            stringDimArraybuilder.append("dim = [");
            stringDimArraybuilder.append(nrow);
            stringDimArraybuilder.append(", ");
            stringDimArraybuilder.append(ncol);
            stringDimArraybuilder.append("]");
            String stringDimArray = stringDimArraybuilder.toString();
            if (byrow == null || byrow.equals("false")) {
                arraySb.append("math.transpose(math.reshape(__R.expendArray(");
                arraySb.append(data);
                arraySb.append(", math.prod(");
                arraySb.append(stringDimArray);
                arraySb.append(")), ");
                arraySb.append(stringDimArray);
                arraySb.append(".reverse()))");
            } else {
                arraySb.append("math.reshape(__R.expendArray(");
                arraySb.append(data);
                arraySb.append(", math.prod(");
                arraySb.append(stringDimArray);
                arraySb.append(")), ");
                arraySb.append(stringDimArray);
                arraySb.append(")");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)arraySb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "matrix");
        }
        return result;
    }

    private static String createArray(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "array");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String stringArray = argumentsMap.get("data");
            String stringDimArray = argumentsMap.get("dim");
            StringBuilder arraySb = new StringBuilder();
            if (stringDimArray != null) {
                arraySb.append("math.transpose(math.reshape(__R.expendArray(");
                arraySb.append(stringArray);
                arraySb.append(", math.prod(");
                arraySb.append(stringDimArray);
                arraySb.append(")), ");
                arraySb.append(stringDimArray);
                arraySb.append(".reverse()))");
            } else {
                arraySb.append("math.reshape(");
                arraySb.append(stringArray);
                arraySb.append(", math.multiply(math.ones(1),math.prod(dim(");
                arraySb.append(stringArray);
                arraySb.append("))))");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)arraySb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "array");
        }
        return result;
    }

    private String createPaste(String expr) throws Rsession.RException {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "paste");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            StringBuilder dataFrameSb = new StringBuilder();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String sep = argumentsMap.getOrDefault("sep", "' '");
            String collapse = argumentsMap.getOrDefault("collapse", "';'");
            dataFrameSb.append("Rpaste(" + sep + "," + collapse + ",");
            for (Map.Entry<String, String> entry : argumentsMap.entrySet()) {
                String key = entry.getKey();
                if (key.equals("sep") || key.equals("collapse")) continue;
                String value = entry.getValue();
                dataFrameSb.append(value);
                dataFrameSb.append(",");
            }
            dataFrameSb.replace(dataFrameSb.length() - 1, dataFrameSb.length(), ")");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(dataFrameSb.toString());
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            List<String> newQuoteList = R2jsSession.replaceQuotesByVariables(result, this.quotesList.size());
            result = newQuoteList.get(0);
            for (int i = 1; i < newQuoteList.size(); ++i) {
                this.quotesList.add(newQuoteList.get(i));
            }
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "paste");
        }
        return result;
    }

    private String createPaste0(String expr) throws Rsession.RException {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "paste0");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            StringBuilder dataFrameSb = new StringBuilder();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String collapse = argumentsMap.getOrDefault("collapse", "';'");
            dataFrameSb.append("Rpaste0(" + collapse + ",");
            for (Map.Entry<String, String> entry : argumentsMap.entrySet()) {
                String key = entry.getKey();
                if (key.equals("collapse")) continue;
                String value = entry.getValue();
                dataFrameSb.append(value);
                dataFrameSb.append(",");
            }
            dataFrameSb.replace(dataFrameSb.length() - 1, dataFrameSb.length(), ")");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append(dataFrameSb.toString());
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            List<String> newQuoteList = R2jsSession.replaceQuotesByVariables(result, this.quotesList.size());
            result = newQuoteList.get(0);
            for (int i = 1; i < newQuoteList.size(); ++i) {
                this.quotesList.add(newQuoteList.get(i));
            }
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "paste0");
        }
        return result;
    }

    private String createSaveFunction(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "save");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String listString = argumentsMap.get("list");
            String fileString = argumentsMap.get("file");
            String listStringUnquotted = listString.replace("'", "");
            StringBuilder saveSb = new StringBuilder();
            saveSb.append("__R.write(");
            saveSb.append(fileString);
            saveSb.append(", ");
            saveSb.append("__R.createJsonString(");
            saveSb.append(listStringUnquotted);
            saveSb.append(", ");
            saveSb.append(THIS_ENVIRONMENT);
            saveSb.append("))");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)saveSb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "save");
        }
        return result;
    }

    private String createLoadFunction(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "load");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String fileString = argumentsMap.get("file");
            try {
                String readVariablesExpr = R2jsSession.replaceNameByQuotes(this.quotesList, "__R.readJsonVariables(" + fileString + ")", false);
                String[] loadedVariables = (String[])this.cast(this.js.eval(readVariablesExpr));
                this.addGlobalVariables(loadedVariables);
            }
            catch (ScriptException ex) {
                Logger.getLogger(R2jsSession.class.getName()).log(Level.SEVERE, null, ex);
            }
            StringBuilder loadSb = new StringBuilder();
            loadSb.append("__R.loadJson(");
            loadSb.append(fileString);
            loadSb.append(", ");
            loadSb.append(THIS_ENVIRONMENT);
            loadSb.append(")");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)loadSb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "load");
        }
        return result;
    }

    private static String createLengthFunction(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "length");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String values = argumentsMap.get("default");
            StringBuilder rbindSb = new StringBuilder();
            rbindSb.append("math.squeeze(math.subset(dim(");
            rbindSb.append(values);
            rbindSb.append("), math.index(0)))");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)rbindSb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "length");
        }
        return result;
    }

    private static String replaceReturnIf(String expr) {
        String result = expr;
        result = result.replaceAll("\\breturn +if *\\(", "returnif(");
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "returnif", true);
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String values = argumentsMap.get("default");
            StringBuilder ifSb = new StringBuilder();
            ifSb.append("if(");
            ifSb.append(values);
            ifSb.append(") {return ");
            int ifStartBracketIndex = result.substring(endIndex).indexOf("{") + endIndex;
            int ifCloseBracketIndex = R2jsSession.getNextExpressionLastIndex(result, ifStartBracketIndex + 1, "}") + 1;
            String returnStatement = result.substring(ifStartBracketIndex + 1, ifCloseBracketIndex + 1).trim();
            if (returnStatement.startsWith("{")) {
                returnStatement = returnStatement.substring(1);
            }
            if (returnStatement.endsWith("}")) {
                returnStatement = returnStatement.substring(0, returnStatement.length() - 1);
            }
            ifSb.append(returnStatement);
            ifSb.append("}");
            if (result.substring(ifCloseBracketIndex + 1).trim().startsWith("else")) {
                int elseStartBracketIndex = result.substring(ifCloseBracketIndex + 1).indexOf("{") + ifCloseBracketIndex + 1;
                int elseCloseBracketIndex = R2jsSession.getNextExpressionLastIndex(result, elseStartBracketIndex + 1, "}") + 1;
                ifSb.append(" else {return ");
                ifSb.append(result.substring(elseStartBracketIndex + 1, elseCloseBracketIndex + 1));
                endIndex = elseCloseBracketIndex;
            } else {
                endIndex = ifCloseBracketIndex;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)ifSb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            result = result.replaceAll("\\breturn +if *\\(", "returnif(");
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "returnif");
        }
        return result;
    }

    private static String createFileExistsFunction(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "file__exists");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String values = argumentsMap.get("default");
            StringBuilder fileExistSb = new StringBuilder();
            fileExistSb.append("__R.fileExists(");
            fileExistSb.append(values);
            fileExistSb.append(")");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)fileExistSb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "file__exists");
        }
        return result;
    }

    private String createExistsFunction(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "exists");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String variable = argumentsMap.get("default");
            StringBuilder fileExistSb = new StringBuilder();
            fileExistSb.append(THIS_ENVIRONMENT);
            fileExistSb.append(".hasOwnProperty(");
            fileExistSb.append(variable);
            fileExistSb.append(")");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)fileExistSb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "exists");
        }
        return result;
    }

    private static String createStopIfNotFunction(String expr) {
        String result = expr;
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "stopifnot");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            String values = argumentsMap.get("default");
            StringBuilder fileExistSb = new StringBuilder();
            fileExistSb.append("__R.stopIfNot(");
            fileExistSb.append(values);
            fileExistSb.append(",'");
            fileExistSb.append(values);
            fileExistSb.append("')");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)fileExistSb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "stopifnot");
        }
        return result;
    }

    private static String createPredefinedFunction(String expr) {
        String result = expr;
        String functionReplacementString = "__FUNCTION_REPLACEMENT";
        RFunctionArgumentsDTO rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(expr, "function");
        while (rFunctionArgumentsDTO != null) {
            int startIndex = rFunctionArgumentsDTO.getStartIndex();
            int endIndex = rFunctionArgumentsDTO.getStopIndex();
            Map<String, String> argumentsMap = rFunctionArgumentsDTO.getGroups();
            StringBuilder functionSb = new StringBuilder();
            functionSb.append(functionReplacementString);
            functionSb.append("(");
            for (Map.Entry<String, String> entry : argumentsMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                functionSb.append("(");
                functionSb.append(key);
                functionSb.append(" = typeof ");
                functionSb.append(key);
                functionSb.append(" !== 'undefined') ? ");
                functionSb.append(key);
                functionSb.append(" : ");
                functionSb.append(value);
                functionSb.append(",");
            }
            functionSb = functionSb.deleteCharAt(functionSb.length() - 1);
            functionSb.append(");");
            StringBuilder sb = new StringBuilder();
            sb.append(result.substring(0, startIndex));
            sb.append((CharSequence)functionSb);
            sb.append(result.substring(endIndex + 1));
            result = sb.toString();
            rFunctionArgumentsDTO = R2jsSession.getFunctionArguments(result, "function");
        }
        result = result.replaceAll(functionReplacementString, "function");
        return result;
    }

    private static RFunctionArgumentsDTO getFunctionArguments(String expr, String fctName) {
        return R2jsSession.getFunctionArguments(expr, fctName, false);
    }

    private static RFunctionArgumentsDTO getFunctionArguments(String expr, String fctName, boolean ignoreOperators) {
        LinkedHashMap<String, List<String>> argumentNamesByFunctions = new LinkedHashMap<String, List<String>>();
        argumentNamesByFunctions.put("array", Arrays.asList("data", "dim", "dimnames"));
        argumentNamesByFunctions.put("paste0", new ArrayList());
        argumentNamesByFunctions.put("paste", new ArrayList());
        argumentNamesByFunctions.put("unlist", new ArrayList());
        argumentNamesByFunctions.put("strsplit", new ArrayList());
        argumentNamesByFunctions.put("all", new ArrayList());
        argumentNamesByFunctions.put("any", new ArrayList());
        argumentNamesByFunctions.put("vector", Arrays.asList("mode", "length"));
        argumentNamesByFunctions.put("matrix", Arrays.asList("data", "nrow", "ncol", "byrow", "dimnames"));
        argumentNamesByFunctions.put("c", Arrays.asList("data", "dim", "dimnames"));
        argumentNamesByFunctions.put("ls", Arrays.asList("name", "pos", "envir", "all.names", "pattern", "sorted"));
        argumentNamesByFunctions.put("save", Arrays.asList("list", "file", "ascii", "all.names", "pattern", "sorted"));
        argumentNamesByFunctions.put("load", Arrays.asList("file", "envir", "verbose"));
        argumentNamesByFunctions.put("write__csv", Arrays.asList("data", "file", "row.names", "col.names", "sep", "na"));
        argumentNamesByFunctions.put("data__frame", new ArrayList());
        argumentNamesByFunctions.put("list", new ArrayList());
        argumentNamesByFunctions.put("Sys__setenv", new ArrayList());
        argumentNamesByFunctions.put("length", Arrays.asList("default"));
        argumentNamesByFunctions.put("file__exists", Arrays.asList("default"));
        argumentNamesByFunctions.put("exists", Arrays.asList("default", "where", "envir", "mode", "frame", "inherits"));
        argumentNamesByFunctions.put("stopifnot", Arrays.asList("default"));
        argumentNamesByFunctions.put("function", Arrays.asList("default"));
        argumentNamesByFunctions.put("if", Arrays.asList("default"));
        argumentNamesByFunctions.put("returnif", Arrays.asList("default"));
        RFunctionArgumentsDTO rFunctionArgumentsDTO = null;
        ArrayList argumentNamesList = new ArrayList((Collection)argumentNamesByFunctions.get(fctName));
        LinkedHashMap<String, String> argumentNamesAndValues = new LinkedHashMap<String, String>();
        Pattern pattern = Pattern.compile("(?<!\\.)(\\b)" + fctName + "\\s*\\(");
        Matcher matcher = pattern.matcher(expr);
        if (matcher.find()) {
            int startIndex = matcher.start();
            int currentIndex = expr.indexOf("(", startIndex) + 1;
            while (expr.charAt(currentIndex - 1) != ')') {
                int argumentEndIndex;
                String operators = ",=";
                if (ignoreOperators) {
                    operators = ",";
                }
                if (expr.charAt((argumentEndIndex = R2jsSession.getNextExpressionLastIndex(expr, currentIndex - 1, operators)) + 1) == '=' && ("!=<>".contains("" + expr.charAt(argumentEndIndex)) || expr.charAt(argumentEndIndex + 2) == '=')) {
                    argumentEndIndex = R2jsSession.getNextExpressionLastIndex(expr, argumentEndIndex + 1, operators);
                }
                String argumentName = null;
                String argument = null;
                if (expr.charAt(argumentEndIndex + 1) == '=') {
                    argumentName = expr.substring(currentIndex, argumentEndIndex + 1).trim();
                    currentIndex = argumentEndIndex + 2;
                    argumentEndIndex = R2jsSession.getNextExpressionLastIndex(expr, currentIndex - 1, operators);
                }
                if (argumentName == null) {
                    if (argumentNamesList.size() > 0 && !(argumentName = (String)argumentNamesList.get(0)).equals("default")) {
                        argumentNamesList.remove(0);
                    }
                } else {
                    boolean bl = argumentNamesList.remove(argumentName);
                }
                argument = expr.substring(currentIndex, argumentEndIndex + 1);
                if (argumentName == null) {
                    argumentName = argument;
                }
                if (argumentNamesAndValues.containsKey(argumentName)) {
                    argumentNamesAndValues.put(argumentName, (String)argumentNamesAndValues.get(argumentName) + "," + argument);
                } else {
                    argumentNamesAndValues.put(argumentName, argument);
                }
                currentIndex = argumentEndIndex + 2;
            }
            rFunctionArgumentsDTO = new RFunctionArgumentsDTO(startIndex, currentIndex - 1, argumentNamesAndValues);
        }
        return rFunctionArgumentsDTO;
    }

    private static String removePlusOperator(String expr) {
        expr = expr.replaceAll("(return|if|else|\\(|\\{|\\|[\\|]|\\}|=|,|<|>) *\\+", "$1");
        expr = expr.replaceAll("\\+\\s*\\+", "+");
        expr = expr.replaceAll("\\-\\s*\\+", "-");
        expr = expr.replaceAll("\\*\\s*\\+", "*");
        expr = expr.replaceAll("\\/\\s*\\+", "/");
        expr = expr.replaceAll("\\:\\s*\\+", ":");
        expr = expr.replaceAll("\\;\\s*\\+", ";");
        expr = expr.replaceAll("\\^\\s*\\+", "^");
        expr = expr.replaceAll("^\\s*\\+", "");
        return expr;
    }

    private static String replaceOperators(String expr) {
        expr = R2jsSession.removePlusOperator(expr);
        expr = expr.replaceAll("([\\[\\{\\(\\-\\\\=*\\/^;%+:,><&|\u00f4\u00e2\u00ea\u015d\u011d\\n]) *-", "$1 \u00ee");
        String stoppingCharacters = "-=*/^;%+:,><&|\u00f4\u00e2\u00ea\u015d\u011d\n";
        expr = expr.replaceAll("[)]/", ") /");
        expr = expr.replaceAll("(.)-", "$1 -");
        HashMap<String, String> operatorsMap = new HashMap<String, String>();
        operatorsMap.put(">", "__R._gt");
        operatorsMap.put("<", "__R._lt");
        operatorsMap.put("\u011d", "__R._get");
        operatorsMap.put("\u015d", "__R._let");
        operatorsMap.put("\u00ea", "__R._eq");
        operatorsMap.put("|", "__R._or");
        operatorsMap.put("\u00f4", "__R._oror");
        operatorsMap.put("&", "__R._and");
        operatorsMap.put("\u00e2", "__R._andand");
        operatorsMap.put("+", "math.add");
        operatorsMap.put("-", "math.subtract");
        operatorsMap.put("*", "math.dotMultiply");
        operatorsMap.put("/", "math.dotDivide");
        operatorsMap.put("%*%", "math.multiply");
        operatorsMap.put("%/%", "math.floor(math.dotDivide");
        operatorsMap.put("%%", "math.mod");
        operatorsMap.put(":", "__R.range");
        operatorsMap.put("^", "math.dotPow");
        String[] operators = new String[]{"^", "/%:\u00ea", "*", "+-&|\u00f4\u00e2\u015d\u011d><"};
        int priority = 0;
        boolean continueReplacing = true;
        int i = 0;
        while (continueReplacing) {
            char currentChar = expr.charAt(i);
            if (currentChar == '\'') {
                currentChar = expr.charAt(++i);
                while (i < expr.length() && currentChar != '\'') {
                    currentChar = expr.charAt(i);
                    ++i;
                }
            }
            if (operators[priority].indexOf(currentChar) >= 0) {
                if (currentChar == '%') {
                    int startingIndex;
                    String prevExp;
                    int nbChar = 3;
                    if (expr.charAt(i + 1) == '%') {
                        nbChar = 2;
                    }
                    if ((prevExp = expr.substring(startingIndex = R2jsSession.getPreviousExpressionFirstIndex(expr, i, stoppingCharacters), i)).trim().length() > 0) {
                        int endingIndex = R2jsSession.getNextExpressionLastIndex(expr, i + nbChar - 1, stoppingCharacters);
                        String operatorName = (String)operatorsMap.get(expr.substring(i, i + nbChar));
                        StringBuilder resultExpr = new StringBuilder();
                        resultExpr.append(operatorName);
                        resultExpr.append("(");
                        resultExpr.append(prevExp);
                        resultExpr.append(",");
                        resultExpr.append(expr.substring(i + nbChar, endingIndex + 1));
                        resultExpr.append(") ");
                        if (expr.charAt(i + 1) == '/') {
                            resultExpr.append(")");
                        }
                        expr = expr.substring(0, startingIndex) + resultExpr + expr.substring(endingIndex + 1, expr.length());
                        i = startingIndex - 1;
                    }
                } else if ("-+*/=".indexOf(expr.charAt(i + 1)) < 0) {
                    int startingIndex = R2jsSession.getPreviousExpressionFirstIndex(expr, i, stoppingCharacters);
                    String prevExp = expr.substring(startingIndex, i);
                    if (prevExp.trim().startsWith("return")) {
                        startingIndex = startingIndex + prevExp.indexOf("return") + "return".length();
                        prevExp = prevExp.replaceFirst("return", "");
                    }
                    if (prevExp.trim().length() > 0) {
                        int endingIndex = R2jsSession.getNextExpressionLastIndex(expr, i, stoppingCharacters);
                        String operatorName = (String)operatorsMap.get(currentChar + "");
                        StringBuilder resultExpr = new StringBuilder();
                        resultExpr.append(" + ");
                        resultExpr.append(operatorName);
                        resultExpr.append("(");
                        resultExpr.append(prevExp);
                        resultExpr.append(",");
                        resultExpr.append(expr.substring(i + 1, endingIndex + 1));
                        resultExpr.append(") ");
                        expr = expr.substring(0, startingIndex) + resultExpr + expr.substring(endingIndex + 1, expr.length());
                        expr = R2jsSession.removePlusOperator(expr);
                        i = startingIndex - 1;
                    }
                } else {
                    ++i;
                }
            }
            if (++i < expr.length()) continue;
            if (priority < operators.length - 1) {
                ++priority;
                i = 0;
                continue;
            }
            continueReplacing = false;
        }
        return expr.replace('\u00ee', '-');
    }

    private void addGlobalVariables(String[] variables) {
        if (this.variablesSet == null) {
            this.variablesSet = new HashSet<String>();
        }
        for (String variable : variables) {
            this.variablesSet.add(variable);
        }
    }

    private void storeGlobalVariables(String expr) {
        if (this.variablesSet == null) {
            this.variablesSet = new HashSet<String>();
        }
        int equalIndex = R2jsSession.getNextExpressionLastIndex(expr, -1, "=") + 1;
        int exprLength = expr.length();
        while (equalIndex < exprLength) {
            if (equalIndex > 0 && expr.charAt(equalIndex) != '=') {
                ++equalIndex;
            } else if (equalIndex > 0 && expr.charAt(equalIndex - 1) == '=' || equalIndex < exprLength - 1 && expr.charAt(equalIndex + 1) == '=') {
                ++equalIndex;
            } else {
                int startIndex = R2jsSession.getPreviousExpressionFirstIndex(expr, equalIndex, "=*/^;%+,. ");
                String variableName = expr.substring(startIndex, equalIndex).trim();
                if (variableName.matches("\\w+")) {
                    this.variablesSet.add(variableName);
                }
            }
            equalIndex = R2jsSession.getNextExpressionLastIndex(expr, equalIndex, "=") + 1;
        }
    }

    private static int getPreviousExpressionFirstIndex(String expr, int startIndex, String stoppingCharacters) {
        int firstIndex = 0;
        int parenthesis = 0;
        int brackets = 0;
        int brackets2 = 0;
        for (int startingIndex = startIndex - 1; startingIndex > 0 && expr.charAt(startingIndex) == ' '; --startingIndex) {
        }
        for (int i = startingIndex; i >= 0; --i) {
            char currentChar = expr.charAt(i);
            if (currentChar == ')') {
                ++parenthesis;
                continue;
            }
            if (currentChar == '(') {
                if (--parenthesis >= 0) continue;
                return i + 1;
            }
            if (currentChar == '}') {
                ++brackets;
                continue;
            }
            if (currentChar == '{') {
                if (--brackets >= 0) continue;
                return i + 1;
            }
            if (currentChar == ']') {
                ++brackets2;
                continue;
            }
            if (!(currentChar == '[' ? --brackets2 < 0 : parenthesis == 0 && brackets == 0 && brackets2 == 0 && stoppingCharacters.indexOf(currentChar) >= 0)) continue;
            return i + 1;
        }
        return firstIndex;
    }

    private static int getNextExpressionLastIndex(String expr, int startIndex, String stoppingCharacters) {
        int lastIndex = expr.length() - 1;
        int parenthesis = 0;
        int brackets = 0;
        int brackets2 = 0;
        for (int startingIndex = startIndex + 1; startingIndex < expr.length() && expr.charAt(startingIndex) == ' '; ++startingIndex) {
        }
        for (int i = startingIndex; i < expr.length(); ++i) {
            char currentChar = expr.charAt(i);
            if (currentChar == '(') {
                ++parenthesis;
                continue;
            }
            if (currentChar == ')') {
                if (--parenthesis >= 0) continue;
                return i - 1;
            }
            if (currentChar == '{') {
                ++brackets;
                continue;
            }
            if (currentChar == '}') {
                if (--brackets >= 0) continue;
                return i - 1;
            }
            if (currentChar == '[') {
                ++brackets2;
                continue;
            }
            if (!(currentChar == ']' ? --brackets2 < 0 : parenthesis == 0 && brackets == 0 && brackets2 == 0 && stoppingCharacters.indexOf(currentChar) >= 0)) continue;
            return i - 1;
        }
        return lastIndex;
    }

    private static String replaceFunctionDefaultArguments(String arguments) {
        LinkedHashMap<String, String> parametersAndValuesMap = new LinkedHashMap<String, String>();
        Matcher matcher = Pattern.compile("([\\w\\-]+) *=* *(([\\w\\-]+))?").matcher(arguments);
        while (matcher.find()) {
            parametersAndValuesMap.put(matcher.group(1), matcher.group(2));
        }
        StringBuilder resultParameters = new StringBuilder();
        StringBuilder resultValues = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : parametersAndValuesMap.entrySet()) {
            String param = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!first) {
                resultParameters.append(",");
            } else {
                first = false;
            }
            resultParameters.append(param);
            resultValues.append(param);
            resultValues.append(" = typeof ");
            resultValues.append(param);
            resultValues.append(" !== 'undefined' ? ");
            resultValues.append(param);
            resultValues.append(" : ");
            resultValues.append(value);
            resultValues.append("; ");
        }
        String result = "(" + resultParameters + ") {" + resultValues;
        return result;
    }

    @Override
    public synchronized void end() {
        this.js = null;
        super.end();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String gethomedir() {
        return System.getProperty("user.home");
    }

    @Override
    boolean isWindows() {
        return RserveDaemon.isWindows();
    }

    @Override
    boolean isMacOSX() {
        return RserveDaemon.isMacOSX();
    }

    @Override
    boolean isLinux() {
        return RserveDaemon.isLinux();
    }

    @Override
    protected synchronized boolean silentlyVoidEval(String expression, boolean tryEval) {
        String jsExpr = "?";
        try {
            jsExpr = this.convertRtoJs(expression);
            this.js.eval(jsExpr);
        }
        catch (Exception e) {
            String ls = "?";
            try {
                ls = this.js.eval("JSON.stringify(__this__)").toString();
            }
            catch (Exception ee) {
                ls = ee.getMessage();
            }
            String msg = null;
            msg = expression.contains("\n") ? "Failed to evaluate code\n  ```{r}\n" + expression.replaceAll("^", "^  ") + "\n  ```\n as\n  ```{js}\n" + jsExpr.replaceAll("^", "^  ") + "\n  ```\n with variables: " + ls + "\n because: " + e.getMessage() : "Failed to evaluate code\n  `{r} " + expression + " ` as `{js} " + jsExpr + " `\n with variables: " + ls + "\n because: " + e.getMessage();
            this.log(msg, RLog.Level.ERROR);
            return false;
        }
        return true;
    }

    @Override
    protected synchronized Object silentlyRawEval(String expression, boolean tryEval) {
        Object result = null;
        String jsExpr = "?";
        try {
            jsExpr = this.convertRtoJs(expression);
            result = this.js.eval(jsExpr);
        }
        catch (Exception e) {
            String ls = "?";
            try {
                ls = this.js.eval("JSON.stringify(__this__)").toString();
            }
            catch (Exception ee) {
                ls = ee.getMessage();
            }
            String msg = null;
            msg = expression.contains("\n") ? "Failed to evaluate code\n  ```{r}\n" + expression.replaceAll("^", "^  ") + "\n  ```\n as\n  ```{js}\n" + jsExpr.replaceAll("^", "^  ") + "\n  ```\n with variables: " + ls + "\n because: " + e.getMessage() : "Failed to evaluate code\n  `{r} " + expression + " ` as `{js} " + jsExpr + " `\n with variables: " + ls + "\n because: " + e.getMessage();
            this.log(msg, RLog.Level.ERROR);
            return new Rsession.RException(msg);
        }
        return result;
    }

    @Override
    public synchronized boolean set(String varname, double[][] data, String ... names) throws Rsession.RException {
        this.note_code("`" + varname + "` <- " + (data == null ? "list()" : R2jsSession.toRcode(data)));
        this.note_code("names(" + varname + ") <- " + R2jsSession.toRcode(names));
        this.note_code("`" + varname + "` <- data.frame(" + varname + ")");
        varname = R2jsSession.nameRtoJs(varname);
        String allnames = "";
        for (int i = 0; i < names.length; ++i) {
            allnames = allnames + ",'" + names[i] + "'";
        }
        allnames = allnames.substring(1);
        try {
            String dim = "[" + data.length + "," + data[0].length + "]";
            String stringMatrix = Arrays.deepToString((Object[])data);
            this.js.eval(varname + " = math.reshape(" + stringMatrix + ", " + dim + ")");
            this.js.eval("__this__." + varname + " = " + varname);
            this.js.eval("__this__." + varname + ".names = [" + allnames + "]");
            this.variablesSet.add(varname);
        }
        catch (Exception e) {
            this.log("[error]  " + e.getMessage(), RLog.Level.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean set(String varname, Object var) {
        block11: {
            this.note_code("`" + varname + "` <- " + R2jsSession.toRcode(var));
            varname = R2jsSession.nameRtoJs(varname);
            try {
                if (var instanceof double[][]) {
                    double[][] var2DArray = (double[][])var;
                    String dim = "[" + var2DArray.length + "," + var2DArray[0].length + "]";
                    String stringMatrix = Arrays.deepToString((Object[])var2DArray);
                    this.js.eval(varname + " = math.reshape(" + stringMatrix + ", " + dim + ")");
                    this.js.eval("__this__." + varname + " = " + varname);
                    String allnames = "";
                    for (int i = 0; i < var2DArray[0].length; ++i) {
                        allnames = allnames + ",'X" + (i + 1) + "'";
                    }
                    allnames = allnames.substring(1);
                    this.js.eval("__this__." + varname + ".names = [" + allnames + "]");
                    this.variablesSet.add(varname);
                    break block11;
                }
                if (var instanceof double[]) {
                    double[] var1DArray = (double[])var;
                    String dim = "[" + var1DArray.length + ",1]";
                    String stringMatrix = Arrays.toString(var1DArray);
                    this.js.eval(varname + " = " + Arrays.toString(var1DArray));
                    this.js.eval("__this__." + varname + " = " + varname);
                    this.variablesSet.add(varname);
                    break block11;
                }
                if (var instanceof Map) {
                    Map m = (Map)var;
                    try {
                        this.js.eval("__this__." + varname + " = {}");
                    }
                    catch (ScriptException ex) {
                        this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
                        return false;
                    }
                    for (Object k : m.keySet()) {
                        String h = this.hash(k);
                        this.set(varname + "_" + h, m.get(k));
                        try {
                            this.js.eval("__this__." + varname + "['" + k + "'] = " + varname + "_" + h);
                        }
                        catch (ScriptException ex) {
                            this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
                            return false;
                        }
                        this.rm(varname + "_" + h);
                    }
                    this.variablesSet.add(varname);
                    break block11;
                }
                this.js.put(varname, var);
                this.js.eval("__this__." + varname + " = " + varname);
                this.variablesSet.add(varname);
            }
            catch (Exception e) {
                this.log("[error]  " + e.getMessage(), RLog.Level.ERROR);
                return false;
            }
        }
        return true;
    }

    @Override
    public File putFileInWorkspace(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        File rf = this.local2remotePath(file);
        if (!rf.getAbsolutePath().equals(file.getAbsolutePath())) {
            try {
                FileUtils.copyFile((File)file, (File)rf);
            }
            catch (IOException ex) {
                this.log("[IO] " + ex.getMessage(), RLog.Level.ERROR);
            }
        }
        return rf;
    }

    @Override
    public void getFileFromWorkspace(File file) {
        if (file.isAbsolute()) {
            return;
        }
        File rf = this.remote2localPath(file);
        if (file.getParentFile() != null && !file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Cannot create parent dir: " + file);
        }
        if (!rf.getAbsolutePath().equals(file.getAbsolutePath())) {
            try {
                FileUtils.copyFile((File)rf, (File)new File(".", file.getPath()));
            }
            catch (IOException ex) {
                this.log("[IO] " + ex.getMessage(), RLog.Level.ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void source(File file) {
        if (!(file = this.putFileInWorkspace(file)).isFile()) {
            throw new IllegalArgumentException("File " + file + " is not reachable.");
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        InputStreamReader isr = null;
        FileInputStream fis = null;
        try {
            String line;
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
                isr.close();
                reader.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        for (String expr : R2jsUtils.parse(sb.toString())) {
            this.silentlyVoidEval(expr, false);
        }
    }

    @Override
    public synchronized boolean rm(String ... vars) throws Rsession.RException {
        try {
            for (String var : vars) {
                this.js.eval("delete __this__." + var + ";");
                this.variablesSet.remove(var);
                this.js.eval("delete " + var + ";");
            }
        }
        catch (Exception e) {
            this.log("[error]  " + e.getMessage(), RLog.Level.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean rmAll() {
        try {
            this.js.eval("delete " + this.envName + ";");
            this.variablesSet.clear();
            this.js.eval("var " + this.envName + " = math.clone({});");
            this.js.eval("__this__ = " + this.envName);
        }
        catch (Exception e) {
            this.log("[error]  " + e.getMessage(), RLog.Level.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public String loadPackage(String pack) {
        throw new UnsupportedOperationException("Cannot load any package in R2Js. Use 'source' for external static content loading.");
    }

    @Override
    public double asDouble(Object o) throws ClassCastException {
        if (o instanceof Double) {
            return (Double)o;
        }
        return (Double)ScriptUtils.convert((Object)o, Double.TYPE);
    }

    @Override
    public double[] asArray(Object o) throws ClassCastException {
        if (o instanceof double[]) {
            return (double[])o;
        }
        if (o instanceof Double) {
            return new double[]{(Double)o};
        }
        Object co = ScriptUtils.convert((Object)o, double[].class);
        if (co instanceof Double) {
            return new double[]{(Double)co};
        }
        return (double[])co;
    }

    @Override
    public double[][] asMatrix(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof double[][]) {
            return (double[][])o;
        }
        if (o instanceof double[]) {
            return this.t(new double[][]{(double[])o});
        }
        if (o instanceof Double) {
            return new double[][]{{(Double)o}};
        }
        double[][] vals = null;
        int i = 0;
        try {
            for (Object k : ((Map)o).keySet()) {
                double[] v = null;
                if (o instanceof ScriptObjectMirror) {
                    try {
                        v = (double[])((ScriptObjectMirror)o).to(double[].class);
                    }
                    catch (Exception ex) {
                        throw new ClassCastException("[asMatrix] Cannot cast ScriptObjectMirror list element to double[] " + ((Map)o).get(k) + " for key " + k + " in " + o);
                    }
                }
                try {
                    v = (double[])((Map)o).get(k);
                }
                catch (Exception ex) {
                    throw new ClassCastException("[asMatrix] Cannot cast list element to double[] " + ((Map)o).get(k) + " for key " + k + " in " + o);
                }
                if (v == null) {
                    throw new ClassCastException("[asMatrix] Cannot get list element as double[] " + ((Map)o).get(k) + " for key " + k + " in " + o);
                }
                if (vals == null) {
                    vals = new double[v.length][((Map)o).size()];
                }
                for (int j = 0; j < v.length; ++j) {
                    vals[j][i] = v[j];
                }
                ++i;
            }
            return vals;
        }
        catch (Exception ex) {
            throw new ClassCastException("[asMatrix] Cannot cast Map to matrix: " + ex.getMessage());
        }
    }

    @Override
    public String asString(Object o) throws ClassCastException {
        if (o instanceof String) {
            return (String)o;
        }
        return (String)ScriptUtils.convert((Object)o, String.class);
    }

    @Override
    public String[] asStrings(Object o) throws ClassCastException {
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        Object co = ScriptUtils.convert((Object)o, String[].class);
        if (co instanceof String) {
            return new String[]{(String)co};
        }
        return (String[])co;
    }

    @Override
    public int asInteger(Object o) throws ClassCastException {
        return (int)this.asDouble(o);
    }

    @Override
    public int[] asIntegers(Object o) throws ClassCastException {
        double[] d = this.asArray(o);
        int[] I = new int[d.length];
        for (int i = 0; i < I.length; ++i) {
            I[i] = (int)d[i];
        }
        return I;
    }

    @Override
    public boolean asLogical(Object o) throws ClassCastException {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Rsession.RException) {
            throw new IllegalArgumentException("[asLogical] Exception: " + ((Rsession.RException)o).getMessage());
        }
        return (Boolean)ScriptUtils.convert((Object)o, Boolean.TYPE);
    }

    @Override
    public boolean[] asLogicals(Object o) throws ClassCastException {
        if (o instanceof boolean[]) {
            return (boolean[])o;
        }
        if (o instanceof Boolean) {
            return new boolean[]{(Boolean)o};
        }
        Object co = ScriptUtils.convert((Object)o, boolean[].class);
        if (co instanceof Boolean) {
            return new boolean[]{(Boolean)co};
        }
        return (boolean[])co;
    }

    @Override
    public Map asList(Object o) throws ClassCastException {
        if (o instanceof Map) {
            return (Map)o;
        }
        return (Map)ScriptUtils.convert((Object)o, Map.class);
    }

    @Override
    public boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        return Arrays.asList(this.ls()).contains(o.toString());
    }

    @Override
    public String toString(Object o) {
        return o.toString();
    }

    @Override
    public Object cast(Object o) throws ClassCastException {
        if (o instanceof Integer) {
            return (double)((Integer)o).intValue();
        }
        if (o instanceof ScriptObjectMirror) {
            try {
                return ((ScriptObjectMirror)o).to(double[][].class);
            }
            catch (Exception exception) {
                try {
                    String[] stringArray2 = (String[])((ScriptObjectMirror)o).to(String[].class);
                    try {
                        for (String string : stringArray2) {
                            Double.valueOf(string);
                        }
                    }
                    catch (Exception e) {
                        return stringArray2;
                    }
                    return ((ScriptObjectMirror)o).to(double[].class);
                }
                catch (Exception stringArray2) {
                    try {
                        return ((ScriptObjectMirror)o).to(double[].class);
                    }
                    catch (Exception stringArray2) {
                        try {
                            Map m = (Map)((ScriptObjectMirror)o).to(Map.class);
                            try {
                                return this.asMatrix(m);
                            }
                            catch (ClassCastException c) {
                                return m;
                            }
                        }
                        catch (Exception exception2) {
                            throw new IllegalArgumentException("Impossible to cast object: ScriptObjectMirror");
                        }
                    }
                }
            }
        }
        return o;
    }

    @Override
    public void setGlobalEnv(String envName) {
        envName = envName == null ? ENVIRONMENT_DEFAULT : POINT_CHAR_JS_KEY + envName + POINT_CHAR_JS_KEY;
        try {
            if (this.asLogical(this.js.eval("typeof " + envName + " == 'undefined'"))) {
                this.js.eval("var " + envName + " = math.clone({});");
            }
            this.js.eval("__this__ = " + envName);
        }
        catch (ScriptException ex) {
            Log.Err.println(ex.getMessage());
        }
        String oldEnv = this.envName;
        this.envVariables.put(oldEnv, new TreeSet<String>(this.variablesSet));
        this.variablesSet.clear();
        if (this.envVariables.containsKey(envName)) {
            this.variablesSet.addAll((Collection<String>)this.envVariables.get(envName));
        }
        this.envName = envName;
    }

    @Override
    public void copyGlobalEnv(String envName) {
        String[] ls;
        envName = envName == null ? ENVIRONMENT_DEFAULT : POINT_CHAR_JS_KEY + envName + POINT_CHAR_JS_KEY;
        try {
            if (this.asLogical(this.js.eval("typeof " + envName + " == 'undefined'"))) {
                this.js.eval("var " + envName + " = math.clone({});");
            }
        }
        catch (ScriptException ex) {
            Log.Err.println(ex.getMessage());
        }
        for (String o : ls = this.ls(true)) {
            try {
                this.js.eval(envName + "." + o + " = " + this.envName + "." + o);
            }
            catch (ScriptException ex) {
                Log.Err.println(ex.getMessage());
            }
        }
        if (!this.envVariables.containsKey(envName)) {
            this.envVariables.put(envName, new TreeSet<String>(this.variablesSet));
        } else {
            this.envVariables.get(envName).addAll(new TreeSet<String>(this.variablesSet));
        }
    }

    public static String HTMLfun(String Rcode, String fun, String ... args) throws Rsession.RException {
        R2jsSession R = new R2jsSession(System.out, null);
        String html = html_tmpl.replace("___JS___", R.convertRtoJs(Rcode).replace(THIS_ENVIRONMENT + ".", ""));
        html = html.replace("___R___", Rcode);
        html = html.replace("___f___", fun);
        String inputs = "";
        for (int i = 0; i < args.length; ++i) {
            inputs = inputs + args[i] + ":" + input_tmpl.replace("___ID___", args[i]) + "<br/>";
            args[i] = "document.getElementById('" + args[i] + "').value";
        }
        html = html.replace("___INPUT___", inputs);
        html = html.replace("___SUBMIT___", submit_tmpl.replace("___ONCLICK___", "document.write(" + fun + "(" + R2jsSession.cat(",", args) + "))"));
        return html;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            args = new String[10];
            for (int i = 0; i < args.length; ++i) {
                args[i] = Math.random() + "+pi";
            }
        }
        R2jsSession R = new R2jsSession(System.out, null);
        for (int j = 0; j < args.length; ++j) {
            System.out.print(args[j] + ": ");
            System.out.println(R.cast(R.rawEval(args[j])));
        }
        R.closeLog();
        System.out.println(R.notebook());
    }

    static {
        R_TO_JS.put("R.version.string", "'R2js'");
        R_TO_JS.put(".GlobalEnv", ENVIRONMENT_DEFAULT);
        R_TO_JS.put("stop(", "throw new Error(");
        R_TO_JS.put("as.numeric(", "asNumeric(");
        R_TO_JS.put("as.integer(", "asInteger(");
        R_TO_JS.put("as.logical(", "asLogical(");
        R_TO_JS.put("as.character(", "asCharacter(");
        R_TO_JS.put("as.matrix(", "matrix(");
        R_TO_JS.put("rep_len(", "reLen(");
        R_TO_JS.put("as.array(", "array(");
        R_TO_JS.put("which.min(", "whichMin(");
        R_TO_JS.put("which.max(", "whichMax(");
        R_TO_JS.put("print(", "_print(");
        R_TO_JS.put("is.function(", "isFunction(");
        R_TO_JS.put("is.null(", "isNull(");
        R_TO_JS.put("is.nan(", "isNaN(");
        R_TO_JS.put("is.na(", "isNA(");
        R_TO_JS.put("isTRUE(", "isTRUE(");
        R_TO_JS.put("isFALSE(", "isFALSE(");
        R_TO_JS.put("Sys.sleep(", "SysSleep(");
        R_TO_JS.put("Sys.getenv(", "SysGetEnv(");
        R_TO_JS.put("capture.output(", "_print(");
        R_TO_JS.put("NA", "null");
        R_TO_JS.put("new.env()", "{}");
        R_TO_JS.put("dev.off()", "");
        R_TO_JS.put("return()", "return(NULL)");
        R_TO_JS.put("...", "varargs");
        R_TO_JS.put("Inf", "Infinity");
        index_pattern = "([\\w|\\$|\\.]+(\\([\\w|\\$|\\=|\\,|\\-|\\(|\\)|\\.]*\\))*[\\w|\\$|\\.]*)\\[+(.[^\\]']*)\\]+";
        Env = new HashMap<String, String>();
        html_tmpl = "<html>\n    <head>\n        <script src=\"https://github.com/yannrichet/rsession/blob/master/src/main/resources/org/math/R/math.js\" type=\"text/javascript\"></script>\n        <script src=\"https://github.com/yannrichet/rsession/blob/master/src/main/resources/org/math/R/rand.js\" type=\"text/javascript\"></script>\n        <script src=\"https://github.com/yannrichet/rsession/blob/master/src/main/resources/org/math/R/R.js\" type=\"text/javascript\"></script>\n    </head>    <body>\n        <code>\n___R___        </code>\n        <script type = \"text/javascript\">\n        ___JS___\n        </script>\n\n        <form>\n        ___INPUT___\n        <br/>\n        ___SUBMIT___\n        </form>\n    </body>\n</html>";
        input_tmpl = "        <input type=\"text\" name=\"inputform\" id=\"___ID___\" value=\"\">\n";
        submit_tmpl = "        <input type=\"submit\" value=\"___F___\" onclick=\"___ONCLICK___\">\n";
    }
}

