/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.math.R.EvalListener;
import org.math.R.Log;
import org.math.R.RLog;
import org.math.R.RLogPrintStream;
import org.math.R.RserveDaemon;
import org.math.R.Rsession;
import org.math.array.DoubleArray;
import org.renjin.aether.AetherPackageLoader;
import org.renjin.eval.Session;
import org.renjin.eval.SessionBuilder;
import org.renjin.primitives.matrix.Matrix;
import org.renjin.primitives.packaging.PackageLoader;
import org.renjin.script.RenjinScriptEngine;
import org.renjin.script.RenjinScriptEngineFactory;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class RenjinSession
extends Rsession
implements RLog {
    protected RenjinScriptEngine R = null;
    File wdir;
    private static final String ENVIRONMENT_DEFAULT = "..renjin..";

    public static RenjinSession newInstance(RLog console, Properties properties) {
        return new RenjinSession(console, properties);
    }

    public RenjinSession(RLog console, Properties properties) {
        super(console);
        this.envName = ENVIRONMENT_DEFAULT;
        try {
            if (Class.forName("org.renjin.aether.AetherPackageLoader", false, this.getClass().getClassLoader()) == null) {
                throw new ClassNotFoundException("org.renjin.aether.AetherPackageLoader missing");
            }
            Session session = new SessionBuilder().bind(PackageLoader.class, (Object)new AetherPackageLoader()).withDefaultPackages().build();
            this.R = new RenjinScriptEngineFactory().getScriptEngine(session);
        }
        catch (ClassNotFoundException e) {
            Log.Err.println("Could not access some Renjin dependency: " + e);
            Log.Err.println("Using Renjin without packages repository");
            this.R = new RenjinScriptEngineFactory().getScriptEngine();
        }
        if (this.R == null) {
            throw new RuntimeException("Renjin Script Engine not found in the classpath.");
        }
        try {
            int rand = Math.round((float)Math.random() * 10000.0f);
            this.wdir = new File(new File(System.getProperty("RSESSION_HOME", FileUtils.getTempDirectoryPath()), ".Renjin"), "" + rand);
            if (!this.wdir.mkdirs()) {
                this.wdir = new File(new File(FileUtils.getUserDirectory(), ".Renjin"), "" + rand);
                if (!this.wdir.mkdirs()) {
                    throw new IOException("Could not create directory " + new File(new File(System.getProperty("RSESSION_HOME", FileUtils.getTempDirectoryPath()), ".Renjin"), "" + rand) + "\n or " + new File(new File(FileUtils.getUserDirectory(), ".Renjin"), "" + rand));
                }
            }
            this.setwd(this.wdir);
            this.wdir.deleteOnExit();
        }
        catch (Exception ex) {
            this.log("Could not use directory: " + this.wdir + "\n" + ex.getMessage(), RLog.Level.ERROR);
        }
        this.SINK_FILE = this.SINK_FILE_BASE + "-renjin" + this.hashCode();
        this.setenv(properties);
        this.repos = "org.renjin.cran";
    }

    public RenjinSession(PrintStream p, Properties properties) {
        this(new RLogPrintStream(p), properties);
    }

    @Override
    public String gethomedir() {
        return System.getProperty("user.home");
    }

    @Override
    boolean isWindows() {
        return RserveDaemon.isWindows();
    }

    @Override
    boolean isMacOSX() {
        return RserveDaemon.isMacOSX();
    }

    @Override
    boolean isLinux() {
        return RserveDaemon.isLinux();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean silentlyVoidEval(String expression, boolean tryEval) {
        if (this.R == null) {
            this.log("[exception] R environment not initialized.", RLog.Level.ERROR);
            return false;
        }
        if (expression == null) {
            return false;
        }
        if (expression.trim().length() == 0) {
            return true;
        }
        for (EvalListener b : this.eval) {
            b.eval(expression);
        }
        SEXP e = null;
        try {
            if (this.SINK_OUTPUT) {
                this.R.eval(".f <- file('" + this.toRpath(this.SINK_FILE) + "',open='wt')");
                this.R.eval("sink(.f,type='output')");
            }
            if (this.SINK_MESSAGE) {
                this.R.eval(".fm <- file('" + this.toRpath(this.SINK_FILE) + ".m',open='wt')");
                this.R.eval("sink(.fm,type='message')");
            }
            e = tryEval ? (SEXP)this.R.eval("try(eval(parse(text='" + expression.replace("'", "\\'") + "')),silent=FALSE)") : (SEXP)this.R.eval(expression);
        }
        catch (Exception ex) {
            this.log("[exception] " + ex.getMessage() + "\n  " + expression, RLog.Level.ERROR);
        }
        finally {
            if (this.SINK_OUTPUT) {
                try {
                    this.R.eval("sink(type='output')");
                    this.lastOuput = this.asString(this.R.eval("paste(collapse='\n',readLines('" + this.toRpath(this.SINK_FILE) + "'))"));
                    this.log(this.lastOuput, RLog.Level.OUTPUT);
                }
                catch (Exception ex) {
                    this.lastOuput = ex.getMessage();
                    this.log(this.lastOuput, RLog.Level.WARNING);
                }
                finally {
                    try {
                        this.R.eval("close(.f)");
                        this.R.eval("unlink('" + this.toRpath(this.SINK_FILE) + "')");
                    }
                    catch (Exception ex) {
                        this.log("[exception] " + ex.getMessage(), RLog.Level.ERROR);
                    }
                }
            }
            if (this.SINK_MESSAGE) {
                try {
                    this.R.eval("sink(type='message')");
                    this.lastMessage = this.asString(this.R.eval("paste(collapse='\n',readLines('" + this.toRpath(this.SINK_FILE) + ".m'))"));
                    this.log(this.lastMessage, RLog.Level.INFO);
                }
                catch (Exception ex) {
                    this.lastMessage = ex.getMessage();
                    this.log(this.lastMessage, RLog.Level.WARNING);
                }
                finally {
                    try {
                        this.R.eval("close(.fm)");
                        this.R.eval("unlink('" + this.toRpath(this.SINK_FILE) + ".m')");
                    }
                    catch (Exception ex) {
                        this.log("[exception] " + ex.getMessage(), RLog.Level.ERROR);
                    }
                }
            }
        }
        if (!tryEval) return true;
        if (e == null) return true;
        try {
            if (!e.inherits("try-error")) return true;
            this.log("[exception] " + e.asString() + "\n  " + expression, RLog.Level.WARNING);
            return false;
        }
        catch (Exception ex) {
            this.log("[error] " + ex.getMessage() + "\n  " + expression, RLog.Level.ERROR);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Object silentlyRawEval(String expression, boolean tryEval) {
        if (this.R == null) {
            this.log("[exception] R environment not initialized.", RLog.Level.ERROR);
            return new Rsession.RException("[exception] R environment not initialized.");
        }
        if (expression == null) {
            return null;
        }
        if (expression.trim().length() == 0) {
            return null;
        }
        for (EvalListener b : this.eval) {
            b.eval(expression);
        }
        Object e = null;
        try {
            if (this.SINK_OUTPUT) {
                this.R.eval(".f <- file('" + this.toRpath(this.SINK_FILE) + "',open='wt')");
                this.R.eval("sink(.f,type='output')");
            }
            if (this.SINK_MESSAGE) {
                this.R.eval(".fm <- file('" + this.toRpath(this.SINK_FILE) + ".m',open='wt')");
                this.R.eval("sink(.fm,type='message')");
            }
            e = tryEval ? (SEXP)this.R.eval("try(eval(parse(text='" + expression.replace("'", "\\'") + "')),silent=FALSE)") : (SEXP)this.R.eval(expression);
        }
        catch (Exception ex) {
            this.log("[exception] " + ex.getMessage() + "\n  " + expression, RLog.Level.ERROR);
            Rsession.RException rException = new Rsession.RException("[exception] " + ex.getMessage() + "\n  " + expression);
            return rException;
        }
        finally {
            if (this.SINK_OUTPUT) {
                try {
                    this.R.eval("sink(type='output')");
                    this.lastOuput = this.asString(this.R.eval("paste(collapse='\n',readLines('" + this.toRpath(this.SINK_FILE) + "'))"));
                    this.log(this.lastOuput, RLog.Level.OUTPUT);
                }
                catch (Exception ex) {
                    this.lastOuput = ex.getMessage();
                    this.log(this.lastOuput, RLog.Level.WARNING);
                }
                finally {
                    try {
                        this.R.eval("close(.f)");
                        this.R.eval("unlink('" + this.toRpath(this.SINK_FILE) + "')");
                    }
                    catch (Exception ex) {
                        this.log("[exception] " + ex.getMessage(), RLog.Level.ERROR);
                    }
                }
            }
            if (this.SINK_MESSAGE) {
                try {
                    this.R.eval("sink(type='message')");
                    this.lastMessage = this.asString(this.R.eval("paste(collapse='\n',readLines('" + this.toRpath(this.SINK_FILE) + ".m'))"));
                    this.log(this.lastMessage, RLog.Level.INFO);
                }
                catch (Exception ex) {
                    this.lastMessage = ex.getMessage();
                    this.log(this.lastMessage, RLog.Level.WARNING);
                }
                finally {
                    try {
                        this.R.eval("close(.fm)");
                        this.R.eval("unlink('" + this.toRpath(this.SINK_FILE) + ".m')");
                    }
                    catch (Exception ex) {
                        this.log("[exception] " + ex.getMessage(), RLog.Level.ERROR);
                    }
                }
            }
        }
        if (!tryEval) return e;
        if (e == null) return e;
        try {
            if (!e.inherits("try-error")) return e;
            this.log("[exception] " + e.asString() + "\n  " + expression, RLog.Level.WARNING);
            return new Rsession.RException("[exception] " + e.asString() + "\n  " + expression);
        }
        catch (Exception ex) {
            this.log("[error] " + ex.getMessage() + "\n  " + expression, RLog.Level.ERROR);
            return new Rsession.RException("[error] " + ex.getMessage() + "\n  " + expression);
        }
    }

    @Override
    public synchronized boolean set(String varname, double[][] data, String ... names) {
        this.note_code("`" + varname + "` <- " + (data == null ? "list()" : RenjinSession.toRcode(data)));
        this.note_code("names(" + varname + ") <- " + RenjinSession.toRcode(names));
        this.note_code("`" + varname + "` <- data.frame(" + varname + ")");
        if (data == null || data[0].length == 0) {
            if (names == null) {
                return false;
            }
            LinkedList<PairList> nulls = new LinkedList<PairList>();
            for (int i = 0; i < names.length; ++i) {
                nulls.add(Null.INSTANCE.clone());
            }
            ListVector l = new ListVector(nulls);
            this.R.put(varname, (Object)l);
            this.R.put(varname + ".names", (Object)new StringArrayVector(names));
            try {
                this.R.eval("names(" + varname + ") <- " + varname + ".names");
            }
            catch (ScriptException ex) {
                this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
                return false;
            }
            return true;
        }
        DoubleVector[] d = new DoubleVector[data[0].length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = new DoubleArrayVector(DoubleArray.getColumnCopy((double[][])data, (int)i));
        }
        ListVector l = new ListVector((SEXP[])d);
        this.R.put(varname, (Object)l);
        this.R.put(varname + ".names", (Object)new StringArrayVector(names));
        try {
            this.R.eval("names(" + varname + ") <- " + varname + ".names");
            this.R.eval(varname + " <- data.frame(" + varname + ", check.names=FALSE)");
        }
        catch (ScriptException ex) {
            this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean set(String varname, Object var) {
        this.note_code("`" + varname + "` <- " + RenjinSession.toRcode(var));
        if (var instanceof double[][]) {
            double[][] dd = (double[][])var;
            double[] d = RenjinSession.reshapeAsRow(dd);
            this.R.put(varname, (Object)d);
            try {
                this.R.eval(varname + " <- matrix(" + varname + ",nrow=" + dd.length + ")");
            }
            catch (ScriptException ex) {
                this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
                return false;
            }
        }
        if (var instanceof Map) {
            Map m = (Map)var;
            try {
                this.R.eval(varname + " <- list()");
            }
            catch (ScriptException ex) {
                this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
                return false;
            }
            for (Object k : m.keySet()) {
                String h = this.hash(k);
                this.R.put(varname + "." + h, m.get(k));
                try {
                    this.R.eval(varname + "[['" + k + "']] <- " + varname + "." + h);
                }
                catch (ScriptException ex) {
                    this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
                    return false;
                }
                try {
                    this.rm(varname + "." + h);
                }
                catch (Rsession.RException e) {
                    this.log("[error] " + e.getMessage(), RLog.Level.WARNING);
                }
            }
        } else {
            this.R.put(varname, var);
        }
        return true;
    }

    @Override
    public double asDouble(Object o) throws ClassCastException {
        if (o == null) {
            return (Double)null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asDouble] Not an SEXP object: " + o);
        }
        try {
            return ((SEXP)o).asReal();
        }
        catch (Exception ex) {
            throw new ClassCastException("[asDouble] Cannot cast to double " + o);
        }
    }

    @Override
    public double[] asArray(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof double[]) {
            return (double[])o;
        }
        if (o instanceof Double) {
            return new double[]{(Double)o};
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asArray] Not an SEXP object: " + o);
        }
        if (!(o instanceof DoubleVector)) {
            throw new IllegalArgumentException("[asArray] Not a DoubleVector object: " + o);
        }
        try {
            return ((DoubleVector)o).toDoubleArray();
        }
        catch (Exception ex) {
            throw new ClassCastException("[asArray] Cannot cast to double[] " + o);
        }
    }

    @Override
    public double[][] asMatrix(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof double[][]) {
            return (double[][])o;
        }
        if (o instanceof Map) {
            double[][] vals = null;
            int i = 0;
            try {
                for (Object k : ((Map)o).keySet()) {
                    double[] v = null;
                    try {
                        v = (double[])((Map)o).get(k);
                    }
                    catch (Exception ex) {
                        throw new ClassCastException("[asMatrix] Cannot cast list element to double[] " + ((Map)o).get(k) + " for key " + k + " in " + o);
                    }
                    if (v == null) {
                        throw new ClassCastException("[asMatrix] Cannot get list element as double[] " + ((Map)o).get(k) + " for key " + k + " in " + o);
                    }
                    if (vals == null) {
                        vals = new double[v.length][((Map)o).size()];
                    }
                    for (int j = 0; j < v.length; ++j) {
                        vals[j][i] = v[j];
                    }
                    ++i;
                }
                return vals;
            }
            catch (Exception ex) {
                throw new ClassCastException("[asMatrix] Cannot cast Map to matrix: " + ex.getMessage());
            }
        }
        if (o instanceof double[]) {
            return this.t(new double[][]{(double[])o});
        }
        if (o instanceof Double) {
            return new double[][]{{(Double)o}};
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asMatrix] Not an SEXP object: " + o);
        }
        if (!(o instanceof DoubleVector)) {
            throw new IllegalArgumentException("[asMatrix] Not a DoubleVector object: " + o);
        }
        try {
            Matrix m = new Matrix((Vector)((DoubleVector)o));
            double[][] mm = new double[m.getNumRows()][m.getNumCols()];
            for (int i = 0; i < mm.length; ++i) {
                for (int j = 0; j < mm[i].length; ++j) {
                    mm[i][j] = m.getElementAsDouble(i, j);
                }
            }
            return mm;
        }
        catch (Exception ex) {
            throw new ClassCastException("[asMatrix] Cannot cast to double[][] " + o);
        }
    }

    @Override
    public String asString(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asString] Not an SEXP object: " + o);
        }
        try {
            return ((SEXP)o).asString();
        }
        catch (Exception ex) {
            throw new ClassCastException("[asString] Cannot cast to String " + o);
        }
    }

    @Override
    public String[] asStrings(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asStrings] Not an SEXP object: " + o);
        }
        if (!(o instanceof StringVector)) {
            throw new IllegalArgumentException("[asStrings] Not a StringVector object: " + o);
        }
        try {
            int n = ((SEXP)o).length();
            String[] s = new String[n];
            for (int i = 0; i < n; ++i) {
                s[i] = ((SEXP)o).getElementAsSEXP(i).asString();
            }
            return s;
        }
        catch (Exception ex) {
            throw new ClassCastException("[asStrings] Cannot cast to String[] " + o);
        }
    }

    @Override
    public int asInteger(Object o) throws ClassCastException {
        if (o == null) {
            return (Integer)null;
        }
        return this.asIntegers(o)[0];
    }

    @Override
    public int[] asIntegers(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asIntegers] Not an SEXP object: " + o);
        }
        if (!(o instanceof IntVector)) {
            throw new IllegalArgumentException("[asIntegers] Not a IntVector object: " + o);
        }
        try {
            return ((IntVector)o).toIntArray();
        }
        catch (Exception ex) {
            throw new ClassCastException("[asIntegers] Cannot cast to int[] " + o);
        }
    }

    @Override
    public boolean asLogical(Object o) throws ClassCastException {
        if (o == null) {
            return (Boolean)null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Rsession.RException) {
            throw new IllegalArgumentException("[asLogical] Exception: " + ((Rsession.RException)o).getMessage());
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asLogical] Not an SEXP object: " + o);
        }
        try {
            return ((SEXP)o).asLogical() == Logical.TRUE;
        }
        catch (Exception ex) {
            throw new ClassCastException("[asLogical] Cannot cast to boolean " + o);
        }
    }

    @Override
    public boolean[] asLogicals(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof boolean[]) {
            return (boolean[])o;
        }
        if (o instanceof Boolean) {
            return new boolean[]{(Boolean)o};
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asLogicals] Not an SEXP object: " + o);
        }
        if (!(o instanceof LogicalVector)) {
            throw new IllegalArgumentException("[asLogicals] Not a LogicalVector object: " + o);
        }
        try {
            int n = ((SEXP)o).length();
            boolean[] s = new boolean[n];
            for (int i = 0; i < n; ++i) {
                s[i] = ((SEXP)o).getElementAsSEXP(i).asLogical() == Logical.TRUE;
            }
            return s;
        }
        catch (Exception ex) {
            throw new ClassCastException("[asLogicals] Cannot cast to boolean[] " + o);
        }
    }

    @Override
    public Map asList(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return (Map)o;
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[asList] Not an SEXP object: " + o);
        }
        if (!(o instanceof ListVector)) {
            throw new IllegalArgumentException("[asList] Not a ListVector object: " + o);
        }
        ListVector l = (ListVector)o;
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (int i = 0; i < l.length(); ++i) {
            m.put(l.getName(i), this.cast(l.get(i)));
        }
        return m;
    }

    @Override
    public boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (!(o instanceof SEXP)) {
            throw new IllegalArgumentException("[isNull] Not an SEXP object: " + o);
        }
        try {
            return o instanceof Null;
        }
        catch (Exception ex) {
            throw new ClassCastException("[isNull] Cannot cast to Null " + o);
        }
    }

    @Override
    public String toString(Object o) {
        if (o instanceof SEXP) {
            try {
                return ((SEXP)o).toString();
            }
            catch (Exception ex) {
                throw new ClassCastException("[toString] Cannot toString " + o);
            }
        }
        if (o.getClass().isArray()) {
            return Arrays.asList(o).toString();
        }
        return o.toString();
    }

    @Override
    public void closeLog() {
        super.closeLog();
        this.R.getSession().close();
    }

    @Override
    public Object cast(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (!(o instanceof SEXP)) {
            throw new ClassCastException("[cast] Not an SEXP object");
        }
        SEXP s = (SEXP)o;
        if (s.length() != 1) {
            switch (s.getTypeName()) {
                case "logical": {
                    return this.asLogicals(s);
                }
                case "integer": {
                    return this.asIntegers(s);
                }
                case "double": {
                    if (s.getAttributes().get("dim").length() == 2) {
                        return this.asMatrix(s);
                    }
                    return this.asArray(s);
                }
                case "character": {
                    return this.asStrings(s);
                }
                case "list": {
                    return this.asList(s);
                }
                case "NULL": {
                    return null;
                }
            }
            throw new ClassCastException("Cannot cast " + s + " (class " + s.getImplicitClass() + ", type " + s.getTypeName() + ")");
        }
        switch (s.getTypeName()) {
            case "logical": {
                return this.asLogical(s);
            }
            case "integer": {
                return this.asInteger(s);
            }
            case "double": {
                return this.asDouble(s);
            }
            case "character": {
                return this.asString(s);
            }
            case "list": {
                return this.asList(s);
            }
            case "closure": {
                String name = "function_" + (int)Math.floor(1000.0 * Math.random());
                this.R.put(name, (Object)s);
                try {
                    if (((SEXP)this.rawEval("is.function(" + name + ")")).asLogical() == Logical.TRUE) {
                        return new Rsession.Function(name);
                    }
                }
                catch (Exception ex) {
                    this.log(ex.getMessage(), RLog.Level.ERROR);
                }
            }
            case "NULL": {
                return null;
            }
        }
        throw new ClassCastException("Cannot cast " + s + " (class " + s.getImplicitClass() + ", type " + s.getTypeName() + ")");
    }

    @Override
    public String print(String command) {
        StringWriter w = new StringWriter();
        try {
            PrintWriter p = this.R.getSession().getStdOut();
            this.R.getSession().setStdOut(new PrintWriter(w));
            this.note_code("print(" + command + ")");
            this.silentlyRawEval("print(" + command + ")");
            this.R.getSession().setStdOut(p);
            return w.toString();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @Override
    public void setCRANRepository(String url) {
        if (!url.equals(this.repos)) {
            this.log("Cannot use another repository that " + this.repos, RLog.Level.WARNING);
        }
    }

    @Override
    public String installPackage(String pack, boolean load) {
        if (!load) {
            return "Renjin does not support yet installing package without loading.";
        }
        try {
            return this.loadPackage(pack);
        }
        catch (Exception e) {
            return "Renjin cannot install package " + pack + " yet: " + e.getMessage();
        }
    }

    @Override
    public String installPackage(String pack, File dir, boolean load) {
        if (!load) {
            return "Renjin does not support yet installing package without loading.";
        }
        try {
            return "Renjin does not support yet installing local package.";
        }
        catch (Exception e) {
            return "Renjin cannot install package " + pack + " from " + dir + " yet: " + e.getMessage();
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getwd() {
        String wd = super.getwd();
        if (this.isWindows() && wd.startsWith("/")) {
            return wd.substring(1);
        }
        return wd;
    }

    @Override
    public File putFileInWorkspace(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        File rf = this.local2remotePath(file);
        if (!rf.getAbsolutePath().equals(file.getAbsolutePath())) {
            try {
                FileUtils.copyFile((File)file, (File)rf);
            }
            catch (IOException ex) {
                this.log("[IO] " + ex.getMessage(), RLog.Level.ERROR);
            }
        }
        return rf;
    }

    @Override
    public void getFileFromWorkspace(File file) {
        if (file.isAbsolute()) {
            return;
        }
        File rf = this.remote2localPath(file);
        if (file.getParentFile() != null && !file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Cannot create parent dir: " + file);
        }
        if (!rf.getAbsolutePath().equals(file.getAbsolutePath())) {
            try {
                FileUtils.copyFile((File)rf, (File)new File(".", file.getPath()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.log("[IO] " + ex.getMessage(), RLog.Level.ERROR);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            args = new String[10];
            for (int i = 0; i < args.length; ++i) {
                args[i] = Math.random() + "+pi";
            }
        }
        RenjinSession R = new RenjinSession(System.out, null);
        for (int j = 0; j < args.length; ++j) {
            System.out.print(args[j] + ": ");
            System.out.println(R.cast(R.rawEval(args[j])));
        }
        R.closeLog();
        System.out.println(R.notebook());
    }

    @Override
    public void setGlobalEnv(String envName) {
        envName = envName == null ? ENVIRONMENT_DEFAULT : ".." + envName + "..";
        try {
            if (!this.asLogical(this.R.eval("exists('" + this.envName + "')"))) {
                this.R.eval(this.envName + " = new.env()");
            }
            this.R.eval("for (.n in ls()) {\n " + this.envName + "[[.n]] = .GlobalEnv[[.n]]\n}");
            this.rmAll();
            if (!this.asLogical(this.R.eval("exists('" + envName + "')"))) {
                this.R.eval(envName + " = new.env()");
            }
            this.R.eval("for (.n in ls(" + envName + ")) {\n .GlobalEnv[[.n]] = " + envName + "[[.n]]\n}");
        }
        catch (ScriptException ex) {
            Log.Err.println(ex.getMessage());
        }
        this.envName = envName;
    }

    @Override
    public void copyGlobalEnv(String envName) {
        envName = envName == null ? ENVIRONMENT_DEFAULT : ".." + envName + "..";
        try {
            if (!this.asLogical(this.R.eval("exists('" + envName + "')"))) {
                this.R.eval(envName + " = new.env()");
            }
            this.R.eval("for (.n in ls()) {\n " + envName + "[[.n]] = .GlobalEnv[[.n]]\n}");
        }
        catch (ScriptException ex) {
            Log.Err.println(ex.getMessage());
        }
    }
}

