/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import org.math.R.Log;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class RserverConf {
    public static String DEFAULT_RSERVE_HOST = "localhost";
    public static int DEFAULT_RSERVE_PORT = 6311;
    RConnection connection;
    public String host;
    public int port;
    public String login;
    public String password;
    public static long CONNECT_TIMEOUT = 5000L;
    public static final String RURL_START = "R://";

    public RserverConf(String RserverHostName, int RserverPort, String login, String password) {
        this.host = RserverHostName;
        this.port = RserverPort;
        this.login = login;
        this.password = password;
    }

    public synchronized RConnection connect() {
        TimeOut t = new TimeOut(){

            @Override
            protected Object defaultResult() {
                return -2;
            }

            @Override
            protected Object command() {
                int n = 10;
                while (n-- > 0) {
                    try {
                        if (RserverConf.this.host == null) {
                            RserverConf.this.connection = RserverConf.this.port > 0 ? new RConnection(DEFAULT_RSERVE_HOST, RserverConf.this.port) : new RConnection(DEFAULT_RSERVE_HOST, DEFAULT_RSERVE_PORT);
                            if (RserverConf.this.connection.needLogin()) {
                                RserverConf.this.connection.login(RserverConf.this.login, RserverConf.this.password);
                            }
                        } else {
                            RserverConf.this.connection = RserverConf.this.port > 0 ? new RConnection(RserverConf.this.host, RserverConf.this.port) : new RConnection(RserverConf.this.host);
                            if (RserverConf.this.connection.needLogin()) {
                                RserverConf.this.connection.login(RserverConf.this.login, RserverConf.this.password);
                            }
                        }
                        return 0;
                    }
                    catch (RserveException ex) {
                        Log.Err.println("Failed to connect on host:" + RserverConf.this.host + " port:" + RserverConf.this.port + " login:" + RserverConf.this.login + "\n  " + ex.getMessage());
                    }
                }
                return -1;
            }
        };
        try {
            t.execute(CONNECT_TIMEOUT);
        }
        catch (Exception e) {
            Log.Err.println("Connection " + this.toString() + " failed: " + e.getMessage());
        }
        if ((Integer)t.getResult() != 0) {
            Log.Err.println("Connection " + this.toString() + " failed.");
            return null;
        }
        return this.connection;
    }

    public boolean isLocal() {
        return this.host == null || this.host.equals(DEFAULT_RSERVE_HOST) || this.host.equals("127.0.0.1") || this.host.equals("localhost");
    }

    public String toString() {
        return RURL_START + (this.login != null ? this.login + ":" + this.password + "@" : "") + (this.host == null ? DEFAULT_RSERVE_HOST : this.host) + (this.port > 0 ? ":" + this.port : "");
    }

    public static RserverConf parse(String RURL) {
        String login = null;
        String passwd = null;
        String host = null;
        int port = -1;
        try {
            String loginhostport = null;
            loginhostport = RURL.contains("?") ? RserverConf.beforeFirst(RURL, "?").substring(RURL_START.length()) : RURL.substring(RURL_START.length());
            String hostport = null;
            if (loginhostport.contains("@")) {
                hostport = RserverConf.afterFirst(loginhostport, "@");
                String loginpasswd = RserverConf.beforeFirst(loginhostport, "@");
                login = RserverConf.beforeFirst(loginpasswd, ":");
                if (login.equals("user.name")) {
                    login = System.getProperty("user.name");
                }
                passwd = RserverConf.afterFirst(loginpasswd, ":");
            } else {
                hostport = loginhostport;
            }
            if (hostport.contains(":")) {
                host = RserverConf.beforeFirst(hostport, ":");
                port = Integer.parseInt(RserverConf.afterFirst(hostport, ":"));
            } else {
                host = hostport;
            }
            return new RserverConf(host, port, login, passwd);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Impossible to parse " + RURL + ":\n  host=" + host + "\n  port=" + port + "\n  login=" + login + "\n  password=" + passwd);
        }
    }

    static String beforeFirst(String txt, String sep) {
        if (txt == null) {
            return null;
        }
        if (txt.contains(sep)) {
            int i = txt.indexOf(sep);
            return txt.substring(0, i);
        }
        return txt;
    }

    static String afterFirst(String txt, String sep) {
        if (txt == null) {
            return null;
        }
        if (txt.contains(sep)) {
            int i = txt.indexOf(sep);
            if (i >= txt.length()) {
                return "";
            }
            return txt.substring(i + 1);
        }
        return "";
    }

    public static abstract class TimeOut {
        private boolean timedOut = false;
        private Object result = null;

        public Object getResult() {
            return this.result;
        }

        protected TimeOut() {
        }

        public synchronized void execute(long timeout) throws TimeOutException {
            new Thread(new TimeoutThread()).start();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                if (this.getResult() == null) {
                    this.timedOut = true;
                    this.result = this.defaultResult();
                    throw new TimeOutException("timed out");
                }
                return;
            }
            if (this.getResult() != null) {
                return;
            }
            this.timedOut = true;
            this.result = this.defaultResult();
            throw new TimeOutException("timed out");
        }

        protected abstract Object defaultResult();

        protected abstract Object command();

        private class TimeoutThread
        implements Runnable {
            private TimeoutThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object res = TimeOut.this.command();
                TimeOut timeOut = TimeOut.this;
                synchronized (timeOut) {
                    if (!TimeOut.this.timedOut || res == null) {
                        TimeOut.this.result = res;
                        TimeOut.this.notify();
                    }
                }
            }
        }

        public static class TimeOutException
        extends Exception {
            public TimeOutException(String why) {
                super(why);
            }
        }
    }
}

