/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.math.R.BusyListener;
import org.math.R.EvalListener;
import org.math.R.RLog;
import org.math.R.UpdateObjectsListener;

public abstract class Rsession
implements RLog {
    public static final String HEAD_TRY = "[?] ";
    public boolean TRY_MODE_DEFAULT = true;
    public boolean TRY_MODE = false;
    public static final String CAST_ERROR = "Cannot cast ";
    private static final String __ = "  ";
    public static final String _PACKAGE_ = "  package ";
    RLog console;
    public static final String PACKAGEINSTALLED = "Package installed.";
    public static final String PACKAGELOADED = "Package loaded.";
    static String separator = ",";
    String install_packages_moreargs = "";
    List<RLog> loggers;
    public boolean debug;
    boolean SINK_OUTPUT = true;
    boolean SINK_MESSAGE = true;
    String SINK_FILE_BASE = System.getProperty("java.io.tmpdir") + File.separator + ".Rout";
    String SINK_FILE = null;
    String lastOuput = "";
    String lastMessage = "";
    List<BusyListener> busy = new LinkedList<BusyListener>();
    List<UpdateObjectsListener> updateObjects = new LinkedList<UpdateObjectsListener>();
    List<EvalListener> eval = new LinkedList<EvalListener>();
    String lastLog = "";
    int repeated = 0;
    String nb_header = "---\ntitle: '" + this.getClass().getName() + " notebook'\ndate: '" + Calendar.getInstance().getTime().toString() + "'\nauthor: '" + System.getProperty("user.name") + "'\nhost: '" + this.hostname() + "'\noutput: html_notebook\n---\n\n";
    StringBuilder nb = new StringBuilder();
    public static String DEFAULT_REPOS = System.getProperty("Rserve.repos", "https://cloud.r-project.org");
    public String repos = DEFAULT_REPOS;
    private static String loadedpacks = "loadedpacks";
    private static String packs = "packs";
    static final String HEAD_EVAL = "[eval] ";
    static final String HEAD_EXCEPTION = "[exception] ";
    static final String HEAD_ERROR = "[error] ";
    static final String HEAD_CACHE = "[cache] ";
    public boolean SAVE_ASCII = false;
    static final String[] types = new String[]{"data.frame", "null", "function", "array", "integer", "character", "double"};
    public static final String HEAD_SET = "[set] ";
    public static final String GRAPHIC_PNG = "png";
    public static final String GRAPHIC_JPEG = "jpeg";
    public static final String GRAPHIC_BMP = "bmp";
    public static final String GRAPHIC_TIFF = "tiff";
    static final String IO_HEAD = "[IO] ";
    static final String testExpression = "1+pi";
    static final double testResult = 4.141592653589793;
    Map<String, Object> noVarsEvals = new HashMap<String, Object>();
    static final String AW = "((\\A)|(\\W))(";
    static final String Az = ")((\\W)|(\\z))";
    protected String envName = "UNDEFINED_ENV";

    public void sinkOutput(boolean s) {
        this.SINK_OUTPUT = s;
    }

    public void sinkMessage(boolean s) {
        this.SINK_MESSAGE = s;
    }

    void cleanupListeners() {
        if (this.loggers != null) {
            this.loggers.clear();
        }
        if (this.busy != null) {
            this.busy.clear();
        }
        if (this.updateObjects != null) {
            this.updateObjects.clear();
        }
        if (this.eval != null) {
            this.eval.clear();
        }
    }

    public abstract boolean isAvailable();

    protected void finalize() throws Throwable {
        this.closeLog();
        super.finalize();
    }

    public void addLogger(RLog l) {
        if (!this.loggers.contains(l)) {
            this.loggers.add(l);
        }
    }

    public void removeLogger(RLog l) {
        if (this.loggers.contains(l)) {
            l.closeLog();
            this.loggers.remove(l);
        }
    }

    @Override
    public void closeLog() {
        if (this.loggers != null) {
            for (RLog l : this.loggers) {
                if (l == null) continue;
                l.closeLog();
            }
        }
    }

    public void end() {
        this.closeLog();
    }

    public void addBusyListener(BusyListener b) {
        if (!this.busy.contains(b)) {
            this.busy.add(b);
        }
    }

    public void removeBusyListener(BusyListener b) {
        if (this.busy.contains(b)) {
            this.busy.remove(b);
        }
    }

    public void setBusy(boolean bb) {
        for (BusyListener b : this.busy) {
            b.setBusy(bb);
        }
    }

    public void addUpdateObjectsListener(UpdateObjectsListener b) {
        if (!this.updateObjects.contains(b)) {
            this.updateObjects.add(b);
        }
    }

    public void removeUpdateObjectsListener(UpdateObjectsListener b) {
        if (this.updateObjects.contains(b)) {
            b.setTarget(null);
            this.updateObjects.remove(b);
        }
    }

    public void addEvalListener(EvalListener b) {
        if (!this.eval.contains(b)) {
            this.eval.add(b);
        }
    }

    public void removeEvalListener(EvalListener b) {
        if (this.eval.contains(b)) {
            this.eval.remove(b);
        }
    }

    public static String cat(double[] array) {
        if (array == null || array.length == 0) {
            return "NA";
        }
        String o = array[0] + "";
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + array[i] + "";
            }
        }
        return o;
    }

    public static String cat(int[] array) {
        if (array == null || array.length == 0) {
            return "NA";
        }
        String o = array[0] + "";
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + array[i] + "";
            }
        }
        return o;
    }

    public static String cat(double[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public static String cat(int[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public static String cat(Object[] array) {
        if (array == null || array.length == 0 || array[0] == null) {
            return "";
        }
        String o = array[0].toString();
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + (array[i] == null ? "" : array[i].toString());
            }
        }
        return o;
    }

    public static String cat(String sep, String[] array) {
        if (array == null || array.length == 0 || array[0] == null) {
            return "";
        }
        String o = array[0].toString();
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + sep + (array[i] == null ? "" : array[i].toString());
            }
        }
        return o;
    }

    public static String cat(Object[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public String toRpath(File path) {
        if (this.isAvailable() && !path.isAbsolute()) {
            path = new File(this.getwd(), path.getPath());
        }
        return path.getPath().replace(File.separatorChar, '/');
    }

    public String toRpath(String path) {
        return this.toRpath(new File(path));
    }

    public Rsession(RLog console) {
        this.console = console;
        this.loggers = new LinkedList<RLog>();
        this.loggers.add(console);
        this.SINK_FILE = this.SINK_FILE_BASE;
    }

    public Rsession(final PrintStream p) {
        this(new RLog(){

            @Override
            public void log(String string, RLog.Level level) {
                if (level == RLog.Level.WARNING) {
                    p.print("(?) ");
                } else if (level == RLog.Level.ERROR) {
                    p.print("(!!) ");
                } else if (level == RLog.Level.OUTPUT) {
                    p.print("> ");
                }
                p.println(string);
            }

            @Override
            public void closeLog() {
                p.close();
            }
        });
    }

    void setenv(Properties properties) {
        if (properties != null) {
            for (String p : properties.stringPropertyNames()) {
                if (p == null) continue;
                try {
                    this.log("Setting environment " + p + ": '" + properties.getProperty(p).replaceAll("\\:([^/])(.*)\\@", ":???@") + "'", RLog.Level.INFO);
                    boolean done = this.asLogical(this.silentlyRawEval("Sys.setenv(" + p + "='" + properties.getProperty(p) + "')", false));
                    if (done) continue;
                    this.log("Failed setting environment " + p, RLog.Level.WARNING);
                }
                catch (Exception ex) {
                    this.log("Failed setting environment " + p + ": " + ex.getMessage(), RLog.Level.WARNING);
                    ex.printStackTrace();
                }
            }
        }
    }

    public String getLastLogEntry() {
        return this.lastLog;
    }

    private void err_println(String message, RLog.Level level) {
        if (level == RLog.Level.ERROR) {
            try {
                message = message + "\n R> " + this.getLastLogEntry();
            }
            catch (Exception e) {
                message = message + "\n ! " + e.getMessage();
            }
        }
    }

    String hostname() {
        String hostname = "?";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "?";
        }
        return hostname;
    }

    public void note_header(String title, String author) {
        this.nb_header = "---\ntitle: '" + title + "'\ndate: '" + Calendar.getInstance().getTime().toString() + "'\nauthor: '" + author + "'\nhost: '" + this.hostname() + "'\noutput: html_notebook\n---\n\n";
    }

    public void note_text(String txt) {
        this.nb.append(txt).append("\n");
    }

    public void note_code(String ... code) {
        StringBuilder codes = new StringBuilder();
        for (String c : code) {
            codes.append(c + "\n");
        }
        this.note_code(codes.toString());
    }

    public void note_code(String code) {
        this.nb.append("```{r}\n").append(code).append("\n```\n");
    }

    protected static String toRcode(Object o) {
        if (o instanceof double[]) {
            return Rsession.toRcode((double[])o);
        }
        if (o instanceof double[][]) {
            return Rsession.toRcode((double[][])o);
        }
        if (o instanceof Double[]) {
            return Rsession.toRcode((Double[])o);
        }
        if (o instanceof Double[][]) {
            return Rsession.toRcode((Double[][])o);
        }
        if (o instanceof String[]) {
            return Rsession.toRcode((String[])o);
        }
        if (o instanceof String) {
            return "'" + o + "'";
        }
        if (o instanceof Integer) {
            return o.toString();
        }
        if (o instanceof Double) {
            return o.toString();
        }
        if (o instanceof File) {
            return Rsession.toRcode(((File)o).getName());
        }
        return "stop('Cannot code in R object:" + o + "')";
    }

    protected static String toRcode(double[] d) {
        String ds = "c( ";
        for (double e : d) {
            ds = ds + e + ",";
        }
        return ds.substring(0, ds.length() - 1) + ")";
    }

    protected static String toRcode(Double[] d) {
        String ds = "c( ";
        Double[] doubleArray = d;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double e = doubleArray[i];
            ds = ds + e + ",";
        }
        return ds.substring(0, ds.length() - 1) + ")";
    }

    protected static String toRcode(double[][] d) {
        String ds = "rbind( ";
        for (double[] e : d) {
            ds = ds + Rsession.toRcode(e) + ",";
        }
        return ds.substring(0, ds.length() - 1) + ")";
    }

    protected static String toRcode(Double[][] d) {
        String ds = "rbind( ";
        for (Double[] e : d) {
            ds = ds + Rsession.toRcode(e) + ",";
        }
        return ds.substring(0, ds.length() - 1) + ")";
    }

    protected static String toRcode(String[] d) {
        String ds = "c( ";
        for (String e : d) {
            ds = ds + "'" + e + "',";
        }
        return ds.substring(0, ds.length() - 1) + ")";
    }

    protected static String toRcode(Map l) {
        String sl = "list(";
        for (Object k : l.keySet()) {
            if (l.get(k) instanceof double[]) {
                double[] v = (double[])l.get(k);
                sl = sl + k + "=" + Rsession.toRcode(v) + ",";
                continue;
            }
            sl = sl + k + "=" + l.get(k) + ",";
        }
        return sl.substring(0, sl.length() - 1) + ")";
    }

    public String notebook() {
        return this.nb_header.toString() + "\n" + this.nb.toString().replace("```\n```{r}\n", "");
    }

    @Override
    public void log(String message, RLog.Level level) {
        if (message == null || message.trim().length() <= 0 || message.trim().equals("\n") || level != RLog.Level.OUTPUT) {
            if (message == null) {
                return;
            }
            message = message.trim();
            while (message.endsWith("\n")) {
                message = message.substring(0, message.length() - 2);
            }
            if (message.equals(this.lastLog) && this.repeated < 100) {
                ++this.repeated;
            } else if (this.repeated > 0) {
                this.err_println("    Repeated " + this.repeated + " times.", level);
                this.repeated = 0;
                this.lastLog = message;
                this.err_println(message, level);
            } else {
                this.lastLog = message;
                this.err_println(message, level);
            }
        }
        if (this.loggers != null) {
            for (RLog l : this.loggers) {
                if (l == null) continue;
                l.log(message, level);
            }
        }
    }

    public String[] listCommands() {
        this.silentlyRawEval(".keyWords <- function() {n <- length(search());result <- c();for (i in 1:n) {result <- c(result,ls(pos=i,all.names=TRUE))}; result}");
        Object rexp = this.silentlyRawEval(".keyWords()");
        String[] as = null;
        try {
            if (rexp != null && (as = this.asStrings(rexp)) != null) {
                return as;
            }
            return null;
        }
        catch (Exception ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  listCommands()", RLog.Level.ERROR);
            return null;
        }
    }

    public void setRepository(String url) {
        this.repos = url;
    }

    public void setCRANRepository(String url) {
        this.setRepository(url);
    }

    public String getRepository() {
        return this.repos;
    }

    public boolean isPackageLoaded(String pack) {
        this.silentlyVoidEval(loadedpacks + "<-.packages()", false);
        boolean isloaded = false;
        try {
            Object i = this.silentlyRawEval("is.element(set=" + loadedpacks + ",el='" + pack + "')");
            if (i != null) {
                isloaded = this.asLogical(i);
            }
        }
        catch (Exception ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageLoaded(String pack=" + pack + ")", RLog.Level.ERROR);
        }
        if (isloaded) {
            this.log(_PACKAGE_ + pack + " is loaded.", RLog.Level.INFO);
        } else {
            this.log(_PACKAGE_ + pack + " is not loaded.", RLog.Level.INFO);
        }
        return isloaded;
    }

    public boolean isPackageInstalled(String pack, String version) {
        this.silentlyVoidEval(packs + "<-installed.packages(noCache=TRUE" + this.install_packages_moreargs + ")", false);
        boolean isinstalled = false;
        Object r = this.silentlyRawEval("is.element(set=row.names(" + packs + "),el='" + pack + "')");
        try {
            if (r != null) {
                isinstalled = this.asInteger(r) == 1;
            } else {
                this.log("[error] Could not list installed packages\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")", RLog.Level.ERROR);
            }
        }
        catch (Exception ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")", RLog.Level.ERROR);
        }
        if (isinstalled) {
            this.log(_PACKAGE_ + pack + " is installed.", RLog.Level.INFO);
        } else {
            this.log(_PACKAGE_ + pack + " is not installed.", RLog.Level.INFO);
        }
        if (isinstalled && version != null && version.length() > 0) {
            try {
                isinstalled = this.asLogical(this.silentlyRawEval(packs + "['" + pack + "','Version'] == \"" + version + "\""));
            }
            catch (Exception ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")", RLog.Level.ERROR);
            }
            try {
                this.log("    version of package " + pack + " is " + this.asString(this.silentlyRawEval(packs + "['" + pack + "','Version']")), RLog.Level.INFO);
            }
            catch (Exception ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")", RLog.Level.ERROR);
            }
            if (isinstalled) {
                this.log(_PACKAGE_ + pack + " (" + version + ")  is installed.", RLog.Level.INFO);
            } else {
                this.log(_PACKAGE_ + pack + " (" + version + ")  is not installed.", RLog.Level.INFO);
            }
        }
        return isinstalled;
    }

    public String installPackages(String[] pack, boolean load) {
        String resall = "";
        for (String pv : pack) {
            String res = this.installPackage(pv, load);
            if (load) {
                if (res.equals(PACKAGELOADED)) continue;
                resall = resall + "\n" + res;
                continue;
            }
            if (res.equals(PACKAGEINSTALLED)) continue;
            resall = resall + "\n" + res;
        }
        if (resall.length() > 0) {
            return resall;
        }
        return load ? PACKAGELOADED : PACKAGEINSTALLED;
    }

    public String installPackage(File pack, boolean load) {
        pack = this.putFileInWorkspace(pack);
        try {
            this.rawEval("install.packages('" + pack.getPath().replace("\\", "/") + "',repos=NULL,quiet=T" + this.install_packages_moreargs + ")");
        }
        catch (Exception ex) {
            this.log(ex.getMessage(), RLog.Level.ERROR);
        }
        this.log("  request package " + pack + " install...", RLog.Level.INFO);
        String name = pack.getName();
        String version = null;
        if (name.contains("_")) {
            name = name.substring(0, name.indexOf("_"));
            version = name.substring(name.indexOf("_") + 1);
            version = version.substring(0, version.indexOf("."));
        } else if (name.contains(".")) {
            name = name.substring(0, name.indexOf("."));
        }
        if (this.isPackageInstalled(name, version)) {
            this.log(_PACKAGE_ + pack + " version " + version + " installation sucessfull.", RLog.Level.INFO);
            if (load) {
                return this.loadPackage(name);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " installation failed.", RLog.Level.ERROR);
        return "Impossible to install package " + pack + " !";
    }

    abstract boolean isWindows();

    abstract boolean isLinux();

    abstract boolean isMacOSX();

    public String installPackage(final String pack, File dir, boolean load) {
        File[] pack_files;
        this.log("  trying to load package " + pack, RLog.Level.INFO);
        if (this.isPackageInstalled(pack, null)) {
            this.log(_PACKAGE_ + pack + " already installed.", RLog.Level.INFO);
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " not yet installed.", RLog.Level.INFO);
        File[] fileArray = pack_files = dir == null ? null : dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.getName().contains(pack)) {
                    return false;
                }
                if (Rsession.this.isWindows()) {
                    return pathname.getName().endsWith(".zip");
                }
                if (Rsession.this.isLinux()) {
                    return pathname.getName().endsWith(".tar.gz");
                }
                if (Rsession.this.isMacOSX()) {
                    return pathname.getName().endsWith(".tgz");
                }
                return false;
            }
        });
        if (pack_files == null || pack_files.length == 0) {
            this.log("  impossible to find package " + pack + " in directory " + dir.getPath() + " !", RLog.Level.WARNING);
            return "Impossible to find package " + pack + " in directory " + dir.getPath() + " !";
        }
        this.log("  found package " + pack + " : " + pack_files[0].getPath(), RLog.Level.INFO);
        return this.installPackage(pack_files[0], load);
    }

    public String installPackage(String pack, boolean load) {
        this.log("  trying to intall " + (load ? "& load " : "") + "package " + pack, RLog.Level.INFO);
        if (this.isPackageInstalled(pack, null)) {
            this.log(_PACKAGE_ + pack + " already installed.", RLog.Level.INFO);
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " not yet installed.", RLog.Level.INFO);
        this.rawEval("install.packages('" + pack + "',repos='" + this.repos + "',quiet=T" + this.install_packages_moreargs + ")", this.TRY_MODE);
        this.log("  request if package " + pack + " is installed...", RLog.Level.INFO);
        if (this.isPackageInstalled(pack, null)) {
            this.log(_PACKAGE_ + pack + " installation sucessfull.", RLog.Level.INFO);
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " installation failed.", RLog.Level.ERROR);
        if (load) {
            return this.loadPackage(pack);
        }
        return "Impossible to install package " + pack + " !";
    }

    public String loadPackage(String pack) {
        this.log("  request package " + pack + " loading...", RLog.Level.INFO);
        try {
            boolean ok = this.asLogical(this.rawEval("library(" + pack + ",logical.return=T,quietly=T,verbose=F" + this.install_packages_moreargs + ")", this.TRY_MODE));
            if (ok) {
                this.log(_PACKAGE_ + pack + " loading sucessfull.", RLog.Level.INFO);
                return PACKAGELOADED;
            }
            this.log(_PACKAGE_ + pack + " loading failed.", RLog.Level.ERROR);
            return "Impossible to load package " + pack + ": " + this.getLastLogEntry();
        }
        catch (Exception ex) {
            this.log(_PACKAGE_ + pack + " loading failed.", RLog.Level.ERROR);
            return "Impossible to load package " + pack + ": " + ex.getLocalizedMessage();
        }
    }

    public String getLastOutput() {
        if (!this.SINK_OUTPUT) {
            return null;
        }
        return this.lastOuput;
    }

    public String getLastError() {
        if (!this.SINK_MESSAGE) {
            Object err = this.silentlyRawEval("geterrmessage()");
            return err == null ? "" : this.asString(err);
        }
        return this.lastMessage;
    }

    protected boolean silentlyVoidEval(String expression) {
        return this.silentlyVoidEval(expression, this.TRY_MODE_DEFAULT);
    }

    protected abstract boolean silentlyVoidEval(String var1, boolean var2);

    protected Object silentlyRawEval(String expression) {
        return this.silentlyRawEval(expression, this.TRY_MODE_DEFAULT);
    }

    protected abstract Object silentlyRawEval(String var1, boolean var2);

    protected Object rawEval(String expression, boolean tryEval) {
        this.log(HEAD_EVAL + (tryEval ? HEAD_TRY : "") + expression, RLog.Level.INFO);
        this.note_code(expression);
        Object e = this.silentlyRawEval(expression, tryEval);
        for (UpdateObjectsListener b : this.updateObjects) {
            b.update();
        }
        if (e != null) {
            this.log(__ + this.toString(e), RLog.Level.INFO);
        }
        return e;
    }

    protected Object rawEval(String expression) {
        return this.rawEval(expression, this.TRY_MODE_DEFAULT);
    }

    public boolean voidEval(String expression, boolean tryEval) throws RException {
        this.log(HEAD_EVAL + (tryEval ? HEAD_TRY : " ") + expression, RLog.Level.INFO);
        this.note_code(expression);
        boolean done = this.silentlyVoidEval(expression, tryEval);
        if (!done) {
            this.note_text("Failed to evaluate " + expression);
            throw new RException("Failed to evaluate " + expression);
        }
        if (done) {
            for (UpdateObjectsListener b : this.updateObjects) {
                b.update();
            }
        }
        return done;
    }

    public boolean voidEval(String expression) throws RException {
        boolean done = this.voidEval(expression, this.TRY_MODE_DEFAULT);
        if (!done) {
            throw new RException("Failed to evaluate " + expression);
        }
        return done;
    }

    public Object eval(String expression, boolean tryEval) throws RException {
        Object o = this.rawEval(expression, tryEval);
        if (o != null && o instanceof RException) {
            throw (RException)o;
        }
        return this.cast(o);
    }

    public Object eval(String expression) throws RException {
        Object o = this.rawEval(expression);
        if (o != null && o instanceof RException) {
            throw (RException)o;
        }
        return this.cast(o);
    }

    public boolean rmAll(boolean all) {
        try {
            return this.voidEval("rm(list=ls(all=" + (all ? "TRUE" : "FALSE") + "))", this.TRY_MODE);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean rmAll() {
        return this.rmAll(false);
    }

    public static String buildList(String ... vars) {
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append(v + ",");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        return vars[0];
    }

    public static String buildListString(String ... vars) {
        if (vars == null) {
            return null;
        }
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append("'" + v + "',");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        if (vars.length == 1 && vars[0] != null) {
            return "'" + vars[0] + "'";
        }
        return "''";
    }

    public static String buildListPattern(String ... vars) {
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append("ls(pattern='" + v + "'),");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        return "ls(pattern='" + vars[0] + "')";
    }

    public abstract String gethomedir();

    public String getwd() {
        return this.asString(this.silentlyRawEval("getwd()"));
    }

    public void setwd(File wdir) {
        this.silentlyVoidEval("setwd('" + this.toRpath(wdir) + "')");
    }

    public abstract File putFileInWorkspace(File var1);

    public File local2remotePath(File localpath) {
        return new File(this.getwd().replace(File.separator, "/"), localpath.getPath().replace(File.separator, "_-_").replace(":", "_._"));
    }

    public File remote2localPath(File remotepath) {
        return new File(remotepath.getPath().replace((this.getwd() + "/").replace('/', File.separatorChar), "").replace("_-_", File.separator).replace("_._", ":"));
    }

    public void source(File f) {
        f = this.putFileInWorkspace(f);
        try {
            assert (this.asLogical(this.rawEval("file.exists('" + f.getPath().replace("\\", "/") + "')", this.TRY_MODE))) : "Cannot find " + f.getPath();
        }
        catch (Exception r) {
            this.log(r.getMessage(), RLog.Level.ERROR);
        }
        try {
            this.voidEval("source('" + f.getPath().replace("\\", "/") + "')", this.TRY_MODE);
        }
        catch (Exception ex) {
            this.log(ex.getMessage(), RLog.Level.ERROR);
        }
    }

    public void load(File f) {
        f = this.putFileInWorkspace(f);
        try {
            assert (this.asLogical(this.rawEval("file.exists('" + f.getPath().replace("\\", "/") + "')", this.TRY_MODE)));
        }
        catch (Exception r) {
            this.log(r.getMessage(), RLog.Level.ERROR);
        }
        try {
            this.voidEval("load('" + f.getPath().replace("\\", "/") + "')", this.TRY_MODE);
        }
        catch (Exception ex) {
            this.log(ex.getMessage(), RLog.Level.ERROR);
        }
    }

    public String[] ls() {
        return this.ls(false);
    }

    public String[] ls(boolean all) {
        try {
            String[] ls = this.asStrings(this.rawEval("ls(all.names=" + (all ? "TRUE" : "FALSE") + ")", false));
            if (ls == null) {
                return new String[0];
            }
            return ls;
        }
        catch (Exception re) {
            this.log(re.getMessage(), RLog.Level.ERROR);
            return new String[0];
        }
    }

    public String[] ls(String ... vars) {
        if (vars == null || vars.length == 0) {
            try {
                return this.asStrings(this.rawEval("ls()", false));
            }
            catch (Exception re) {
                this.log(re.getMessage(), RLog.Level.ERROR);
                return new String[0];
            }
        }
        if (vars.length == 1) {
            try {
                return this.asStrings(this.rawEval(Rsession.buildListPattern(vars[0]), this.TRY_MODE));
            }
            catch (Exception re) {
                this.log(re.getMessage(), RLog.Level.ERROR);
                return new String[0];
            }
        }
        try {
            return this.asStrings(this.rawEval(Rsession.buildListPattern(vars), this.TRY_MODE));
        }
        catch (Exception re) {
            this.log(re.getMessage(), RLog.Level.ERROR);
            return new String[0];
        }
    }

    public boolean rm(String ... vars) throws RException {
        if (vars.length == 1) {
            return this.voidEval("rm(" + vars[0] + ")", this.TRY_MODE);
        }
        return this.voidEval("rm(list=" + Rsession.buildListString(vars) + ")", this.TRY_MODE);
    }

    public boolean rmls(String ... vars) throws RException {
        if (vars.length == 1) {
            return this.voidEval("rm(list=" + Rsession.buildListPattern(vars[0]) + ")", this.TRY_MODE);
        }
        return this.voidEval("rm(list=" + Rsession.buildListPattern(vars) + ")", this.TRY_MODE);
    }

    public abstract void getFileFromWorkspace(File var1);

    public void save(File f, String ... vars) throws RException {
        if (vars == null || vars.length == 0) {
            this.log("Nothing to save.", RLog.Level.WARNING);
            return;
        }
        if (vars.length == 1) {
            if (vars[0] == null) {
                this.log("Nothing to save.", RLog.Level.WARNING);
                return;
            }
            this.voidEval("save(file='" + Rsession.getAbsolutePath(f) + "','" + vars[0] + "',ascii=" + (this.SAVE_ASCII ? "TRUE" : "FALSE") + ")", this.TRY_MODE);
        } else {
            this.voidEval("save(file='" + Rsession.getAbsolutePath(f) + "',list=" + Rsession.buildListString(vars) + ",ascii=" + (this.SAVE_ASCII ? "TRUE" : "FALSE") + ")", this.TRY_MODE);
        }
        this.getFileFromWorkspace(f);
    }

    public void savels(File f, String ... vars) throws RException {
        if (vars == null) {
            this.log("Nothing to save.", RLog.Level.WARNING);
            return;
        }
        if (vars.length == 1) {
            if (vars[0] == null) {
                this.log("Nothing to save.", RLog.Level.WARNING);
                return;
            }
            this.voidEval("save(file='" + Rsession.getAbsolutePath(f) + "',list=" + Rsession.buildListPattern(vars[0]) + ",ascii=" + (this.SAVE_ASCII ? "TRUE" : "FALSE") + ")", this.TRY_MODE);
        } else {
            this.voidEval("save(file='" + Rsession.getAbsolutePath(f) + "',list=" + Rsession.buildListPattern(vars) + ",ascii=" + (this.SAVE_ASCII ? "TRUE" : "FALSE") + ")", this.TRY_MODE);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getFileFromWorkspace(f);
    }

    public String typeOf(String robject) {
        if (robject == null) {
            return "NULL";
        }
        for (String t : types) {
            try {
                boolean is = this.asLogical(this.silentlyRawEval("is." + t + "(" + robject + ")"));
                if (!is) continue;
                return t;
            }
            catch (Exception ex) {
                this.log("[error] [typeOf] " + robject + " type unknown.", RLog.Level.ERROR);
                return null;
            }
        }
        return "unknown";
    }

    public boolean unset(String ... varname) throws RException {
        return this.rm(varname);
    }

    public boolean unset(Collection varname) throws RException {
        boolean done = true;
        for (Object v : varname) {
            done &= this.rm(v.toString());
        }
        return done;
    }

    public boolean set(Map<String, Object> _vars) throws RException {
        boolean done = true;
        for (String varname : _vars.keySet()) {
            done &= this.set(varname, _vars.get(varname));
        }
        return done;
    }

    public abstract boolean set(String var1, double[][] var2, String ... var3) throws RException;

    public abstract boolean set(String var1, Object var2) throws RException;

    protected static double[] reshapeAsRow(double[][] a) {
        double[] reshaped = new double[a.length * a[0].length];
        int ir = 0;
        for (int j = 0; j < a[0].length; ++j) {
            for (int i = 0; i < a.length; ++i) {
                reshaped[ir] = a[i][j];
                ++ir;
            }
        }
        return reshaped;
    }

    protected static double[] reshapeAsRow(Double[][] a) {
        double[] reshaped = new double[a.length * a[0].length];
        int ir = 0;
        for (int j = 0; j < a[0].length; ++j) {
            for (int i = 0; i < a.length; ++i) {
                reshaped[ir] = a[i][j];
                ++ir;
            }
        }
        return reshaped;
    }

    protected double[][] t(double[][] m) {
        double[][] tm = new double[m[0].length][m.length];
        for (int i = 0; i < tm.length; ++i) {
            for (int j = 0; j < tm[i].length; ++j) {
                tm[i][j] = m[j][i];
            }
        }
        return tm;
    }

    public abstract double asDouble(Object var1) throws ClassCastException;

    public abstract double[] asArray(Object var1) throws ClassCastException;

    public abstract double[][] asMatrix(Object var1) throws ClassCastException;

    public abstract String asString(Object var1) throws ClassCastException;

    public abstract String[] asStrings(Object var1) throws ClassCastException;

    public abstract int asInteger(Object var1) throws ClassCastException;

    public abstract int[] asIntegers(Object var1) throws ClassCastException;

    public abstract boolean asLogical(Object var1) throws ClassCastException;

    public abstract boolean[] asLogicals(Object var1) throws ClassCastException;

    public abstract Map asList(Object var1) throws ClassCastException;

    public abstract boolean isNull(Object var1);

    public abstract String toString(Object var1);

    public abstract Object cast(Object var1) throws ClassCastException;

    public void toGraphic(File f, int width, int height, String fileformat, String ... commands) {
        int h = Math.abs(f.hashCode());
        try {
            this.set("plotfile_" + h, Rsession.getAbsolutePath(f));
        }
        catch (Exception ex) {
            this.log(ex.getMessage(), RLog.Level.ERROR);
        }
        this.silentlyRawEval(fileformat + "(plotfile_" + h + ", width=" + width + ", height=" + height + ")");
        for (String command : commands) {
            this.note_code(command);
            this.silentlyVoidEval(command);
        }
        this.silentlyRawEval("dev.off()");
        try {
            this.rm("plotfile_" + h);
        }
        catch (Exception ex) {
            this.log(ex.getMessage(), RLog.Level.ERROR);
        }
        this.getFileFromWorkspace(f);
    }

    private static String getAbsolutePath(File f) {
        String curPath = f.getPath().replace("\\", "/");
        if (curPath.startsWith("/")) {
            return curPath;
        }
        return f.getAbsolutePath().replace("\\", "/");
    }

    public void toGraphic(File f, int width, int height, String ... commands) {
        if (f.getName().endsWith(GRAPHIC_BMP)) {
            this.toBMP(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_JPEG)) {
            this.toJPEG(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_PNG)) {
            this.toPNG(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_TIFF)) {
            this.toTIFF(f, width, height, commands);
        } else {
            this.toPNG(f, width, height, commands);
        }
    }

    public void toJPEG(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_JPEG, commands);
    }

    public void toPNG(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_PNG, commands);
    }

    public void toBMP(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_BMP, commands);
    }

    public void toTIFF(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_TIFF, commands);
    }

    public String asR2HTML(String command) {
        String ret = this.installPackage("R2HTML", true);
        if (!ret.equals(PACKAGELOADED)) {
            return ret;
        }
        int h = Math.abs(command.hashCode());
        this.note_code("HTML(" + command + ")");
        this.silentlyRawEval("HTML(file=\"htmlfile_" + h + "\", " + command + ")");
        String[] lines = null;
        try {
            lines = this.asStrings(this.silentlyRawEval("readLines(\"htmlfile_" + h + "\")"));
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (lines == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String l : lines) {
            sb.append(l);
            sb.append("\n");
        }
        String str = sb.toString();
        str = str.replace("align= center ", "align='center'");
        str = str.replace("cellspacing=0", "cellspacing='0'");
        str = str.replace("border=1", "border='1'");
        str = str.replace("align=bottom", "align='bottom'");
        str = str.replace("class=dataframe", "class='dataframe'");
        str = str.replace("class= firstline ", "class='firstline'");
        str = str.replace("class=firstcolumn", "class='firstcolumn'");
        str = str.replace("class=cellinside", "class='cellinside'");
        str = str.replace("border=0", "border='0'");
        str = str.replace("class=captiondataframe", "class='captiondataframe'");
        str = str.replace("</td></table>", "</td></tr></table>");
        return str;
    }

    public String asHTML(String command) {
        return Rsession.toHTML(this.print(command));
    }

    public static String toHTML(String src) {
        if (src == null) {
            return src;
        }
        src = src.replace("&", "&amp;");
        src = src.replace("\"", "&quot;");
        src = src.replace("'", "&apos;");
        src = src.replace("<", "&lt;");
        src = src.replace(">", "&gt;");
        return "<html>" + src.replace("\n", "<br/>") + "</html>";
    }

    public String print(String command) {
        try {
            this.note_code("print(" + command + ")");
            String s = this.asString(this.silentlyRawEval("paste(capture.output(print(" + command + ")),collapse='\\n')"));
            return s;
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public synchronized Object proxyEval(String expression, Map<String, Object> vars) throws RException {
        if (expression.length() == 0) {
            return null;
        }
        try {
            double d = Double.parseDouble(expression);
            this.log("[cache] No evaluation needed for " + expression, RLog.Level.INFO);
            return d;
        }
        catch (NumberFormatException ne) {
            if (!Rsession.uses(expression, vars) && this.noVarsEvals.containsKey(expression)) {
                this.log("[cache] Cached evaluation of " + expression + " in " + this.noVarsEvals, RLog.Level.INFO);
                return this.noVarsEvals.get(expression);
            }
            if (vars != null && vars.containsKey(expression)) {
                this.log("[cache] Get evaluation of " + expression + " in " + vars, RLog.Level.INFO);
                return vars.get(expression);
            }
            HashMap<String, Object> clean_vars = new HashMap<String, Object>();
            String clean_expression = expression;
            if (vars != null) {
                for (String v : vars.keySet()) {
                    if (vars.get(v) instanceof Number) {
                        while (Rsession.containsVar(clean_expression, v)) {
                            clean_expression = Rsession.replaceVar(clean_expression, v, "(" + vars.get(v) + ")");
                        }
                        this.log("[cache] Replacing " + v + " in " + clean_expression, RLog.Level.INFO);
                        continue;
                    }
                    if (!Rsession.containsVar(clean_expression, v)) continue;
                    String newvarname = v;
                    while (this.ls(newvarname).length > 0) {
                        newvarname = "_" + newvarname;
                    }
                    this.log("[cache] Renaming " + v + " by " + newvarname + " in " + clean_expression, RLog.Level.INFO);
                    while (Rsession.containsVar(clean_expression, v)) {
                        clean_expression = Rsession.replaceVar(clean_expression, v, newvarname);
                    }
                    clean_vars.put(newvarname, vars.get(v));
                }
            }
            if (!Rsession.uses(clean_expression, clean_vars) && this.noVarsEvals.containsKey(clean_expression)) {
                this.log("[cache] Cached evaluation of " + expression + " in " + this.noVarsEvals, RLog.Level.INFO);
                return this.noVarsEvals.get(clean_expression);
            }
            Object out = null;
            try {
                if (Rsession.uses(clean_expression, clean_vars)) {
                    this.set(clean_vars);
                }
                this.log("[cache] True evaluation of " + clean_expression + " with " + clean_vars, RLog.Level.INFO);
                out = this.eval(clean_expression);
                if (clean_vars.isEmpty() && out != null) {
                    this.log("[cache] Saving result of " + clean_expression, RLog.Level.INFO);
                    this.noVarsEvals.put(clean_expression, out);
                }
                if (!Rsession.uses(expression, vars) && out != null) {
                    this.log("[cache] Saving result of " + expression, RLog.Level.INFO);
                    this.noVarsEvals.put(expression, out);
                }
            }
            catch (Exception e) {
                this.log("[cache] Failed cast of " + expression, RLog.Level.INFO);
                throw new RException(CAST_ERROR + expression + ": " + e.getMessage());
            }
            finally {
                if (Rsession.uses(clean_expression, clean_vars)) {
                    this.unset(clean_vars.keySet());
                }
            }
            return out;
        }
    }

    static String replaceVar(String expr, String var, String val) {
        String regexp = AW + var + Az;
        Matcher m = Pattern.compile(regexp).matcher(expr);
        if (m.find()) {
            return expr.replace(m.group(), m.group().replace(var, val));
        }
        return expr;
    }

    static boolean containsVar(String expr, String var) {
        String regexp = AW + var + Az;
        Matcher m = Pattern.compile(regexp).matcher(expr);
        return m.find();
    }

    static boolean areUsed(String expression, Set<String> vars) {
        for (String v : vars) {
            if (!Rsession.containsVar(expression, v)) continue;
            return true;
        }
        return false;
    }

    static boolean uses(String expression, Map<String, Object> vars) {
        return vars != null && !vars.isEmpty() && Rsession.areUsed(expression, vars.keySet());
    }

    public abstract void setGlobalEnv(String var1);

    public String getGlobalEnv() {
        return this.envName.substring(2, this.envName.length() - 2);
    }

    public abstract void copyGlobalEnv(String var1);

    protected String hash(Object k) {
        return Integer.toString(Math.abs(k.hashCode()));
    }

    public class Function {
        String name;

        public Function(String name) {
            this.name = name;
        }

        public Object evaluate() throws RException {
            return Rsession.this.eval(this.name + "()");
        }

        public Object evaluate(Object ... args) throws RException {
            String[] x = new String[args.length];
            String arg = "";
            for (int i = 0; i < x.length; ++i) {
                Rsession.this.set(".x" + i, args[i]);
                arg = arg + ",.x" + i;
            }
            return Rsession.this.eval(this.name + "(" + arg.substring(1) + ")");
        }
    }

    public static class RException
    extends Exception {
        public RException(String cause) {
            this(cause, null, false);
        }

        public RException(String cause, Rsession r, boolean details) {
            super(cause + (r == null ? "" : "\nR: " + r.getLastLogEntry() + "\nR! " + r.getLastError() + (details ? "\nR: " + Arrays.asList(r.ls()) : "")));
        }
    }
}

