/*
 * Decompiled with CFR 0.152.
 */
package com.github.yev;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class FailTestScreenshotListener<T>
extends TestListenerAdapter {
    private static String currentDir = null;

    public void onTestFailure(ITestResult tr) {
        super.onTestFailure(tr);
        WebDriver webDriver = this.findWebDriverByReflection(tr.getInstance());
        if (webDriver == null) {
            System.err.println(String.format("The test class '%s' does not have any field/method of type 'org.openqa.selenium.WebDriver'. ScreenshotTestListener can not continue.", tr.getInstance().getClass().getName()));
            return;
        }
        File f = (File)((TakesScreenshot)webDriver).getScreenshotAs(OutputType.FILE);
        try {
            long timestamp = new Date().getTime();
            Path screenshotPath = Paths.get(currentDir, "target", "screenshot_" + tr.getMethod().getMethodName() + "_" + timestamp + ".png");
            System.out.println("copying " + screenshotPath);
            Files.copy(f.toPath(), screenshotPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("error during the screenshot copy file operation:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebDriver findWebDriverByReflection(Object obj) {
        Class<?> c = obj.getClass();
        Field[] fields = c.getDeclaredFields();
        WebDriver webDriver = null;
        for (Field eachField : fields) {
            eachField.setAccessible(true);
            if (eachField.getType() != WebDriver.class) continue;
            try {
                webDriver = (WebDriver)eachField.get(obj);
                break;
            }
            catch (IllegalAccessException e) {
                System.err.println(String.format("error accessing [%s] property of the [%s] instance", eachField.getName(), obj.getClass().getName()));
                WebDriver webDriver2 = null;
                return webDriver2;
            }
            finally {
                eachField.setAccessible(false);
            }
        }
        if (webDriver == null) {
            webDriver = FailTestScreenshotListener.tryToFindWebDriverInPublic(obj);
        }
        if (webDriver == null) {
            webDriver = FailTestScreenshotListener.tryToFindWebDriverInPrivate(obj);
        }
        return webDriver;
    }

    private static WebDriver tryToFindWebDriverInPublic(Object obj) {
        Object webDriver = null;
        Method[] methods = obj.getClass().getMethods();
        return FailTestScreenshotListener.processMethods(methods, obj);
    }

    private static WebDriver tryToFindWebDriverInPrivate(Object obj) {
        Object webDriver = null;
        Method[] methods = obj.getClass().getDeclaredMethods();
        return FailTestScreenshotListener.processMethods(methods, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WebDriver processMethods(Method[] methods, Object obj) {
        for (Method eachMethod : methods) {
            if (eachMethod.getReturnType() != WebDriver.class) continue;
            eachMethod.setAccessible(true);
            try {
                WebDriver webDriver = (WebDriver)eachMethod.invoke(obj, new Object[0]);
                return webDriver;
            }
            catch (Exception e) {
                System.err.println(String.format("error accessing [%s] method of the [%s] instance. Error: %s", eachMethod.getName(), obj.getClass().getName(), e.getMessage()));
            }
            finally {
                eachMethod.setAccessible(false);
            }
        }
        return null;
    }

    static {
        try {
            currentDir = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            System.err.println("Error while detecting current working dir. Reason:" + e.getMessage());
        }
    }
}

