/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.logback.flume;

import ch.qos.logback.core.spi.ContextAware;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventReporter {
    private final ContextAware loggingContext;
    private final ExecutorService es;
    private final Properties connectionProps;
    private RpcClient client;

    public EventReporter(Properties properties, ContextAware contextAware, int n, int n2) {
        ArrayBlockingQueue<Runnable> arrayBlockingQueue = new ArrayBlockingQueue<Runnable>(n2);
        this.connectionProps = properties;
        this.loggingContext = contextAware;
        int n3 = 1;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        int n4 = 30;
        ThreadPoolExecutor.AbortPolicy abortPolicy = new ThreadPoolExecutor.AbortPolicy();
        this.es = new ThreadPoolExecutor(n3, n, (long)n4, timeUnit, arrayBlockingQueue, abortPolicy);
    }

    public void report(Event[] eventArray) {
        this.es.submit(new ReportingJob(eventArray));
    }

    private synchronized RpcClient createClient() {
        if (this.client == null) {
            this.loggingContext.addInfo("Creating a new Flume Client with properties: " + this.connectionProps);
            try {
                this.client = RpcClientFactory.getInstance((Properties)this.connectionProps);
            }
            catch (Exception exception) {
                this.loggingContext.addError(exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return this.client;
    }

    public synchronized void close() {
        this.loggingContext.addInfo("Shutting down Flume client");
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void shutdown() {
        this.close();
        this.es.shutdown();
    }

    private class ReportingJob
    implements Runnable {
        private static final int retries = 3;
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final Event[] events;

        public ReportingJob(Event[] eventArray) {
            this.events = eventArray;
            this.logger.debug("Created a job containing {} events", (Object)eventArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            int n = 0;
            try {
                while (!bl && n < 3) {
                    ++n;
                    try {
                        this.logger.debug("Reporting a batch of {} events, try {}", (Object)this.events.length, (Object)n);
                        EventReporter.this.createClient().appendBatch(Arrays.asList(this.events));
                        bl = true;
                        this.logger.debug("Successfully reported a batch of {} events", (Object)this.events.length);
                    }
                    catch (EventDeliveryException eventDeliveryException) {
                        this.logger.warn(eventDeliveryException.getLocalizedMessage(), (Throwable)eventDeliveryException);
                        this.logger.warn("Will retry " + (3 - n) + " times");
                    }
                }
            }
            finally {
                if (!bl) {
                    this.logger.error("Could not submit events to Flume");
                    EventReporter.this.close();
                }
            }
        }
    }
}

