/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.logback.flume;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.ContextAware;
import com.github.yingzhuo.logback.flume.FlumeAvroManager;
import com.github.yingzhuo.logback.flume.RemoteFlumeAgent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.event.EventBuilder;

@Deprecated
public class FlumeLogstashV1Appender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    protected static final Charset UTF_8 = StandardCharsets.UTF_8;
    protected Layout<ILoggingEvent> layout;
    private FlumeAvroManager flumeManager;
    private String flumeAgents;
    private String flumeProperties;
    private Long reportingWindow;
    private Integer batchSize;
    private Integer reporterMaxThreadPoolSize;
    private Integer reporterMaxQueueSize;
    private Map<String, String> additionalAvroHeaders;
    private String application;
    private String hostname;
    private String type;

    public void setType(String string) {
        this.type = string;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setApplication(String string) {
        this.application = string;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public void setFlumeAgents(String string) {
        this.flumeAgents = string;
    }

    public void setFlumeProperties(String string) {
        this.flumeProperties = string;
    }

    public void setAdditionalAvroHeaders(String string) {
        this.additionalAvroHeaders = this.extractProperties(string);
    }

    public void setBatchSize(String string) {
        try {
            this.batchSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.addWarn("Cannot set the batchSize to " + string, numberFormatException);
        }
    }

    public void setReportingWindow(String string) {
        try {
            this.reportingWindow = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.addWarn("Cannot set the reportingWindow to " + string, numberFormatException);
        }
    }

    public void setReporterMaxThreadPoolSize(String string) {
        try {
            this.reporterMaxThreadPoolSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.addWarn("Cannot set the reporterMaxThreadPoolSize to " + string, numberFormatException);
        }
    }

    public void setReporterMaxQueueSize(String string) {
        try {
            this.reporterMaxQueueSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.addWarn("Cannot set the reporterMaxQueueSize to " + string, numberFormatException);
        }
    }

    public void start() {
        if (this.layout == null) {
            this.addWarn("Layout was not defined, will only log the message, no stack traces or custom layout");
        }
        if (StringUtils.isEmpty((String)this.application)) {
            this.application = this.resolveApplication();
        }
        if (StringUtils.isNotEmpty((String)this.flumeAgents)) {
            String[] stringArray = this.flumeAgents.split(",");
            ArrayList<RemoteFlumeAgent> arrayList = new ArrayList<RemoteFlumeAgent>(stringArray.length);
            for (String string : stringArray) {
                RemoteFlumeAgent remoteFlumeAgent = RemoteFlumeAgent.fromString(string.trim());
                if (remoteFlumeAgent != null) {
                    arrayList.add(remoteFlumeAgent);
                    continue;
                }
                this.addWarn("Cannot build a Flume agent config for '" + string + "'");
            }
            Properties properties = new Properties();
            properties.putAll(this.extractProperties(this.flumeProperties));
            this.flumeManager = FlumeAvroManager.create(arrayList, properties, this.batchSize, this.reportingWindow, this.reporterMaxThreadPoolSize, this.reporterMaxQueueSize, (ContextAware)this);
        } else {
            this.addError("Cannot configure a flume agent with an empty configuration");
        }
        super.start();
    }

    private Map<String, String> extractProperties(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length == 2) {
                    String string3 = stringArray2[0].trim();
                    String string4 = stringArray2[1].trim();
                    if (StringUtils.isNotEmpty((String)string3) && StringUtils.isNotEmpty((String)string4)) {
                        hashMap.put(string3, string4);
                        continue;
                    }
                    this.addWarn("Empty key or value not accepted: " + string2);
                    continue;
                }
                this.addWarn("Not a valid {key}:{value} format: " + string2);
            }
        } else {
            this.addInfo("Not overriding any flume agent properties");
        }
        return hashMap;
    }

    public void stop() {
        try {
            if (this.flumeManager != null) {
                this.flumeManager.stop();
            }
        }
        catch (FlumeException flumeException) {
            this.addWarn(flumeException.getMessage(), flumeException);
        }
    }

    protected void append(ILoggingEvent iLoggingEvent) {
        if (this.flumeManager != null) {
            try {
                String string = this.layout != null ? this.layout.doLayout((Object)iLoggingEvent) : iLoggingEvent.getFormattedMessage();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (this.additionalAvroHeaders != null) {
                    hashMap.putAll(this.additionalAvroHeaders);
                }
                hashMap.putAll(this.extractHeaders(iLoggingEvent));
                Event event = EventBuilder.withBody((String)string.trim(), (Charset)UTF_8, hashMap);
                this.flumeManager.send(event);
            }
            catch (Exception exception) {
                this.addError(exception.getLocalizedMessage(), exception);
            }
        }
    }

    private Map<String, String> extractHeaders(ILoggingEvent iLoggingEvent) {
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        hashMap.put("timestamp", Long.toString(iLoggingEvent.getTimeStamp()));
        hashMap.put("type", iLoggingEvent.getLevel().toString());
        hashMap.put("logger", iLoggingEvent.getLoggerName());
        hashMap.put("message", iLoggingEvent.getMessage());
        hashMap.put("level", iLoggingEvent.getLevel().toString());
        try {
            hashMap.put("host", this.resolveHostname());
        }
        catch (UnknownHostException unknownHostException) {
            this.addWarn(unknownHostException.getMessage());
        }
        hashMap.put("thread", iLoggingEvent.getThreadName());
        if (StringUtils.isNotEmpty((String)this.application)) {
            hashMap.put("application", this.application);
        }
        if (StringUtils.isNotEmpty((String)this.type)) {
            hashMap.put("type", this.type);
        }
        return hashMap;
    }

    private String resolveHostname() throws UnknownHostException {
        return this.hostname != null ? this.hostname : InetAddress.getLocalHost().getHostName();
    }

    private String resolveApplication() {
        return System.getProperty("application.name");
    }
}

