/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.logback.flume;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFlumeAgent {
    private static final Logger log = LoggerFactory.getLogger(RemoteFlumeAgent.class);
    private final String hostname;
    private final Integer port;

    public RemoteFlumeAgent(String string, Integer n) {
        this.hostname = string;
        this.port = n;
    }

    public static RemoteFlumeAgent fromString(String string) {
        if (StringUtils.isEmpty((String)string)) {
            log.error("Empty flume agent entry, an extra comma?");
            return null;
        }
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            log.error("Not a valid [host]:[port] configuration: " + string);
            return null;
        }
        try {
            String string2 = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            return new RemoteFlumeAgent(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Not a valid int: " + stringArray[1]);
            return null;
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }
}

