/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.bean.classpath;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class ClassDefinition
implements BeanDefinition,
Comparable<ClassDefinition>,
Serializable {
    private final Class<?> clazz;
    private final BeanDefinition delegating;

    public ClassDefinition(BeanDefinition beanDefinition) {
        this(beanDefinition, null);
    }

    public ClassDefinition(BeanDefinition beanDefinition, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)beanDefinition, (String)"beanDefinition is required");
        classLoader = Objects.requireNonNullElseGet(classLoader, ClassUtils::getDefaultClassLoader);
        this.delegating = beanDefinition;
        String string = beanDefinition.getBeanClassName();
        Assert.notNull((Object)string, (String)"className is null");
        try {
            this.clazz = ClassUtils.forName((String)string, (ClassLoader)classLoader);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Cannot load class: '" + string + "'");
        }
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public TypeDescriptor getBeanTypeDescriptor() {
        return TypeDescriptor.valueOf(this.getBeanClass());
    }

    public MergedAnnotations getMergedAnnotations() {
        return MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).withRepeatableContainers(RepeatableContainers.none()).from(this.clazz);
    }

    public <A extends Annotation> MergedAnnotation<A> getMergedAnnotation(Class<A> clazz) {
        return this.getMergedAnnotations().get(clazz);
    }

    public <A extends Annotation> boolean isAnnotationPresent(Class<A> clazz) {
        return this.getMergedAnnotations().isPresent(clazz);
    }

    public <A extends Annotation> boolean isAnnotationPresentDirectly(Class<A> clazz) {
        return this.getMergedAnnotations().isDirectlyPresent(clazz);
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return (A)AnnotationUtils.getAnnotation(this.clazz, clazz);
    }

    public <A extends Annotation> A getRequiredAnnotation(Class<A> clazz) {
        A a = this.getAnnotation(clazz);
        return (A)((Annotation)Objects.requireNonNull(a));
    }

    public <A extends Annotation> AnnotationAttributes getAnnotationAttributes(Class<A> clazz) {
        return this.getAnnotationAttributes(clazz, false, false);
    }

    public <A extends Annotation> AnnotationAttributes getAnnotationAttributes(Class<A> clazz, boolean bl) {
        return this.getAnnotationAttributes(clazz, bl, false);
    }

    public <A extends Annotation> AnnotationAttributes getAnnotationAttributes(Class<A> clazz, boolean bl, boolean bl2) {
        try {
            Annotation annotation = AnnotationUtils.findAnnotation(this.clazz, clazz);
            if (annotation == null) {
                return new AnnotationAttributes(clazz);
            }
            return AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)bl, (boolean)bl2);
        }
        catch (Exception exception) {
            return new AnnotationAttributes(clazz);
        }
    }

    @Override
    public int compareTo(@Nullable ClassDefinition classDefinition) {
        String string = this.getBeanClassName();
        String string2 = Optional.ofNullable(classDefinition).map(ClassDefinition::getBeanClassName).orElse(null);
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return 1;
        }
        if (string2 == null) {
            return -1;
        }
        return string.compareTo(string2);
    }

    public String toString() {
        return "ClassDefinition[" + this.getBeanClassName() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClassDefinition classDefinition = (ClassDefinition)object;
        return this.clazz.equals(classDefinition.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.clazz);
    }

    @Nullable
    public String getParentName() {
        return this.delegating.getParentName();
    }

    public void setParentName(String string) {
        this.delegating.setParentName(string);
    }

    @Nullable
    public String getBeanClassName() {
        return this.delegating.getBeanClassName();
    }

    public void setBeanClassName(String string) {
        this.delegating.setBeanClassName(string);
    }

    public String getScope() {
        return this.delegating.getScope();
    }

    @Nullable
    public void setScope(String string) {
        this.delegating.setScope(string);
    }

    public boolean isLazyInit() {
        return this.delegating.isLazyInit();
    }

    public void setLazyInit(boolean bl) {
        this.delegating.setLazyInit(bl);
    }

    @Nullable
    public String[] getDependsOn() {
        return this.delegating.getDependsOn();
    }

    public void setDependsOn(String ... stringArray) {
        this.delegating.setDependsOn(stringArray);
    }

    public boolean isAutowireCandidate() {
        return this.delegating.isAutowireCandidate();
    }

    public void setAutowireCandidate(boolean bl) {
        this.delegating.setAutowireCandidate(bl);
    }

    public boolean isPrimary() {
        return this.delegating.isPrimary();
    }

    public void setPrimary(boolean bl) {
        this.delegating.setPrimary(bl);
    }

    @Nullable
    public String getFactoryBeanName() {
        return this.delegating.getFactoryBeanName();
    }

    public void setFactoryBeanName(String string) {
        this.delegating.setFactoryBeanName(string);
    }

    @Nullable
    public String getFactoryMethodName() {
        return this.delegating.getFactoryMethodName();
    }

    public void setFactoryMethodName(String string) {
        this.delegating.setFactoryMethodName(string);
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        return this.delegating.getConstructorArgumentValues();
    }

    public MutablePropertyValues getPropertyValues() {
        return this.delegating.getPropertyValues();
    }

    @Nullable
    public String getInitMethodName() {
        return this.delegating.getInitMethodName();
    }

    public void setInitMethodName(String string) {
        this.delegating.setInitMethodName(string);
    }

    public String getDestroyMethodName() {
        return this.delegating.getDestroyMethodName();
    }

    public void setDestroyMethodName(String string) {
        this.delegating.setDestroyMethodName(string);
    }

    public int getRole() {
        return this.delegating.getRole();
    }

    public void setRole(int n) {
        this.delegating.setRole(n);
    }

    @Nullable
    public String getDescription() {
        return this.delegating.getDescription();
    }

    public void setDescription(String string) {
        this.delegating.setDescription(string);
    }

    public ResolvableType getResolvableType() {
        return this.delegating.getResolvableType();
    }

    public boolean isSingleton() {
        return this.delegating.isSingleton();
    }

    public boolean isPrototype() {
        return this.delegating.isPrototype();
    }

    public boolean isAbstract() {
        return this.delegating.isAbstract();
    }

    @Nullable
    public String getResourceDescription() {
        return this.delegating.getDescription();
    }

    @Nullable
    public BeanDefinition getOriginatingBeanDefinition() {
        return this.delegating.getOriginatingBeanDefinition();
    }

    public void setAttribute(String string, Object object) {
        this.delegating.setAttribute(string, object);
    }

    public Object getAttribute(String string) {
        return this.delegating.getAttribute(string);
    }

    public Object removeAttribute(String string) {
        return this.delegating.removeAttribute(string);
    }

    public boolean hasAttribute(String string) {
        return this.delegating.hasAttribute(string);
    }

    public String[] attributeNames() {
        return this.delegating.attributeNames();
    }

    public boolean hasConstructorArgumentValues() {
        return this.delegating.hasConstructorArgumentValues();
    }

    public boolean hasPropertyValues() {
        return this.delegating.hasPropertyValues();
    }

    public Object getSource() {
        return this.delegating.getSource();
    }

    public boolean isFallback() {
        return this.delegating.isFallback();
    }

    public void setFallback(boolean bl) {
        this.delegating.setFallback(bl);
    }
}

