/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.bean.classpath;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.io.ApplicationResourceLoader;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import spring.turbo.bean.classpath.ClassPathScanner;
import spring.turbo.bean.classpath.DefaultClassPathScanner;
import spring.turbo.util.ClassUtils;
import spring.turbo.util.collection.CollectionUtils;

public final class ClassPathScannerBuilder {
    private final List<TypeFilter> includeFilters = new LinkedList<TypeFilter>();
    private final List<TypeFilter> excludeFilters = new LinkedList<TypeFilter>();
    private Environment environment = new StandardEnvironment();
    private ResourceLoader resourceLoader = ApplicationResourceLoader.get();
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    ClassPathScannerBuilder() {
    }

    public ClassPathScannerBuilder includeFilter(TypeFilter ... typeFilterArray) {
        CollectionUtils.nullSafeAddAll(this.includeFilters, typeFilterArray);
        return this;
    }

    public ClassPathScannerBuilder excludeFilter(TypeFilter ... typeFilterArray) {
        CollectionUtils.nullSafeAddAll(this.excludeFilters, typeFilterArray);
        return this;
    }

    public ClassPathScannerBuilder environment(@Nullable Environment environment) {
        this.environment = environment = Objects.requireNonNullElseGet(environment, StandardEnvironment::new);
        return this;
    }

    public ClassPathScannerBuilder resourceLoader(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader = Objects.requireNonNullElseGet(resourceLoader, DefaultResourceLoader::new);
        return this;
    }

    public ClassPathScannerBuilder classLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader = Objects.requireNonNullElseGet(classLoader, ClassUtils::getDefaultClassLoader);
        return this;
    }

    public ClassPathScanner build() {
        if (this.includeFilters.isEmpty()) {
            return packageSet -> List.of();
        }
        DefaultClassPathScanner defaultClassPathScanner = new DefaultClassPathScanner();
        defaultClassPathScanner.setIncludeTypeFilters(this.includeFilters);
        defaultClassPathScanner.setExcludeTypeFilters(this.excludeFilters);
        defaultClassPathScanner.setEnvironment(this.environment);
        defaultClassPathScanner.setResourceLoader(this.resourceLoader);
        defaultClassPathScanner.setClassLoader(this.classLoader);
        return defaultClassPathScanner;
    }
}

