/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.bean.classpath;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;
import spring.turbo.bean.classpath.ClassDefinition;
import spring.turbo.bean.classpath.ClassPathScanner;
import spring.turbo.bean.classpath.PackageSet;
import spring.turbo.util.ClassUtils;
import spring.turbo.util.collection.CollectionUtils;

final class DefaultClassPathScanner
implements ClassPathScanner {
    private final ClassPathScannerCore provider = new ClassPathScannerCore();
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    DefaultClassPathScanner() {
    }

    @Override
    public List<ClassDefinition> scan(@Nullable PackageSet packageSet) {
        if (packageSet == null) {
            return List.of();
        }
        ArrayList arrayList = new ArrayList();
        for (String string : packageSet) {
            CollectionUtils.nullSafeAddAll(arrayList, this.provider.findCandidateComponents(string));
        }
        return arrayList.stream().map(beanDefinition -> new ClassDefinition((BeanDefinition)beanDefinition, this.classLoader)).distinct().sorted(Comparator.naturalOrder()).toList();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.provider.setResourceLoader(resourceLoader);
    }

    public void setEnvironment(Environment environment) {
        this.provider.setEnvironment(environment);
    }

    public void setIncludeTypeFilters(List<TypeFilter> list) {
        list.forEach(arg_0 -> ((ClassPathScannerCore)this.provider).addIncludeFilter(arg_0));
    }

    public void setExcludeTypeFilters(List<TypeFilter> list) {
        list.forEach(arg_0 -> ((ClassPathScannerCore)this.provider).addExcludeFilter(arg_0));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static final class ClassPathScannerCore
    extends ClassPathScanningCandidateComponentProvider {
        private ClassPathScannerCore() {
            super(false);
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition annotatedBeanDefinition) {
            boolean bl = false;
            if (annotatedBeanDefinition.getMetadata().isIndependent() && !annotatedBeanDefinition.getMetadata().isAnnotation()) {
                bl = true;
            }
            return bl;
        }
    }
}

