/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.bean.classpath;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import spring.turbo.util.StringUtils;

public final class PackageSet
implements Iterable<String>,
Serializable {
    private final SortedSet<String> innerSet = new TreeSet<String>();

    private PackageSet() {
    }

    public static PackageSet newInstance() {
        return new PackageSet();
    }

    public PackageSet acceptPackages(String ... stringArray) {
        if (stringArray != null) {
            Stream.of(stringArray).filter(StringUtils::isNotBlank).map(String::trim).forEach(this.innerSet::add);
        }
        return this;
    }

    public PackageSet acceptPackages(@Nullable Collection<String> collection) {
        if (collection != null) {
            collection.stream().filter(StringUtils::isNotBlank).map(String::trim).forEach(this.innerSet::add);
        }
        return this;
    }

    public PackageSet acceptBaseClasses(Class<?> ... classArray) {
        if (classArray != null) {
            Arrays.stream(classArray).filter(Objects::nonNull).map(clazz -> clazz.getPackage().getName()).forEach(this.innerSet::add);
        }
        return this;
    }

    public PackageSet acceptBaseClasses(@Nullable Collection<Class<?>> collection) {
        if (collection != null) {
            collection.stream().filter(Objects::nonNull).map(clazz -> clazz.getPackage().getName()).forEach(this.innerSet::add);
        }
        return this;
    }

    public PackageSet clear() {
        this.innerSet.clear();
        return this;
    }

    @Override
    public Iterator<String> iterator() {
        return this.innerSet.iterator();
    }

    public boolean isEmpty() {
        return this.innerSet.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.innerSet.isEmpty();
    }

    public int size() {
        return this.innerSet.size();
    }

    public SortedSet<String> asSet() {
        return this.innerSet;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PackageSet packageSet = (PackageSet)object;
        return this.innerSet.equals(packageSet.innerSet);
    }

    public int hashCode() {
        return Objects.hash(this.innerSet);
    }

    public String toString() {
        return this.innerSet.toString();
    }
}

