/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.bean.classpath;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AbstractClassTestingTypeFilter;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import spring.turbo.util.collection.CollectionUtils;

public final class TypeFilterFactories {
    private TypeFilterFactories() {
    }

    public static TypeFilter hasAnnotation(Class<? extends Annotation> clazz) {
        return TypeFilterFactories.hasAnnotation(clazz, true, true);
    }

    public static TypeFilter hasAnnotation(Class<? extends Annotation> clazz, boolean bl, boolean bl2) {
        Assert.notNull(clazz, (String)"annotationType is required");
        return new AnnotationTypeFilter(clazz, bl, bl2);
    }

    public static TypeFilter assignable(Class<?> clazz) {
        return new AssignableTypeFilter(clazz);
    }

    public static TypeFilter fullyQualifiedNameEquals(String string) {
        return TypeFilterFactories.fullyQualifiedNameEquals(string, false);
    }

    public static TypeFilter fullyQualifiedNameEquals(String string, boolean bl) {
        Assert.hasText((String)string, (String)"className is required");
        if (bl) {
            return (metadataReader, metadataReaderFactory) -> string.equalsIgnoreCase(metadataReader.getClassMetadata().getClassName());
        }
        return (metadataReader, metadataReaderFactory) -> string.equals(metadataReader.getClassMetadata().getClassName());
    }

    public static TypeFilter fullyQualifiedNameMatches(Pattern pattern) {
        Assert.notNull((Object)pattern, (String)"pattern is required");
        return new RegexPatternTypeFilter(pattern);
    }

    public static TypeFilter isInterface() {
        AbstractClassTestingTypeFilter abstractClassTestingTypeFilter = new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata classMetadata) {
                return classMetadata.isInterface();
            }
        };
        TypeFilter typeFilter = TypeFilterFactories.isNotPackageInfo();
        return TypeFilterFactories.all(new TypeFilter[]{abstractClassTestingTypeFilter, typeFilter});
    }

    public static TypeFilter isNotInterface() {
        return TypeFilterFactories.not(TypeFilterFactories.isInterface());
    }

    public static TypeFilter isAbstract() {
        return new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata classMetadata) {
                return classMetadata.isAbstract();
            }
        };
    }

    public static TypeFilter isConcrete() {
        return new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata classMetadata) {
                return classMetadata.isConcrete();
            }
        };
    }

    public static TypeFilter isAnnotation() {
        return new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata classMetadata) {
                return classMetadata.isAnnotation();
            }
        };
    }

    public static TypeFilter isNotAnnotation() {
        return TypeFilterFactories.not(TypeFilterFactories.isAnnotation());
    }

    public static TypeFilter isFinal() {
        return new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata classMetadata) {
                return classMetadata.isFinal();
            }
        };
    }

    public static TypeFilter isNotFinal() {
        return TypeFilterFactories.not(TypeFilterFactories.isFinal());
    }

    public static TypeFilter isIndependent() {
        return new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata classMetadata) {
                return classMetadata.isIndependent();
            }
        };
    }

    public static TypeFilter hasSuperClass() {
        return new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata classMetadata) {
                return classMetadata.hasSuperClass();
            }
        };
    }

    public static TypeFilter isInnerClass() {
        return new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata classMetadata) {
                return classMetadata.hasEnclosingClass();
            }
        };
    }

    public static TypeFilter isNotInnerClass() {
        return TypeFilterFactories.not(TypeFilterFactories.isInnerClass());
    }

    public static TypeFilter implementsInterface(final Class<?> clazz) {
        Assert.notNull(clazz, (String)"annotationType is required");
        return new AbstractTypeHierarchyTraversingFilter(true, true){

            protected Boolean matchInterface(String string) {
                return clazz.getName().equals(string);
            }
        };
    }

    public static TypeFilter notImplementsInterface(Class<?> clazz) {
        return TypeFilterFactories.not(TypeFilterFactories.implementsInterface(clazz));
    }

    public static TypeFilter isPackageInfo() {
        return TypeFilterFactories.all(TypeFilterFactories.isInterface(), TypeFilterFactories.fullyQualifiedNameMatches(Pattern.compile("^.*package-info$")));
    }

    public static TypeFilter isNotPackageInfo() {
        return TypeFilterFactories.not(TypeFilterFactories.isPackageInfo());
    }

    public static TypeFilter not(TypeFilter typeFilter) {
        Assert.notNull((Object)typeFilter, (String)"filter is required");
        return (metadataReader, metadataReaderFactory) -> !typeFilter.match(metadataReader, metadataReaderFactory);
    }

    public static TypeFilter any(TypeFilter ... typeFilterArray) {
        Assert.notNull((Object)typeFilterArray, (String)"filters is null");
        Assert.noNullElements((Object[])typeFilterArray, (String)"filters has null element(s)");
        return new Any(Arrays.asList(typeFilterArray));
    }

    public static TypeFilter all(TypeFilter ... typeFilterArray) {
        Assert.notNull((Object)typeFilterArray, (String)"filters is null");
        Assert.noNullElements((Object[])typeFilterArray, (String)"filters has null element(s)");
        return new All(Arrays.asList(typeFilterArray));
    }

    public static TypeFilter alwaysTrue() {
        return (metadataReader, metadataReaderFactory) -> true;
    }

    public static TypeFilter alwaysFalse() {
        return (metadataReader, metadataReaderFactory) -> false;
    }

    private static final class Any
    implements TypeFilter {
        private final List<TypeFilter> list = new LinkedList<TypeFilter>();

        public Any(List<TypeFilter> list) {
            CollectionUtils.nullSafeAddAll(this.list, list);
            Assert.isTrue((this.list.size() >= 2 ? 1 : 0) != 0, (String)"list size must greater than 1");
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            if (CollectionUtils.isEmpty(this.list)) {
                return false;
            }
            for (TypeFilter typeFilter : this.list) {
                if (!typeFilter.match(metadataReader, metadataReaderFactory)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class All
    implements TypeFilter {
        private final List<TypeFilter> list = new LinkedList<TypeFilter>();

        public All(List<TypeFilter> list) {
            CollectionUtils.nullSafeAddAll(this.list, list);
            Assert.isTrue((this.list.size() >= 2 ? 1 : 0) != 0, (String)"list size must greater than 1");
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            if (CollectionUtils.isEmpty(this.list)) {
                return false;
            }
            for (TypeFilter typeFilter : this.list) {
                if (typeFilter.match(metadataReader, metadataReaderFactory)) continue;
                return false;
            }
            return true;
        }
    }
}

