/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;

public final class AnnotationHelper {
    private AnnotationHelper() {
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> clazz2) {
        return (A)AnnotationUtils.findAnnotation(clazz, clazz2);
    }

    public static <A extends Annotation> A findRequiredAnnotation(Class<?> clazz, Class<A> clazz2) {
        A a = AnnotationHelper.findAnnotation(clazz, clazz2);
        return (A)((Annotation)Objects.requireNonNull(a));
    }

    public static <A extends Annotation> AnnotationAttributes findAnnotationAttributes(Class<?> clazz, Class<A> clazz2) {
        return AnnotationHelper.findAnnotationAttributes(clazz, clazz2, false, false);
    }

    public static <A extends Annotation> AnnotationAttributes findAnnotationAttributes(Class<?> clazz, Class<A> clazz2, boolean bl, boolean bl2) {
        A a = AnnotationHelper.findAnnotation(clazz, clazz2);
        if (a == null) {
            return new AnnotationAttributes();
        }
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes(a, (boolean)bl, (boolean)bl2));
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(Method method, Class<A> clazz) {
        return (A)AnnotationUtils.findAnnotation((Method)method, clazz);
    }

    public static <A extends Annotation> A findRequiredAnnotation(Method method, Class<A> clazz) {
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method, clazz);
        return (A)Objects.requireNonNull(annotation);
    }

    public static <A extends Annotation> AnnotationAttributes findAnnotationAttributes(Method method, Class<A> clazz) {
        return AnnotationHelper.findAnnotationAttributes(method, clazz, false, false);
    }

    public static <A extends Annotation> AnnotationAttributes findAnnotationAttributes(Method method, Class<A> clazz, boolean bl, boolean bl2) {
        A a = AnnotationHelper.findAnnotation(method, clazz);
        if (a == null) {
            return new AnnotationAttributes();
        }
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes(a, (boolean)bl, (boolean)bl2));
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(Field field, Class<A> clazz) {
        return (A)AnnotationUtils.findAnnotation((AnnotatedElement)field, clazz);
    }

    public static <A extends Annotation> A findRequiredAnnotation(Field field, Class<A> clazz) {
        Annotation annotation = AnnotationUtils.findAnnotation((AnnotatedElement)field, clazz);
        return (A)Objects.requireNonNull(annotation);
    }

    public static <A extends Annotation> AnnotationAttributes findAnnotationAttributes(Field field, Class<A> clazz) {
        return AnnotationHelper.findAnnotationAttributes(field, clazz, false, false);
    }

    public static <A extends Annotation> AnnotationAttributes findAnnotationAttributes(Field field, Class<A> clazz, boolean bl, boolean bl2) {
        A a = AnnotationHelper.findAnnotation(field, clazz);
        if (a == null) {
            return new AnnotationAttributes();
        }
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes(a, (boolean)bl, (boolean)bl2));
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(Constructor<?> constructor, Class<A> clazz) {
        return (A)AnnotationUtils.findAnnotation(constructor, clazz);
    }

    public static <A extends Annotation> A findRequiredAnnotation(Constructor<?> constructor, Class<A> clazz) {
        A a = AnnotationHelper.findAnnotation(constructor, clazz);
        return (A)((Annotation)Objects.requireNonNull(a));
    }

    public static <A extends Annotation> AnnotationAttributes findAnnotationAttributes(Constructor<?> constructor, Class<A> clazz) {
        return AnnotationHelper.findAnnotationAttributes(constructor, clazz, false, false);
    }

    public static <A extends Annotation> AnnotationAttributes findAnnotationAttributes(Constructor<?> constructor, Class<A> clazz, boolean bl, boolean bl2) {
        A a = AnnotationHelper.findAnnotation(constructor, clazz);
        if (a == null) {
            return new AnnotationAttributes();
        }
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes(a, (boolean)bl, (boolean)bl2));
    }

    public static <A extends Annotation> AnnotationAttributes toAnnotationAttributes(@Nullable A a) {
        return AnnotationHelper.toAnnotationAttributes(a, false, false);
    }

    public static <A extends Annotation> AnnotationAttributes toAnnotationAttributes(@Nullable A a, boolean bl, boolean bl2) {
        if (a == null) {
            return new AnnotationAttributes();
        }
        return AnnotationUtils.getAnnotationAttributes(a, (boolean)bl, (boolean)bl2);
    }
}

