/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.core.SpEL;

public final class AspectSpELTemplate<T>
implements Serializable {
    private final String expression;
    private final Map<String, Object> expressionVariables;
    @Nullable
    private Object rootObject;

    private AspectSpELTemplate(String string, ProceedingJoinPoint proceedingJoinPoint) {
        Assert.hasText((String)string, (String)"expression is required");
        Assert.notNull((Object)proceedingJoinPoint, (String)"joinPoint is required");
        this.expression = string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("args", proceedingJoinPoint.getArgs());
        hashMap.put("argsLength", proceedingJoinPoint.getArgs().length);
        hashMap.put("method", ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod());
        hashMap.put("methodName", ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod().getName());
        hashMap.put("target", proceedingJoinPoint.getTarget());
        hashMap.put("targetType", proceedingJoinPoint.getTarget().getClass().getName());
        this.expressionVariables = Collections.unmodifiableMap(hashMap);
    }

    public static AspectSpELTemplate<String> newInstance(String string, ProceedingJoinPoint proceedingJoinPoint) {
        return AspectSpELTemplate.newInstance(string, proceedingJoinPoint, String.class);
    }

    public static <R> AspectSpELTemplate<R> newInstance(String string, ProceedingJoinPoint proceedingJoinPoint, Class<R> clazz) {
        Assert.notNull(clazz, (String)"returnType is required");
        return new AspectSpELTemplate(string, proceedingJoinPoint);
    }

    public AspectSpELTemplate<T> setRootObject(@Nullable Object object) {
        this.rootObject = object;
        return this;
    }

    public T getValue() {
        return SpEL.getValue(this.expression, this.rootObject, this.expressionVariables);
    }

    public Map<String, Object> getExpressionVariables() {
        return this.expressionVariables;
    }
}

