/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.core.AnnotationHelper;

public final class AspectUtils {
    private AspectUtils() {
    }

    public static Method getMethod(JoinPoint joinPoint) {
        Assert.notNull((Object)joinPoint, (String)"joinPoint is required");
        Signature signature2 = joinPoint.getSignature();
        return Optional.ofNullable(signature2).map(signature -> {
            if (signature instanceof MethodSignature) {
                MethodSignature methodSignature = (MethodSignature)signature;
                return methodSignature.getMethod();
            }
            return null;
        }).orElseThrow(() -> new IllegalArgumentException("Cannot get proxies method"));
    }

    public static Object getTarget(JoinPoint joinPoint) {
        Assert.notNull((Object)joinPoint, (String)"joinPoint is required");
        Object object = joinPoint.getTarget();
        return Optional.ofNullable(object).orElseThrow(() -> new IllegalArgumentException("Cannot get proxies target"));
    }

    public static Class<?> getTargetType(JoinPoint joinPoint) {
        return AspectUtils.getTarget(joinPoint).getClass();
    }

    @Nullable
    public static <A extends Annotation> A getMethodAnnotation(JoinPoint joinPoint, Class<A> clazz) {
        Method method = AspectUtils.getMethod(joinPoint);
        return AnnotationHelper.findAnnotation(method, clazz);
    }

    public static <A extends Annotation> AnnotationAttributes getMethodAnnotationAttributes(JoinPoint joinPoint, Class<A> clazz) {
        Method method = AspectUtils.getMethod(joinPoint);
        return AnnotationHelper.findAnnotationAttributes(method, clazz);
    }

    public static <A extends Annotation> AnnotationAttributes getMethodAnnotationAttributes(JoinPoint joinPoint, Class<A> clazz, boolean bl, boolean bl2) {
        Method method = AspectUtils.getMethod(joinPoint);
        return AnnotationHelper.findAnnotationAttributes(method, clazz, bl, bl2);
    }

    @Nullable
    public static <A extends Annotation> A getObjectTypeAnnotation(JoinPoint joinPoint, Class<A> clazz) {
        Class<?> clazz2 = AspectUtils.getTargetType(joinPoint);
        return AnnotationHelper.findAnnotation(clazz2, clazz);
    }

    public static AnnotationAttributes getTargetTypeAnnotationAttributes(JoinPoint joinPoint, Class<? extends Annotation> clazz, boolean bl, boolean bl2) {
        Class<?> clazz2 = AspectUtils.getTargetType(joinPoint);
        return AnnotationHelper.findAnnotationAttributes(clazz2, clazz, bl, bl2);
    }
}

