/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.core.SpringUtils;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    public static boolean canConvert(Class<?> clazz, Class<?> clazz2) {
        Assert.notNull(clazz, (String)"sourceType is required");
        Assert.notNull(clazz2, (String)"targetType is required");
        return SpringUtils.getConversionService().canConvert(clazz, clazz2);
    }

    public static boolean canConvert(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        Assert.notNull((Object)typeDescriptor, (String)"sourceType is required");
        Assert.notNull((Object)typeDescriptor2, (String)"targetType is required");
        return SpringUtils.getConversionService().canConvert(typeDescriptor, typeDescriptor2);
    }

    @Nullable
    public static <T> T convert(Object object, Class<T> clazz) {
        Assert.notNull((Object)object, (String)"source is required");
        Assert.notNull(clazz, (String)"targetType is required");
        return (T)SpringUtils.getConversionService().convert(object, clazz);
    }

    public static <T> T convertOrThrow(Object object, Class<T> clazz) {
        T t = ConversionUtils.convert(object, clazz);
        Assert.notNull(t, (String)"cannot convert");
        return t;
    }
}

