/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core;

import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.core.SpringUtils;

public final class EnvironmentUtils {
    private EnvironmentUtils() {
    }

    public static String resolvePlaceholders(String string) {
        Assert.hasText((String)string, (String)"text is required");
        return SpringUtils.getEnvironment().resolvePlaceholders(string);
    }

    public static String resolveRequiredPlaceholders(String string) {
        Assert.hasText((String)string, (String)"text is required");
        return SpringUtils.getEnvironment().resolveRequiredPlaceholders(string);
    }

    @Nullable
    public static String getPropertyValue(String string) {
        return EnvironmentUtils.getPropertyValue(string, String.class);
    }

    public static String getRequiredPropertyValue(String string) {
        String string2 = EnvironmentUtils.getPropertyValue(string);
        return Objects.requireNonNull(string2);
    }

    @Nullable
    public static <T> T getPropertyValue(String string, Class<T> clazz) {
        return EnvironmentUtils.getPropertyValue(string, clazz, null);
    }

    public static <T> T getRequiredPropertyValue(String string, Class<T> clazz) {
        T t = EnvironmentUtils.getPropertyValue(string, clazz);
        return Objects.requireNonNull(t);
    }

    @Nullable
    public static <T> T getPropertyValue(String string, Class<T> clazz, @Nullable T t) {
        Assert.hasText((String)string, (String)"propertyName is required");
        Assert.notNull(clazz, (String)"targetType is required");
        Object object = SpringUtils.getEnvironment().getProperty(string, clazz);
        return (T)(object != null ? object : t);
    }

    public static <T> T getRequiredPropertyValue(String string, Class<T> clazz, @Nullable T t) {
        T t2 = EnvironmentUtils.getPropertyValue(string, clazz, t);
        return Objects.requireNonNull(t2);
    }
}

