/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.io.ApplicationResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.WritableResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import spring.turbo.util.io.CloseUtils;

public final class ResourceUtils {
    private static final ResourceLoader RESOURCE_LOADER = ApplicationResourceLoader.get((ClassLoader)ClassUtils.getDefaultClassLoader());
    private static final ResourcePatternResolver RESOURCE_PATTERN_RESOLVER = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)RESOURCE_LOADER);

    private ResourceUtils() {
    }

    public static ResourceLoader getResourceLoader() {
        return RESOURCE_LOADER;
    }

    public static ResourcePatternResolver getResourcePatternResolver() {
        return RESOURCE_PATTERN_RESOLVER;
    }

    public static Resource loadResource(String string) {
        Assert.hasText((String)string, (String)"location is required");
        return RESOURCE_LOADER.getResource(string);
    }

    public static InputStream loadResourceAsInputStream(String string) {
        try {
            return ResourceUtils.loadResource(string).getInputStream();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Nullable
    public static Resource loadFirstExistsResource(@Nullable Iterable<String> iterable) {
        if (iterable == null) {
            return null;
        }
        for (String string : iterable) {
            if (!StringUtils.hasText((String)string)) continue;
            try {
                Resource resource = RESOURCE_LOADER.getResource(string);
                if (!resource.exists()) continue;
                return resource;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static List<Resource> loadResources(String string) {
        try {
            return Arrays.asList(RESOURCE_PATTERN_RESOLVER.getResources(string));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static String readResourceAsString(String string) {
        return ResourceUtils.readResourceAsString(string, null);
    }

    public static String readResourceAsString(String string, @Nullable Charset charset) {
        try {
            charset = Objects.requireNonNullElse(charset, StandardCharsets.UTF_8);
            return ResourceUtils.loadResource(string).getContentAsString(charset);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static byte[] readResourceAsBytes(String string) {
        try {
            Resource resource = ResourceUtils.loadResource(string);
            return resource.getContentAsByteArray();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void close(@Nullable Resource resource) {
        if (resource == null) {
            return;
        }
        if (resource.isOpen()) {
            try {
                CloseUtils.closeQuietly(resource.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (resource instanceof WritableResource) {
            WritableResource writableResource = (WritableResource)resource;
            try {
                CloseUtils.closeQuietly(writableResource.getOutputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

