/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.WebApplicationType;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.MessageSource;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;
import spring.turbo.core.env.SpringApplicationHolders;

public final class SpringUtils {
    public static final Supplier<? extends RuntimeException> NOT_SUPPORTED = () -> new UnsupportedOperationException("operation not supported yet");

    private SpringUtils() {
    }

    public static ApplicationContext getApplicationContext() {
        return Optional.ofNullable(SpringApplicationHolders.getApplicationContext()).orElseThrow(NOT_SUPPORTED);
    }

    public static Path getApplicationHome() {
        return Optional.ofNullable(SpringApplicationHolders.getApplicationHome()).orElseThrow(NOT_SUPPORTED);
    }

    public static String getApplicationHomeAsString() {
        return SpringUtils.getApplicationHome().toString();
    }

    public static Set<Object> getApplicationSources() {
        return Optional.ofNullable(SpringApplicationHolders.getApplicationSources()).orElseGet(HashSet::new);
    }

    public static WebApplicationType getApplicationWebApplicationType() {
        return Optional.ofNullable(SpringApplicationHolders.getApplicationWebApplicationType()).orElseThrow(NOT_SUPPORTED);
    }

    public static String getApplicationContextId() {
        String string = SpringUtils.getApplicationContext().getId();
        return Optional.ofNullable(string).orElseThrow(NOT_SUPPORTED);
    }

    public static BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return (BeanDefinitionRegistry)SpringUtils.getApplicationContext().getAutowireCapableBeanFactory();
    }

    public static Environment getEnvironment() {
        return SpringUtils.getApplicationContext().getEnvironment();
    }

    public static ApplicationArguments getApplicationArguments() {
        return (ApplicationArguments)SpringUtils.getApplicationContext().getBean(ApplicationArguments.class);
    }

    public static ConversionService getConversionService() {
        return (ConversionService)SpringUtils.getApplicationContext().getBean(ConversionService.class);
    }

    public static ApplicationEventPublisher getApplicationEventPublisher() {
        return SpringUtils.getApplicationContext();
    }

    public static Validator getValidator() {
        return (Validator)SpringUtils.getApplicationContext().getBean(Validator.class);
    }

    public static MessageSource getMessageSource() {
        return SpringUtils.getApplicationContext();
    }

    public static <T> Optional<T> getBean(Class<T> clazz) {
        Assert.notNull(clazz, (String)"beanType is required");
        try {
            return Optional.of(SpringUtils.getApplicationContext().getBean(clazz));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static <T> Optional<T> getBean(Class<T> clazz, String string) {
        Assert.notNull(clazz, (String)"beanType is required");
        Assert.hasText((String)string, (String)"beanName is required");
        try {
            return Optional.of(SpringUtils.getApplicationContext().getBean(string, clazz));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static <T> T getRequiredBean(Class<T> clazz) {
        return SpringUtils.getBean(clazz).orElseThrow(NOT_SUPPORTED);
    }

    public static <T> T getRequiredBean(Class<T> clazz, String string) {
        return SpringUtils.getBean(clazz, string).orElseThrow(NOT_SUPPORTED);
    }

    public static <T> List<T> getBeanList(Class<T> clazz) {
        return SpringUtils.getApplicationContext().getBeansOfType(clazz).values().stream().toList();
    }
}

