/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core;

import org.springframework.util.Assert;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import spring.turbo.core.SpringUtils;
import spring.turbo.util.StringFormatter;

public final class ValidatorUtils {
    private ValidatorUtils() {
    }

    public static boolean support(Class<?> clazz) {
        Assert.notNull(clazz, (String)"targetType is required");
        Validator validator = SpringUtils.getValidator();
        return validator.supports(clazz);
    }

    public static BindingResult validate(Object object) {
        Assert.notNull((Object)object, (String)"obj is required");
        String string = StringFormatter.format("bean[{}]", (Object)System.identityHashCode(object));
        BeanPropertyBindingResult beanPropertyBindingResult = new BeanPropertyBindingResult(object, string);
        Validator validator = SpringUtils.getValidator();
        validator.validate(object, (Errors)beanPropertyBindingResult);
        return beanPropertyBindingResult;
    }
}

