/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core.env;

import java.util.HashMap;
import java.util.Optional;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import spring.turbo.core.env.SpringApplicationHolders;
import spring.turbo.util.CurrentProcess;

public class MiscPropertiesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("spring.process.pid", CurrentProcess.pid());
        hashMap.put("spring.process.parent-pid", CurrentProcess.parentPid());
        hashMap.put("spring.process.user", CurrentProcess.user());
        Optional.ofNullable(SpringApplicationHolders.getApplicationHome()).ifPresent(path -> hashMap.put("spring.application.home", path.toAbsolutePath().toString()));
        MapPropertySource mapPropertySource = new MapPropertySource("spring-turbo-misc", hashMap);
        configurableEnvironment.getPropertySources().addLast((PropertySource)mapPropertySource);
    }

    public int getOrder() {
        return 2147483547;
    }
}

