/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core.env;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.Nullable;
import spring.turbo.util.collection.CollectionUtils;

public final class SpringApplicationHolders {
    @Nullable
    private static ApplicationContext APPLICATION_CONTEXT;
    @Nullable
    private static Path APPLICATION_HOME;
    @Nullable
    private static Set<Object> APPLICATION_SOURCES;
    @Nullable
    private static WebApplicationType APPLICATION_WEB_APPLICATION_TYPE;

    private SpringApplicationHolders() {
    }

    @Nullable
    public static ApplicationContext getApplicationContext() {
        return APPLICATION_CONTEXT;
    }

    @Nullable
    public static Path getApplicationHome() {
        return APPLICATION_HOME;
    }

    @Nullable
    public static Set<Object> getApplicationSources() {
        return APPLICATION_SOURCES;
    }

    @Nullable
    public static WebApplicationType getApplicationWebApplicationType() {
        return APPLICATION_WEB_APPLICATION_TYPE;
    }

    private static class Hook
    implements EnvironmentPostProcessor,
    ApplicationListener<ContextRefreshedEvent>,
    PriorityOrdered {
        private Hook() {
        }

        public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
            APPLICATION_HOME = this.getAppHomeDir(springApplication).toAbsolutePath();
            APPLICATION_SOURCES = springApplication.getAllSources();
            APPLICATION_WEB_APPLICATION_TYPE = springApplication.getWebApplicationType();
        }

        public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
            APPLICATION_CONTEXT = contextRefreshedEvent.getApplicationContext();
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        private Path getAppHomeDir(SpringApplication springApplication) {
            List<Class> list = springApplication.getAllSources().stream().filter(object -> object instanceof Class).map(object -> (Class)object).toList();
            File file = CollectionUtils.size(list) == 1 ? new ApplicationHome(list.get(0)).getDir() : new ApplicationHome().getDir();
            return file.toPath();
        }
    }
}

