/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

abstract class AbstractZipProtocolResolver
implements ProtocolResolver {
    private final String prefix;

    public AbstractZipProtocolResolver(String string) {
        this.prefix = string;
    }

    @Nullable
    public final Resource resolve(String string, ResourceLoader resourceLoader) {
        String[] stringArray;
        if (StringUtils.startsWithIgnoreCase((String)string, (String)this.prefix) && (stringArray = StringUtils.delimitedListToStringArray((String)string.substring(this.prefix.length()), (String)"!")).length == 2) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                return this.doResolve(string2, string3, resourceLoader);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        return null;
    }

    private Resource doResolve(String string, String string2, ResourceLoader resourceLoader) throws IOException {
        Resource resource = resourceLoader.getResource(string);
        try (ZipFile zipFile = new ZipFile(resource.getFile());){
            ZipEntry zipEntry = zipFile.getEntry(string2);
            ByteArrayResource byteArrayResource = new ByteArrayResource(StreamUtils.copyToByteArray((InputStream)zipFile.getInputStream(zipEntry)));
            return byteArrayResource;
        }
    }
}

