/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.core.resource;

import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import spring.turbo.util.HexUtils;

final class HexProtocolResolver
implements ProtocolResolver {
    private static final String HEX_PREFIX = "hex:";

    HexProtocolResolver() {
    }

    @Nullable
    public Resource resolve(String string, ResourceLoader resourceLoader) {
        if (string.startsWith(HEX_PREFIX)) {
            String string2 = string.substring(HEX_PREFIX.length());
            return new ByteArrayResource(HexUtils.decodeToBytes(string2));
        }
        return null;
    }
}

