/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.databinding;

import org.springframework.core.convert.converter.Converter;
import spring.turbo.databinding.InternalConverterUtils;
import spring.turbo.exception.DataBindingException;
import spring.turbo.util.concurrent.ThreadSharedObjects;

public abstract class AbstractConverter<S, T>
implements Converter<S, T> {
    public final T convert(S s) {
        try {
            return this.doConvert(s);
        }
        catch (RuntimeException runtimeException) {
            throw InternalConverterUtils.transform(runtimeException);
        }
    }

    protected abstract T doConvert(S var1) throws DataBindingException;

    protected final <O> void setSharedObject(Class<O> clazz, O o) {
        ThreadSharedObjects.put(clazz, o);
    }

    protected final void setSharedObject(String string, Object object) {
        ThreadSharedObjects.put(string, object);
    }
}

