/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.databinding;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import spring.turbo.databinding.InternalConverterUtils;
import spring.turbo.exception.DataBindingException;
import spring.turbo.util.collection.ArrayUtils;
import spring.turbo.util.concurrent.ThreadSharedObjects;

public abstract class AbstractGenericConverter
implements GenericConverter {
    private final Set<GenericConverter.ConvertiblePair> convertibleTypes;

    public AbstractGenericConverter(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
        hashSet.add(new GenericConverter.ConvertiblePair(clazz, clazz2));
        if (!ArrayUtils.isNullOrEmpty(classArray)) {
            for (Class<?> clazz3 : classArray) {
                hashSet.add(new GenericConverter.ConvertiblePair(clazz, clazz3));
            }
        }
        this.convertibleTypes = Collections.unmodifiableSet(hashSet);
    }

    public AbstractGenericConverter(MultiValueMap<Class<?>, Class<?>> multiValueMap) {
        HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
        if (!CollectionUtils.isEmpty(multiValueMap)) {
            for (Class clazz : multiValueMap.keySet()) {
                for (Class clazz2 : (List)multiValueMap.get((Object)clazz)) {
                    hashSet.add(new GenericConverter.ConvertiblePair(clazz, clazz2));
                }
            }
        }
        this.convertibleTypes = Collections.unmodifiableSet(hashSet);
    }

    public final Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertibleTypes;
    }

    @Nullable
    public final Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        try {
            return this.doConvert(object, typeDescriptor, typeDescriptor2);
        }
        catch (RuntimeException runtimeException) {
            throw InternalConverterUtils.transform(runtimeException);
        }
    }

    @Nullable
    protected abstract Object doConvert(@Nullable Object var1, TypeDescriptor var2, TypeDescriptor var3) throws DataBindingException;

    protected final <O> void setSharedObject(Class<O> clazz, O o) {
        ThreadSharedObjects.put(clazz, o);
    }

    protected final void setSharedObject(String string, Object object) {
        ThreadSharedObjects.put(string, object);
    }
}

