/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.databinding;

import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.util.StringUtils;
import spring.turbo.databinding.MultiMessageSourceResolvable;
import spring.turbo.exception.DataBindingException;

final class InternalConverterUtils {
    private InternalConverterUtils() {
    }

    public static <T extends RuntimeException> RuntimeException transform(T t) {
        Throwable throwable;
        if (t instanceof MessageSourceResolvable || t instanceof MultiMessageSourceResolvable) {
            return t;
        }
        String string = t.getMessage();
        if (!StringUtils.hasText((String)string) && (throwable = NestedExceptionUtils.getRootCause(t)) != null) {
            string = throwable.getMessage();
        }
        if (StringUtils.hasText((String)string)) {
            return DataBindingException.of(string, new String[0]);
        }
        return t;
    }
}

