/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.databinding;

import org.springframework.beans.PropertyAccessException;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.ObjectError;
import spring.turbo.databinding.MultiMessageSourceResolvable;

public final class SmartBindingErrorProcessor
extends DefaultBindingErrorProcessor {
    private SmartBindingErrorProcessor() {
    }

    public static SmartBindingErrorProcessor getInstance() {
        return SyncAvoid.INSTANCE;
    }

    public void processPropertyAccessException(PropertyAccessException propertyAccessException, BindingResult bindingResult) {
        Object object = propertyAccessException.getRootCause();
        if (object instanceof MessageSourceResolvable) {
            MessageSourceResolvable messageSourceResolvable = (MessageSourceResolvable)object;
            bindingResult.addError(new ObjectError(bindingResult.getObjectName(), messageSourceResolvable.getCodes(), messageSourceResolvable.getArguments(), messageSourceResolvable.getDefaultMessage()));
            return;
        }
        object = propertyAccessException.getRootCause();
        if (object instanceof MultiMessageSourceResolvable) {
            MultiMessageSourceResolvable multiMessageSourceResolvable = (MultiMessageSourceResolvable)object;
            for (MessageSourceResolvable messageSourceResolvable : multiMessageSourceResolvable) {
                if (messageSourceResolvable == null) continue;
                bindingResult.addError(new ObjectError(bindingResult.getObjectName(), messageSourceResolvable.getCodes(), messageSourceResolvable.getArguments(), messageSourceResolvable.getDefaultMessage()));
            }
            return;
        }
        super.processPropertyAccessException(propertyAccessException, bindingResult);
    }

    private static class SyncAvoid {
        private static final SmartBindingErrorProcessor INSTANCE = new SmartBindingErrorProcessor();

        private SyncAvoid() {
        }
    }
}

