/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.exception;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.core.LocaleUtils;
import spring.turbo.core.SpringUtils;
import spring.turbo.messagesource.StringMessageSourceResolvable;
import spring.turbo.util.StringUtils;
import spring.turbo.util.collection.ArrayUtils;

public abstract class AbstractMessageResolvableException
extends IllegalArgumentException
implements MessageSourceResolvable {
    @Nullable
    private final String code;
    @Nullable
    private final Object[] arguments;
    @Nullable
    private final String defaultMessage;

    public AbstractMessageResolvableException(@Nullable String string, @Nullable Object[] objectArray) {
        this(string, objectArray, null);
    }

    public AbstractMessageResolvableException(@Nullable String string) {
        this(null, null, string);
    }

    public AbstractMessageResolvableException(@Nullable String string, @Nullable Object[] objectArray, @Nullable String string2) {
        super(StringUtils.blankToNull(string2));
        this.code = StringUtils.blankToNull(string);
        this.arguments = ArrayUtils.emptyToNull(objectArray);
        this.defaultMessage = StringUtils.blankToNull(string2);
    }

    static String getMessage(@Nullable MessageSource messageSource, MessageSourceResolvable messageSourceResolvable) {
        return AbstractMessageResolvableException.getMessage(messageSource, messageSourceResolvable, null);
    }

    static String getMessage(@Nullable MessageSource messageSource, MessageSourceResolvable messageSourceResolvable, @Nullable Locale locale) {
        Assert.notNull((Object)messageSourceResolvable, (String)"messageSourceResolvable is required");
        if (messageSourceResolvable instanceof StringMessageSourceResolvable) {
            StringMessageSourceResolvable stringMessageSourceResolvable = (StringMessageSourceResolvable)messageSourceResolvable;
            return stringMessageSourceResolvable.getDefaultMessage();
        }
        messageSource = messageSource != null ? messageSource : SpringUtils.getMessageSource();
        locale = locale != null ? locale : LocaleUtils.getLocale(true);
        try {
            return messageSource.getMessage(messageSourceResolvable, locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            String string = messageSourceResolvable.getDefaultMessage();
            if (string != null) {
                return string;
            }
            throw noSuchMessageException;
        }
    }

    @Nullable
    public final String[] getCodes() {
        String[] stringArray;
        if (this.code != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.code;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @Nullable
    public final Object[] getArguments() {
        return this.arguments;
    }

    @Nullable
    public final String getDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public String toString() {
        try {
            return this.toString(null, null);
        }
        catch (Throwable throwable) {
            return super.toString();
        }
    }

    public final String toString(@Nullable MessageSource messageSource) {
        return AbstractMessageResolvableException.getMessage(messageSource, this);
    }

    public final String toString(@Nullable MessageSource messageSource, @Nullable Locale locale) {
        return AbstractMessageResolvableException.getMessage(messageSource, this, locale);
    }
}

