/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.exception;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import spring.turbo.exception.BusinessException;

public final class BusinessAsserts {
    private BusinessAsserts() {
    }

    public static void assertNotNull(@Nullable Object object, String string) {
        if (object == null) {
            throw new BusinessException(string);
        }
    }

    public static void assertNotNull(@Nullable Object object, String string, Object ... objectArray) {
        if (object == null) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static <T> void assertNotEmpty(@Nullable Collection<T> collection, String string) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BusinessException(string);
        }
    }

    public static <T> void assertNotEmpty(@Nullable Collection<T> collection, String string, Object ... objectArray) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static <K, V> void assertNotEmpty(@Nullable Map<K, V> map, String string) {
        if (CollectionUtils.isEmpty(map)) {
            throw new BusinessException(string);
        }
    }

    public static <K, V> void assertNotEmpty(@Nullable Map<K, V> map, String string, Object ... objectArray) {
        if (CollectionUtils.isEmpty(map)) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static <T> void assertNoNullElements(@Nullable Collection<T> collection, String string) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BusinessException(string);
        }
        for (T t : collection) {
            if (t != null) continue;
            throw new BusinessException(string);
        }
    }

    public static <T> void assertNoNullElements(@Nullable Collection<T> collection, String string, Object ... objectArray) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BusinessException(string, objectArray);
        }
        for (T t : collection) {
            if (t != null) continue;
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertNotEmpty(@Nullable CharSequence charSequence, String string) {
        if (!StringUtils.hasLength((CharSequence)charSequence)) {
            throw new BusinessException(string);
        }
    }

    public static void assertNotEmpty(@Nullable CharSequence charSequence, String string, Object ... objectArray) {
        if (!StringUtils.hasLength((CharSequence)charSequence)) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertNotBlank(@Nullable CharSequence charSequence, String string) {
        if (!StringUtils.hasText((CharSequence)charSequence)) {
            throw new BusinessException(string);
        }
    }

    public static void assertNotBlank(@Nullable CharSequence charSequence, String string, Object ... objectArray) {
        if (!StringUtils.hasText((CharSequence)charSequence)) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertPositive(@Nullable Number number, String string) {
        if (number == null || number.doubleValue() <= 0.0) {
            throw new BusinessException(string);
        }
    }

    public static void assertPositive(@Nullable Number number, String string, Object ... objectArray) {
        if (number == null || number.doubleValue() <= 0.0) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertPositiveOrZero(@Nullable Number number, String string) {
        if (number == null || number.doubleValue() < 0.0) {
            throw new BusinessException(string);
        }
    }

    public static void assertPositiveOrZero(@Nullable Number number, String string, Object ... objectArray) {
        if (number == null || number.doubleValue() < 0.0) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertZero(@Nullable Number number, String string) {
        if (number == null || number.doubleValue() != 0.0) {
            throw new BusinessException(string);
        }
    }

    public static void assertZero(@Nullable Number number, String string, Object ... objectArray) {
        if (number == null || number.doubleValue() != 0.0) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertNegative(@Nullable Number number, String string) {
        if (number == null || number.doubleValue() >= 0.0) {
            throw new BusinessException(string);
        }
    }

    public static void assertNegative(@Nullable Number number, String string, Object ... objectArray) {
        if (number == null || number.doubleValue() >= 0.0) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertNegativeOrZero(@Nullable Number number, String string) {
        if (number == null || number.doubleValue() > 0.0) {
            throw new BusinessException(string);
        }
    }

    public static void assertNegativeOrZero(@Nullable Number number, String string, Object ... objectArray) {
        if (number == null || number.doubleValue() > 0.0) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertEquals(@Nullable Object object, @Nullable Object object2, String string) {
        if (!Objects.equals(object, object2)) {
            throw new BusinessException(string);
        }
    }

    public static void assertEquals(@Nullable Object object, @Nullable Object object2, String string, Object ... objectArray) {
        if (!Objects.equals(object, object2)) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertSameObject(@Nullable Object object, @Nullable Object object2, String string) {
        if (object != object2) {
            throw new BusinessException(string);
        }
    }

    public static void assertSameObject(@Nullable Object object, @Nullable Object object2, String string, Object ... objectArray) {
        if (object != object2) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertTrue(boolean bl, String string) {
        if (!bl) {
            throw new BusinessException(string);
        }
    }

    public static void assertTrue(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new BusinessException(string, objectArray);
        }
    }

    public static void assertFalse(boolean bl, String string) {
        if (bl) {
            throw new BusinessException(string);
        }
    }

    public static void assertFalse(boolean bl, String string, Object ... objectArray) {
        if (bl) {
            throw new BusinessException(string, objectArray);
        }
    }
}

