/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import spring.turbo.databinding.MultiMessageSourceResolvable;
import spring.turbo.exception.AbstractMessageResolvableException;
import spring.turbo.messagesource.SimpleMessageSourceResolvable;
import spring.turbo.messagesource.StringMessageSourceResolvable;
import spring.turbo.util.StringFormatter;
import spring.turbo.util.StringUtils;
import spring.turbo.util.collection.CollectionUtils;
import spring.turbo.util.collection.iterator.NoopComparator;

public final class DataBindingException
extends IllegalArgumentException
implements MultiMessageSourceResolvable {
    private final List<MessageSourceResolvable> innerList = new ArrayList<MessageSourceResolvable>();

    private DataBindingException() {
    }

    public static void raiseIfNecessary(@Nullable Errors errors) {
        if (errors != null && errors.hasErrors()) {
            DataBindingException dataBindingException = new DataBindingException();
            CollectionUtils.nullSafeAddAll(dataBindingException.innerList, errors.getAllErrors().stream().map(objectError -> objectError).toList());
            throw dataBindingException;
        }
    }

    public static void raiseIfNecessary(@Nullable BindingResult bindingResult) {
        DataBindingException.raiseIfNecessary((Errors)bindingResult);
    }

    public static DataBindingException of(String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringUtils.blankSafeAdd(arrayList, string);
        StringUtils.blankSafeAddAll(arrayList, stringArray);
        DataBindingException dataBindingException = new DataBindingException();
        dataBindingException.innerList.addAll(arrayList.stream().map(StringMessageSourceResolvable::new).toList());
        return dataBindingException;
    }

    public static DataBindingException of(MessageSourceResolvable messageSourceResolvable, MessageSourceResolvable ... messageSourceResolvableArray) {
        ArrayList arrayList = new ArrayList();
        CollectionUtils.nullSafeAdd(arrayList, messageSourceResolvable);
        CollectionUtils.nullSafeAddAll(arrayList, messageSourceResolvableArray);
        DataBindingException dataBindingException = new DataBindingException();
        dataBindingException.innerList.addAll(arrayList);
        return dataBindingException;
    }

    public static DataBindingException of(Collection<MessageSourceResolvable> collection) {
        DataBindingException dataBindingException = new DataBindingException();
        CollectionUtils.nullSafeAddAll(dataBindingException.innerList, collection);
        return dataBindingException;
    }

    public static DataBindingException ofCode(String string) {
        return DataBindingException.ofCode(string, null, null);
    }

    public static DataBindingException ofCode(String string, Object ... objectArray) {
        return DataBindingException.ofCode(string, objectArray, null);
    }

    public static DataBindingException ofCode(String string, @Nullable Object[] objectArray, @Nullable String string2) {
        Assert.hasText((String)string, (String)"code is required");
        DataBindingException dataBindingException = new DataBindingException();
        dataBindingException.innerList.add(new SimpleMessageSourceResolvable(string, objectArray, string2));
        return dataBindingException;
    }

    public static DataBindingException ofFormattedMessage(String string, Object ... objectArray) {
        return DataBindingException.of(StringFormatter.format(string, objectArray), new String[0]);
    }

    @Override
    public Iterator<MessageSourceResolvable> iterator() {
        return this.innerList.iterator();
    }

    public int size() {
        return this.innerList.size();
    }

    public boolean isEmpty() {
        return this.innerList.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.innerList.isEmpty();
    }

    public List<String> getMessages(MessageSource messageSource) {
        return this.getMessages(messageSource, null, null);
    }

    public List<String> getMessages(MessageSource messageSource, @Nullable Locale locale) {
        return this.getMessages(messageSource, locale, null);
    }

    public List<String> getMessages(MessageSource messageSource, @Nullable Locale locale, @Nullable Comparator<String> comparator) {
        return this.stream().map(messageSourceResolvable -> AbstractMessageResolvableException.getMessage(messageSource, messageSourceResolvable, locale)).sorted(Objects.requireNonNullElseGet(comparator, NoopComparator::getInstance)).collect(Collectors.toList());
    }
}

