/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import spring.turbo.util.StringFormatter;

public final class BigDecimalUtils {
    private BigDecimalUtils() {
    }

    public static BigDecimal abs(BigDecimal bigDecimal) {
        Assert.notNull((Object)bigDecimal, (String)"number is required");
        return bigDecimal.abs();
    }

    public static BigDecimal add(BigDecimal bigDecimal, Number number) {
        Assert.notNull((Object)bigDecimal, (String)"number1 is required");
        Assert.notNull((Object)number, (String)"number2 is required");
        return bigDecimal.add((BigDecimal)NumberUtils.convertNumberToTargetClass((Number)number, BigDecimal.class));
    }

    public static BigDecimal subtract(BigDecimal bigDecimal, Number number) {
        Assert.notNull((Object)bigDecimal, (String)"number1 is required");
        Assert.notNull((Object)number, (String)"number2 is required");
        return bigDecimal.subtract((BigDecimal)NumberUtils.convertNumberToTargetClass((Number)number, BigDecimal.class));
    }

    public static BigDecimal multiply(BigDecimal bigDecimal, Number number) {
        Assert.notNull((Object)bigDecimal, (String)"number1 is required");
        Assert.notNull((Object)number, (String)"number2 is required");
        return bigDecimal.multiply((BigDecimal)NumberUtils.convertNumberToTargetClass((Number)number, BigDecimal.class));
    }

    public static BigDecimal divide(BigDecimal bigDecimal, Number number) {
        return BigDecimalUtils.divide(bigDecimal, number, 2, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal bigDecimal, Number number, int n, RoundingMode roundingMode) {
        Assert.notNull((Object)bigDecimal, (String)"number1 is required");
        Assert.notNull((Object)number, (String)"number2 is required");
        Assert.notNull((Object)((Object)roundingMode), (String)"roundingMode is required");
        return bigDecimal.divide((BigDecimal)NumberUtils.convertNumberToTargetClass((Number)number, BigDecimal.class), n, roundingMode);
    }

    public static BigDecimal pow(BigDecimal bigDecimal, int n) {
        Assert.notNull((Object)bigDecimal, (String)"number1 is required");
        return bigDecimal.pow(n);
    }

    public static BigDecimal min(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.notNull((Object)bigDecimal, (String)"number1 is required");
        Assert.notNull((Object)bigDecimal2, (String)"number2 is required");
        return bigDecimal.compareTo(bigDecimal2) < 0 ? bigDecimal : bigDecimal2;
    }

    public static BigDecimal min(BigDecimal ... bigDecimalArray) {
        Assert.notNull((Object)bigDecimalArray, (String)"numbers is required");
        Assert.notEmpty((Object[])bigDecimalArray, (String)"numbers is empty");
        Assert.noNullElements((Object[])bigDecimalArray, (String)"numbers has null element(s)");
        BigDecimal bigDecimal = bigDecimalArray[0];
        for (BigDecimal bigDecimal2 : bigDecimalArray) {
            bigDecimal = BigDecimalUtils.min(bigDecimal, bigDecimal2);
        }
        return bigDecimal;
    }

    public static BigDecimal min(Collection<BigDecimal> collection) {
        Assert.notNull(collection, (String)"numbers is null");
        return BigDecimalUtils.min(collection.toArray(new BigDecimal[0]));
    }

    public static BigDecimal max(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.notNull((Object)bigDecimal, (String)"number1 is required");
        Assert.notNull((Object)bigDecimal2, (String)"number2 is required");
        return bigDecimal.compareTo(bigDecimal2) > 0 ? bigDecimal : bigDecimal2;
    }

    public static BigDecimal max(BigDecimal ... bigDecimalArray) {
        Assert.notNull((Object)bigDecimalArray, (String)"numbers is required");
        Assert.notEmpty((Object[])bigDecimalArray, (String)"numbers is empty");
        Assert.noNullElements((Object[])bigDecimalArray, (String)"numbers has null element(s)");
        BigDecimal bigDecimal = bigDecimalArray[0];
        for (BigDecimal bigDecimal2 : bigDecimalArray) {
            bigDecimal = BigDecimalUtils.max(bigDecimal, bigDecimal2);
        }
        return bigDecimal;
    }

    public static BigDecimal max(Collection<BigDecimal> collection) {
        Assert.notNull(collection, (String)"numbers is required");
        return BigDecimalUtils.max(collection.toArray(new BigDecimal[0]));
    }

    public static BigDecimal nullSafeAdd(BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (bigDecimalArray != null) {
            for (BigDecimal bigDecimal2 : bigDecimalArray) {
                if (bigDecimal2 == null) continue;
                bigDecimal = bigDecimal.add(bigDecimal2);
            }
        }
        return bigDecimal;
    }

    public static BigDecimal nullSafeAdd(@Nullable Collection<BigDecimal> collection) {
        if (collection == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimalUtils.nullSafeAdd(collection.toArray(new BigDecimal[0]));
    }

    public static BigDecimal nullSafeMultiply(BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal = BigDecimal.ONE;
        if (bigDecimalArray != null) {
            for (BigDecimal bigDecimal2 : bigDecimalArray) {
                if (bigDecimal2 == null) continue;
                bigDecimal = bigDecimal.multiply(bigDecimal2);
            }
        }
        return bigDecimal;
    }

    public static BigDecimal nullSafeMultiply(@Nullable Collection<BigDecimal> collection) {
        if (collection == null) {
            return BigDecimal.ONE;
        }
        return BigDecimalUtils.nullSafeMultiply(collection.toArray(new BigDecimal[0]));
    }

    public static <T extends Number> T getValue(BigDecimal bigDecimal, Class<T> clazz) {
        Assert.notNull((Object)bigDecimal, (String)"number is required");
        Assert.notNull(clazz, (String)"numberType is required");
        if (clazz == Byte.class) {
            return (T)Byte.valueOf(bigDecimal.byteValue());
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf(bigDecimal.shortValue());
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(bigDecimal.intValue());
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(bigDecimal.longValue());
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(bigDecimal.floatValue());
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(bigDecimal.doubleValue());
        }
        if (clazz == BigInteger.class) {
            return (T)bigDecimal.toBigInteger();
        }
        if (clazz == BigDecimal.class) {
            return (T)bigDecimal;
        }
        throw new IllegalArgumentException(StringFormatter.format("unsupported number type: {}", (Object)clazz.getName()));
    }
}

