/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.StringUtils;

public final class CharSequenceUtils {
    private CharSequenceUtils() {
    }

    public static int length(@Nullable CharSequence charSequence) {
        return charSequence != null ? charSequence.length() : 0;
    }

    public static CharSequence subSequence(CharSequence charSequence, int n) {
        Assert.notNull((Object)charSequence, (String)"cs is required");
        return charSequence.subSequence(n, charSequence.length());
    }

    public static char[] toCharArray(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            return new char[0];
        }
        int n = StringUtils.length(charSequence.toString());
        if (n == 0) {
            return new char[0];
        }
        if (charSequence instanceof String) {
            return ((String)charSequence).toCharArray();
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = charSequence.charAt(i);
        }
        return cArray;
    }
}

