/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import org.springframework.lang.Nullable;

public final class CharUtils {
    private CharUtils() {
    }

    public static boolean isNull(@Nullable Character c) {
        return c == null;
    }

    public static boolean isNotNull(@Nullable Character c) {
        return c != null;
    }

    public static boolean isWhitespace(@Nullable Character c) {
        return c != null && Character.isWhitespace(c.charValue());
    }

    public static boolean isNotWhitespace(@Nullable Character c) {
        return !CharUtils.isWhitespace(c);
    }

    public static boolean isAscii(@Nullable Character c) {
        if (c == null) {
            return false;
        }
        return c.charValue() < '\u0080';
    }

    public static boolean isAsciiPrintable(@Nullable Character c) {
        if (c == null) {
            return false;
        }
        return c.charValue() >= ' ' && c.charValue() < '\u007f';
    }

    public static boolean isAsciiControl(@Nullable Character c) {
        if (c == null) {
            return false;
        }
        return c.charValue() < ' ' || c.charValue() == '\u007f';
    }

    public static boolean isAsciiAlpha(@Nullable Character c) {
        if (c == null) {
            return false;
        }
        return CharUtils.isAsciiAlphaUpper(c) || CharUtils.isAsciiAlphaLower(c);
    }

    public static boolean isAsciiAlphaUpper(@Nullable Character c) {
        if (c == null) {
            return false;
        }
        return c.charValue() >= 'A' && c.charValue() <= 'Z';
    }

    public static boolean isAsciiAlphaLower(@Nullable Character c) {
        if (c == null) {
            return false;
        }
        return c.charValue() >= 'a' && c.charValue() <= 'z';
    }

    public static boolean isAsciiNumeric(@Nullable Character c) {
        if (c == null) {
            return false;
        }
        return c.charValue() >= '0' && c.charValue() <= '9';
    }

    public static boolean isAsciiAlphanumeric(@Nullable Character c) {
        if (c == null) {
            return false;
        }
        return CharUtils.isAsciiAlpha(c) || CharUtils.isAsciiNumeric(c);
    }
}

