/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.ClassLoadingExceptionSupplier;

public final class ClassUtils {
    @Nullable
    private static final ClassLoader DEFAULT_CLASSLOADER = org.springframework.util.ClassUtils.getDefaultClassLoader();

    private ClassUtils() {
    }

    public static ClassLoader getDefaultClassLoader() {
        return Optional.ofNullable(DEFAULT_CLASSLOADER).orElse(Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> forNameElseThrow(@NonNull String string) {
        return ClassUtils.forNameElseThrow(string, new ClassLoadingExceptionSupplier(string));
    }

    public static Class<?> forNameElseThrow(@NonNull String string, @NonNull Supplier<? extends RuntimeException> supplier) {
        Assert.notNull(supplier, (String)"exceptionIfCannotLoad is required");
        return ClassUtils.forName(string).orElseThrow(supplier);
    }

    public static Optional<Class<?>> forName(String string) {
        try {
            Assert.hasText((String)string, (String)"className is required");
            Class clazz = org.springframework.util.ClassUtils.forName((String)string, (ClassLoader)DEFAULT_CLASSLOADER);
            return Optional.of(clazz);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static boolean isPresent(String string) {
        try {
            Assert.hasText((String)string, (String)"className is required");
            return org.springframework.util.ClassUtils.isPresent((String)string, (ClassLoader)DEFAULT_CLASSLOADER);
        }
        catch (IllegalAccessError illegalAccessError) {
            return false;
        }
    }

    public static boolean isAbsent(String string) {
        return !ClassUtils.isPresent(string);
    }

    public static String getPackageName(Class<?> clazz) {
        return org.springframework.util.ClassUtils.getPackageName(clazz);
    }

    public static String getPackageName(String string) {
        return org.springframework.util.ClassUtils.getPackageName((String)string);
    }
}

