/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.util.Assert;
import spring.turbo.util.HexUtils;

public final class DigestUtils {
    public static final String ALG_MD2 = "MD2";
    public static final String ALG_MD5 = "MD5";
    public static final String ALG_SHA_1 = "SHA-1";
    public static final String ALG_SHA_256 = "SHA-256";
    public static final String ALG_SHA_384 = "SHA-384";
    public static final String ALG_SHA_512 = "SHA-512";

    private DigestUtils() {
    }

    public static byte[] md2(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALG_MD2);
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static String md2Hex(String string) {
        Assert.notNull((Object)string, (String)"data is required");
        return HexUtils.encodeToString(DigestUtils.md2(string.getBytes(StandardCharsets.UTF_8)));
    }

    public static byte[] md5(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALG_MD5);
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static String md5Hex(String string) {
        Assert.notNull((Object)string, (String)"data is required");
        return HexUtils.encodeToString(DigestUtils.md5(string.getBytes(StandardCharsets.UTF_8)));
    }

    public static byte[] sha1(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALG_SHA_1);
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static String sha1Hex(String string) {
        Assert.notNull((Object)string, (String)"data is required");
        return HexUtils.encodeToString(DigestUtils.sha1(string.getBytes(StandardCharsets.UTF_8)));
    }

    public static byte[] sha256(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALG_SHA_256);
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static String sha256Hex(String string) {
        Assert.notNull((Object)string, (String)"data is required");
        return HexUtils.encodeToString(DigestUtils.sha256(string.getBytes(StandardCharsets.UTF_8)));
    }

    public static byte[] sha384(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALG_SHA_384);
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static String sha384Hex(String string) {
        Assert.notNull((Object)string, (String)"data is required");
        return HexUtils.encodeToString(DigestUtils.sha384(string.getBytes(StandardCharsets.UTF_8)));
    }

    public static byte[] sha512(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALG_SHA_512);
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static String sha512Hex(String string) {
        Assert.notNull((Object)string, (String)"data is required");
        return HexUtils.encodeToString(DigestUtils.sha512(string.getBytes(StandardCharsets.UTF_8)));
    }
}

